<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('customization.index') }}"
                    class="rounded-full bg-white p-2 hover:shadow-lg">
                    <span class="text-zinc-900">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold">
                <x-radix-layout class="size-6 inline-block" />
                &nbsp;&nbsp;Edit Layout
            </p>
            <div class="flex items-center col-span-1 place-content-end">
                @if ($username)
                    <a href="{{ route('card.show', $username) }}"
                        class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                        View Card
                    </a>
                @endif
            </div>
        </div>

    </div>

    @if (auth()->user()->user_type != 'Free')
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <div class="flex items-center">
                    <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Button Style
                    </h2>
                </div>

                {{-- <div class="gap-x-6">
                    <form wire:submit.prevent="updateLayout">
                        <div class="col-span-full">
                            <label for="button_style" class="block text-sm/6 font-medium text-gray-900">Country</label>
                            <div class="mt-2">
                                <select id="button_style" wire:model="button_style"
                                    class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-gray-100 py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('button_style') border border-red-600 @enderror">
                                    <option {{ old('button_style', $button_style) === '' ? 'selected' : '' }}>
                                        Select
                                        Style
                                    </option>

                                    <option value="rounded"
                                        {{ old('button_style', $button_style) === 'rounded' ? 'selected' : '' }}>
                                        Rounded
                                    </option>
                                    <option value="squared"
                                        {{ old('button_style', $button_style) === 'squared' ? 'selected' : '' }}>
                                        Squared
                                    </option>

                                </select>
                                <svg class="pointer-events-none col-start-1 row-start-1 mr-2 size-5 self-center justify-self-end text-gray-500 sm:size-4"
                                    viewBox="0 0 16 16" fill="currentColor" aria-hidden="true" data-slot="icon">
                                    <path fill-rule="evenodd"
                                        d="M4.22 6.22a.75.75 0 0 1 1.06 0L8 8.94l2.72-2.72a.75.75 0 1 1 1.06 1.06l-3.25 3.25a.75.75 0 0 1-1.06 0L4.22 7.28a.75.75 0 0 1 0-1.06Z"
                                        clip-rule="evenodd" />
                                </svg>
                            </div>

                            @error('button_style')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                            <button type="submit"
                                class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">Update
                                Profile</button>
                        </div>
                    </form>
                </div> --}}

                <div class="gap-x-6">
                    <form wire:submit.prevent="updateLayout">
                        <div class="col-span-full">
                            {{-- <label for="button_style"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-300">Button
                                Style</label> --}}

                            <div class="relative mt-2 w-full">
                                <select id="button_style" wire:model="button_style"
                                    class="w-full appearance-none rounded-md bg-gray-100 dark:bg-zinc-800 py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-gray-300 focus:outline-2 focus:outline-yellow-600 sm:text-sm/6 @error('button_style') border border-red-600 @enderror">
                                    <option value="">Select Style</option>
                                    <option value="rounded"
                                        {{ old('button_style', $button_style) === 'rounded' ? 'selected' : '' }}>Rounded
                                    </option>
                                    <option value="squared"
                                        {{ old('button_style', $button_style) === 'squared' ? 'selected' : '' }}>Squared
                                    </option>
                                </select>

                                <!-- Dropdown icon -->
                                <svg class="pointer-events-none absolute right-2 top-1/2 -translate-y-1/2 w-4 h-4 text-gray-500 dark:text-gray-400"
                                    viewBox="0 0 16 16" fill="currentColor" aria-hidden="true">
                                    <path fill-rule="evenodd"
                                        d="M4.22 6.22a.75.75 0 0 1 1.06 0L8 8.94l2.72-2.72a.75.75 0 1 1 1.06 1.06l-3.25 3.25a.75.75 0 0 1-1.06 0L4.22 7.28a.75.75 0 0 1 0-1.06Z"
                                        clip-rule="evenodd" />
                                </svg>
                            </div>

                            @error('button_style')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                            <button type="submit"
                                class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 focus-visible:outline-2 focus-visible:outline-offset-2">
                                Update Layout
                            </button>
                        </div>
                    </form>
                </div>

            </div>

        </div>
    @endif

</div>
