<div>

    @if ($user)
        @guest
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5  flex flex-col content-center rounded-2xl my-5">
            @endguest
            @auth
                <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-20 mt-5">
                @endauth
                <div class="grid grid-cols-2 gap-4 mb-5">
                    <!-- Download VCF -->
                    <div class="ml-5 flex items-center">
                        <a wire:navigate href="{{ route('card.show', $user->username) }}"
                            class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">

                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                stroke="currentColor" class="size-5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                            </svg>
                        </a>
                    </div>

                    <!-- Share Card -->
                    <div class="mr-5 flex items-center place-content-end" x-data="{
                        urlTitle: `Let's Connect! | {{ $page_title ?: $card_title }}`,
                        shareUrl: '{{ route('card.connect', $username) }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).then(() => {
                                    console.log('Thanks for sharing!');
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">

                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>

                        <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-up-tray class="size-5" />
                        </a>
                    </div>
                </div>

                <div class="px-5">
                    <h1 class="text-xl md:text-2xl font-medium text-center mt-5">
                        Let's
                        Connect!</h1>
                    {{-- form here --}}
                    <form wire:submit.prevent="connectForm" x-data="{ optionalFields: false }" class="w-full">
                        <p class="text-center font-medium text-sm/6 text-gray-400">Send me your contact information
                            so
                            we can start
                            connecting! Cheers! </p>

                        <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                            <div class="col-span-full">
                                <livewire:register-profile-picture-field />
                                <p class="block text-sm/6 font-medium text-center pt-5">
                                    Help me recognize you by uploading your picture!
                                </p>
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="email" class="block text-sm/6 font-medium">Email
                                    address</label>
                                <div class="mt-2">
                                    <input id="email" type="email" wire:model="email"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 {{ session('email') ? 'border border-red-600' : '' }} @error('email') border border-red-600 @enderror"
                                        value="{{ old('email') }}">
                                </div>
                                @error('email')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                                @if (session('email'))
                                    <p class="mt-1 text-sm/6 text-red-600">
                                        {{ session('email') }}
                                    </p>
                                @endif
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="phone" class="block text-sm/6 font-semibold">Phone
                                    number</label>
                                <div class="mt-2">
                                    <input id="phone" type="tel" wire:model="phone"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('phone') border border-red-600 @enderror"
                                        value="{{ old('phone') }}">
                                </div>

                                @error('phone')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="firstname" class="block text-sm/6 font-medium">First
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" id="firstname" wire:model="firstname"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('firstname') border border-red-600 @enderror"
                                        value="{{ old('firstname') }}">
                                </div>

                                @error('firstname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="lastname" class="block text-sm/6 font-medium">Last
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" id="lastname" wire:model="lastname"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('lastname') border border-red-600 @enderror"
                                        value="{{ old('lastname') }}">
                                </div>

                                @error('lastname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="gender" class="block text-sm/6 font-medium">Gender</label>
                                <div class="mt-2 grid grid-cols-1">
                                    <select id="gender" wire:model="gender"
                                        class="col-start-1 row-start-1 w-full appearance-none rounded-md dark:bg-white bg-slate-100 py-1.5 pr-8 pl-3 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600  @error('gender') border border-red-600 @enderror">
                                        <option {{ old('gender', '') === '' ? 'selected' : '' }}>Select Gender
                                        </option>
                                        <option value="Male" {{ old('gender', '') === 'Male' ? 'selected' : '' }}>
                                            Male
                                        </option>
                                        <option value="Female" {{ old('gender', '') === 'Female' ? 'selected' : '' }}>
                                            Female</option>
                                    </select>
                                </div>

                                @error('gender')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full" x-data="{
                                maxChars: 200,
                                currentChar: 0,
                                text: `{{ addslashes(old('we_met_at')) }}`,
                                updateCount() {
                                    this.currentChar = this.text.length;
                                }
                            }">
                                <label for="we_met_at" class="block text-sm/6 font-medium">We met
                                    at</label>
                                <div class="mt-2">
                                    <textarea id="we_met_at" rows="3" x-model="text" x-on:input="updateCount" wire:model="we_met_at"
                                        :maxlength="maxChars"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600"
                                        placeholder="(Required)">{{ old('we_met_at') }}</textarea>
                                </div>
                                <p class="mt-3 text-sm/6 text-gray-400">Please remind me where we met!
                                    (<span x-text="`${currentChar}/${maxChars}`"
                                        class="text-sm/6 text-gray-400"></span>)
                                </p>

                                @error('we_met_at')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full" x-data="{
                                maxChars: 500,
                                currentChar: 0,
                                text: `{{ addslashes(old('help')) }}`,
                                updateCount() {
                                    this.currentChar = this.text.length;
                                }
                            }">
                                <label for="help" class="block text-sm/6 font-medium">How may I
                                    help?</label>
                                <div class="mt-2">
                                    <textarea id="help" rows="3" x-model="text" x-on:input="updateCount" wire:model="help"
                                        :maxlength="maxChars"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600"
                                        placeholder="(Required)">{{ old('help') }}</textarea>
                                </div>
                                <p class="mt-3 text-sm/6 text-gray-400">Please let me know how I can help
                                    (<span x-text="`${currentChar}/${maxChars}`"
                                        class="text-sm/6 text-gray-400"></span>)
                                </p>

                                @error('help')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                        </div>

                        <div x-show="optionalFields" x-transition x-cloak
                            class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">
                            <div class="col-span-full">
                                <label for="job_title" class="block text-sm/6 font-medium">Job
                                    Title
                                </label>
                                <div class="mt-2">
                                    <input id="job_title" type="text" wire:model="job_title"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('job_title') border border-red-600 @enderror"
                                        value="{{ old('job_title') }}">
                                </div>

                                @error('job_title')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="company" class="block text-sm/6 font-medium">Company
                                    Name
                                </label>
                                <div class="mt-2">
                                    <input id="company" type="text" wire:model="company"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('company') border border-red-600 @enderror"
                                        value="{{ old('company') }}" placeholder="(Optional)">
                                </div>

                                @error('company')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="company_website" class="block text-sm/6 font-medium">Company
                                    Website
                                </label>
                                <div class="mt-2">
                                    <input wire:model="company_website" type="text"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('company_website') border border-red-600 @enderror"
                                        value="{{ old('company_website') }}" placeholder="(Optional)">
                                </div>

                                @error('company_website')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                                @if (session('company_website'))
                                    <p class="mt-1 text-sm/6 text-red-600">
                                        {{ session('company_website') }}
                                    </p>
                                @endif
                            </div>

                            <div class="col-span-full">
                                <label for="country" class="block text-sm/6 font-medium">Country</label>
                                <div class="mt-2 grid grid-cols-1">
                                    <select id="country" wire:model="country"
                                        class="col-start-1 row-start-1 w-full appearance-none rounded-md dark:bg-white bg-slate-100 py-1.5 pr-8 pl-3 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('country') border border-red-600 @enderror">
                                        <option {{ old('country', '') === '' ? 'selected' : '' }}>Select
                                            Country
                                        </option>
                                        <option value="United States"
                                            {{ old('country', '') === 'United States' ? 'selected' : '' }}>
                                            United States
                                        </option>
                                        <option value="Philippines"
                                            {{ old('country', '') === 'Philippines' ? 'selected' : '' }}>
                                            Philippines
                                        </option>
                                        <option value="Afghanistan"
                                            {{ old('country', '') === 'Afghanistan' ? 'selected' : '' }}>
                                            Afghanistan
                                        </option>
                                        <option value="Albania"
                                            {{ old('country', '') === 'Albania' ? 'selected' : '' }}>
                                            Albania</option>
                                        <option value="Algeria"
                                            {{ old('country', '') === 'Algeria' ? 'selected' : '' }}>Algeria
                                        </option>
                                        <option value="Andorra"
                                            {{ old('country', '') === 'Andorra' ? 'selected' : '' }}>Andorra
                                        </option>
                                        <option value="Angola"
                                            {{ old('country', '') === 'Angola' ? 'selected' : '' }}>Angola
                                        </option>
                                        <option value="Antigua and Barbuda"
                                            {{ old('country', '') === 'Antigua and Barbuda' ? 'selected' : '' }}>
                                            Antigua and
                                            Barbuda</option>
                                        <option value="Argentina"
                                            {{ old('country', '') === 'Argentina' ? 'selected' : '' }}>
                                            Argentina
                                        </option>
                                        <option value="Armenia"
                                            {{ old('country', '') === 'Armenia' ? 'selected' : '' }}>Armenia
                                        </option>
                                        <option value="Australia"
                                            {{ old('country', '') === 'Australia' ? 'selected' : '' }}>
                                            Australia
                                        </option>
                                        <option value="Austria"
                                            {{ old('country', '') === 'Austria' ? 'selected' : '' }}>Austria
                                        </option>
                                        <option value="Azerbaijan"
                                            {{ old('country', '') === 'Azerbaijan' ? 'selected' : '' }}>
                                            Azerbaijan
                                        </option>
                                        <option value="Bahamas"
                                            {{ old('country', '') === 'Bahamas' ? 'selected' : '' }}>Bahamas
                                        </option>
                                        <option value="Bahrain"
                                            {{ old('country', '') === 'Bahrain' ? 'selected' : '' }}>Bahrain
                                        </option>
                                        <option value="Bangladesh"
                                            {{ old('country', '') === 'Bangladesh' ? 'selected' : '' }}>
                                            Bangladesh
                                        </option>
                                        <option value="Barbados"
                                            {{ old('country', '') === 'Barbados' ? 'selected' : '' }}>Barbados
                                        </option>
                                        <option value="Belarus"
                                            {{ old('country', '') === 'Belarus' ? 'selected' : '' }}>Belarus
                                        </option>
                                        <option value="Belgium"
                                            {{ old('country', '') === 'Belgium' ? 'selected' : '' }}>Belgium
                                        </option>
                                        <option value="Belize"
                                            {{ old('country', '') === 'Belize' ? 'selected' : '' }}>Belize
                                        </option>
                                        <option value="Benin" {{ old('country', '') === 'Benin' ? 'selected' : '' }}>
                                            Benin</option>
                                        <option value="Bhutan"
                                            {{ old('country', '') === 'Bhutan' ? 'selected' : '' }}>Bhutan
                                        </option>
                                        <option value="Bolivia"
                                            {{ old('country', '') === 'Bolivia' ? 'selected' : '' }}>Bolivia
                                        </option>
                                        <option value="Bosnia and Herzegovina"
                                            {{ old('country', '') === 'Bosnia and Herzegovina' ? 'selected' : '' }}>
                                            Bosnia and
                                            Herzegovina</option>
                                        <option value="Botswana"
                                            {{ old('country', '') === 'Botswana' ? 'selected' : '' }}>Botswana
                                        </option>
                                        <option value="Brazil"
                                            {{ old('country', '') === 'Brazil' ? 'selected' : '' }}>Brazil
                                        </option>
                                        <option value="Brunei"
                                            {{ old('country', '') === 'Brunei' ? 'selected' : '' }}>Brunei
                                        </option>
                                        <option value="Bulgaria"
                                            {{ old('country', '') === 'Bulgaria' ? 'selected' : '' }}>Bulgaria
                                        </option>
                                        <option value="Burkina Faso"
                                            {{ old('country', '') === 'Burkina Faso' ? 'selected' : '' }}>
                                            Burkina Faso
                                        </option>
                                        <option value="Burundi"
                                            {{ old('country', '') === 'Burundi' ? 'selected' : '' }}>Burundi
                                        </option>
                                        <option value="Cabo Verde"
                                            {{ old('country', '') === 'Cabo Verde' ? 'selected' : '' }}>Cabo
                                            Verde
                                        </option>
                                        <option value="Cambodia"
                                            {{ old('country', '') === 'Cambodia' ? 'selected' : '' }}>Cambodia
                                        </option>
                                        <option value="Cameroon"
                                            {{ old('country', '') === 'Cameroon' ? 'selected' : '' }}>Cameroon
                                        </option>
                                        <option value="Canada"
                                            {{ old('country', '') === 'Canada' ? 'selected' : '' }}>Canada
                                        </option>
                                        <option value="Central African Republic"
                                            {{ old('country', '') === 'Central African Republic' ? 'selected' : '' }}>
                                            Central African
                                            Republic</option>
                                        <option value="Chad" {{ old('country', '') === 'Chad' ? 'selected' : '' }}>
                                            Chad</option>
                                        <option value="Chile" {{ old('country', '') === 'Chile' ? 'selected' : '' }}>
                                            Chile</option>
                                        <option value="China" {{ old('country', '') === 'China' ? 'selected' : '' }}>
                                            China</option>
                                        <option value="Colombia"
                                            {{ old('country', '') === 'Colombia' ? 'selected' : '' }}>Colombia
                                        </option>
                                        <option value="Comoros"
                                            {{ old('country', '') === 'Comoros' ? 'selected' : '' }}>Comoros
                                        </option>
                                        <option value="Congo (Congo-Brazzaville)"
                                            {{ old('country', '') === 'Congo (Congo-Brazzaville)' ? 'selected' : '' }}>
                                            Congo
                                            (Congo-Brazzaville)</option>
                                        <option value="Congo (Congo-Kinshasa)"
                                            {{ old('country', '') === 'Congo (Congo-Kinshasa)' ? 'selected' : '' }}>
                                            Congo
                                            (Congo-Kinshasa)</option>
                                        <option value="Costa Rica"
                                            {{ old('country', '') === 'Costa Rica' ? 'selected' : '' }}>Costa
                                            Rica
                                        </option>
                                        <option value="Croatia"
                                            {{ old('country', '') === 'Croatia' ? 'selected' : '' }}>Croatia
                                        </option>
                                        <option value="Cuba" {{ old('country', '') === 'Cuba' ? 'selected' : '' }}>
                                            Cuba</option>
                                        <option value="Cyprus"
                                            {{ old('country', '') === 'Cyprus' ? 'selected' : '' }}>Cyprus
                                        </option>
                                        <option value="Czech Republic"
                                            {{ old('country', '') === 'Czech Republic' ? 'selected' : '' }}>
                                            Czech
                                            Republic
                                        </option>
                                        <option value="Denmark"
                                            {{ old('country', '') === 'Denmark' ? 'selected' : '' }}>Denmark
                                        </option>
                                        <option value="Djibouti"
                                            {{ old('country', '') === 'Djibouti' ? 'selected' : '' }}>Djibouti
                                        </option>
                                        <option value="Dominica"
                                            {{ old('country', '') === 'Dominica' ? 'selected' : '' }}>Dominica
                                        </option>
                                        <option value="Dominican Republic"
                                            {{ old('country', '') === 'Dominican Republic' ? 'selected' : '' }}>
                                            Dominican Republic
                                        </option>
                                        <option value="Ecuador"
                                            {{ old('country', '') === 'Ecuador' ? 'selected' : '' }}>Ecuador
                                        </option>
                                        <option value="Egypt" {{ old('country', '') === 'Egypt' ? 'selected' : '' }}>
                                            Egypt</option>
                                        <option value="El Salvador"
                                            {{ old('country', '') === 'El Salvador' ? 'selected' : '' }}>El
                                            Salvador
                                        </option>
                                        <option value="Equatorial Guinea"
                                            {{ old('country', '') === 'Equatorial Guinea' ? 'selected' : '' }}>
                                            Equatorial Guinea
                                        </option>
                                        <option value="Eritrea"
                                            {{ old('country', '') === 'Eritrea' ? 'selected' : '' }}>Eritrea
                                        </option>
                                        <option value="Estonia"
                                            {{ old('country', '') === 'Estonia' ? 'selected' : '' }}>Estonia
                                        </option>
                                        <option value="Eswatini"
                                            {{ old('country', '') === 'Eswatini' ? 'selected' : '' }}>Eswatini
                                        </option>
                                        <option value="Ethiopia"
                                            {{ old('country', '') === 'Ethiopia' ? 'selected' : '' }}>Ethiopia
                                        </option>
                                        <option value="Fiji" {{ old('country', '') === 'Fiji' ? 'selected' : '' }}>
                                            Fiji</option>
                                        <option value="Finland"
                                            {{ old('country', '') === 'Finland' ? 'selected' : '' }}>Finland
                                        </option>
                                        <option value="France"
                                            {{ old('country', '') === 'France' ? 'selected' : '' }}>France
                                        </option>
                                        <option value="Gabon" {{ old('country', '') === 'Gabon' ? 'selected' : '' }}>
                                            Gabon</option>
                                        <option value="Gambia"
                                            {{ old('country', '') === 'Gambia' ? 'selected' : '' }}>Gambia
                                        </option>
                                        <option value="Georgia"
                                            {{ old('country', '') === 'Georgia' ? 'selected' : '' }}>Georgia
                                        </option>
                                        <option value="Germany"
                                            {{ old('country', '') === 'Germany' ? 'selected' : '' }}>Germany
                                        </option>
                                        <option value="Ghana" {{ old('country', '') === 'Ghana' ? 'selected' : '' }}>
                                            Ghana</option>
                                        <option value="Greece"
                                            {{ old('country', '') === 'Greece' ? 'selected' : '' }}>Greece
                                        </option>
                                        <option value="Grenada"
                                            {{ old('country', '') === 'Grenada' ? 'selected' : '' }}>Grenada
                                        </option>
                                        <option value="Guatemala"
                                            {{ old('country', '') === 'Guatemala' ? 'selected' : '' }}>
                                            Guatemala
                                        </option>
                                        <option value="Guinea"
                                            {{ old('country', '') === 'Guinea' ? 'selected' : '' }}>Guinea
                                        </option>
                                        <option value="Guinea-Bissau"
                                            {{ old('country', '') === 'Guinea-Bissau' ? 'selected' : '' }}>
                                            Guinea-Bissau
                                        </option>
                                        <option value="Guyana"
                                            {{ old('country', '') === 'Guyana' ? 'selected' : '' }}>Guyana
                                        </option>
                                        <option value="Haiti"
                                            {{ old('country', '') === 'Haiti' ? 'selected' : '' }}>
                                            Haiti</option>
                                        <option value="Honduras"
                                            {{ old('country', '') === 'Honduras' ? 'selected' : '' }}>Honduras
                                        </option>
                                        <option value="Hungary"
                                            {{ old('country', '') === 'Hungary' ? 'selected' : '' }}>Hungary
                                        </option>
                                        <option value="Iceland"
                                            {{ old('country', '') === 'Iceland' ? 'selected' : '' }}>Iceland
                                        </option>
                                        <option value="India"
                                            {{ old('country', '') === 'India' ? 'selected' : '' }}>
                                            India</option>
                                        <option value="Indonesia"
                                            {{ old('country', '') === 'Indonesia' ? 'selected' : '' }}>
                                            Indonesia
                                        </option>
                                        <option value="Iran" {{ old('country', '') === 'Iran' ? 'selected' : '' }}>
                                            Iran</option>
                                        <option value="Iraq" {{ old('country', '') === 'Iraq' ? 'selected' : '' }}>
                                            Iraq</option>
                                        <option value="Ireland"
                                            {{ old('country', '') === 'Ireland' ? 'selected' : '' }}>Ireland
                                        </option>
                                        <option value="Israel"
                                            {{ old('country', '') === 'Israel' ? 'selected' : '' }}>Israel
                                        </option>
                                        <option value="Italy"
                                            {{ old('country', '') === 'Italy' ? 'selected' : '' }}>
                                            Italy</option>
                                        <option value="Jamaica"
                                            {{ old('country', '') === 'Jamaica' ? 'selected' : '' }}>Jamaica
                                        </option>
                                        <option value="Japan"
                                            {{ old('country', '') === 'Japan' ? 'selected' : '' }}>
                                            Japan</option>
                                        <option value="Jordan"
                                            {{ old('country', '') === 'Jordan' ? 'selected' : '' }}>Jordan
                                        </option>
                                        <option value="Kazakhstan"
                                            {{ old('country', '') === 'Kazakhstan' ? 'selected' : '' }}>
                                            Kazakhstan
                                        </option>
                                        <option value="Kenya"
                                            {{ old('country', '') === 'Kenya' ? 'selected' : '' }}>Kenya
                                        </option>
                                        <option value="Kiribati"
                                            {{ old('country', '') === 'Kiribati' ? 'selected' : '' }}>Kiribati
                                        </option>
                                        <option value="Korea, North"
                                            {{ old('country', '') === 'Korea, North' ? 'selected' : '' }}>
                                            Korea, North
                                        </option>
                                        <option value="Korea, South"
                                            {{ old('country', '') === 'Korea, South' ? 'selected' : '' }}>
                                            Korea, South
                                        </option>
                                        <option value="Kuwait"
                                            {{ old('country', '') === 'Kuwait' ? 'selected' : '' }}>Kuwait
                                        </option>
                                        <option value="Kyrgyzstan"
                                            {{ old('country', '') === 'Kyrgyzstan' ? 'selected' : '' }}>
                                            Kyrgyzstan
                                        </option>
                                        <option value="Laos" {{ old('country', '') === 'Laos' ? 'selected' : '' }}>
                                            Laos</option>
                                        <option value="Latvia"
                                            {{ old('country', '') === 'Latvia' ? 'selected' : '' }}>Latvia
                                        </option>
                                        <option value="Lebanon"
                                            {{ old('country', '') === 'Lebanon' ? 'selected' : '' }}>Lebanon
                                        </option>
                                        <option value="Lesotho"
                                            {{ old('country', '') === 'Lesotho' ? 'selected' : '' }}>Lesotho
                                        </option>
                                        <option value="Liberia"
                                            {{ old('country', '') === 'Liberia' ? 'selected' : '' }}>Liberia
                                        </option>
                                        <option value="Libya"
                                            {{ old('country', '') === 'Libya' ? 'selected' : '' }}>Libya
                                        </option>
                                        <option value="Liechtenstein"
                                            {{ old('country', '') === 'Liechtenstein' ? 'selected' : '' }}>
                                            Liechtenstein
                                        </option>
                                        <option value="Lithuania"
                                            {{ old('country', '') === 'Lithuania' ? 'selected' : '' }}>
                                            Lithuania
                                        </option>
                                        <option value="Luxembourg"
                                            {{ old('country', '') === 'Luxembourg' ? 'selected' : '' }}>
                                            Luxembourg
                                        </option>
                                        <option value="Madagascar"
                                            {{ old('country', '') === 'Madagascar' ? 'selected' : '' }}>
                                            Madagascar
                                        </option>
                                        <option value="Malawi"
                                            {{ old('country', '') === 'Malawi' ? 'selected' : '' }}>Malawi
                                        </option>
                                        <option value="Malaysia"
                                            {{ old('country', '') === 'Malaysia' ? 'selected' : '' }}>Malaysia
                                        </option>
                                        <option value="Maldives"
                                            {{ old('country', '') === 'Maldives' ? 'selected' : '' }}>Maldives
                                        </option>
                                        <option value="Mali" {{ old('country', '') === 'Mali' ? 'selected' : '' }}>
                                            Mali</option>
                                        <option value="Malta"
                                            {{ old('country', '') === 'Malta' ? 'selected' : '' }}>Malta
                                        </option>
                                        <option value="Marshall Islands"
                                            {{ old('country', '') === 'Marshall Islands' ? 'selected' : '' }}>
                                            Marshall
                                            Islands
                                        </option>
                                        <option value="Mauritania"
                                            {{ old('country', '') === 'Mauritania' ? 'selected' : '' }}>
                                            Mauritania
                                        </option>
                                        <option value="Mauritius"
                                            {{ old('country', '') === 'Mauritius' ? 'selected' : '' }}>
                                            Mauritius
                                        </option>
                                        <option value="Mexico"
                                            {{ old('country', '') === 'Mexico' ? 'selected' : '' }}>Mexico
                                        </option>
                                        <option value="Micronesia"
                                            {{ old('country', '') === 'Micronesia' ? 'selected' : '' }}>
                                            Micronesia
                                        </option>
                                        <option value="Moldova"
                                            {{ old('country', '') === 'Moldova' ? 'selected' : '' }}>Moldova
                                        </option>
                                        <option value="Monaco"
                                            {{ old('country', '') === 'Monaco' ? 'selected' : '' }}>Monaco
                                        </option>
                                        <option value="Mongolia"
                                            {{ old('country', '') === 'Mongolia' ? 'selected' : '' }}>Mongolia
                                        </option>
                                        <option value="Montenegro"
                                            {{ old('country', '') === 'Montenegro' ? 'selected' : '' }}>
                                            Montenegro
                                        </option>
                                        <option value="Morocco"
                                            {{ old('country', '') === 'Morocco' ? 'selected' : '' }}>Morocco
                                        </option>
                                        <option value="Mozambique"
                                            {{ old('country', '') === 'Mozambique' ? 'selected' : '' }}>
                                            Mozambique
                                        </option>
                                        <option value="Myanmar (Burma)"
                                            {{ old('country', '') === 'Myanmar (Burma)' ? 'selected' : '' }}>
                                            Myanmar
                                            (Burma)
                                        </option>
                                        <option value="Namibia"
                                            {{ old('country', '') === 'Namibia' ? 'selected' : '' }}>Namibia
                                        </option>
                                        <option value="Nauru"
                                            {{ old('country', '') === 'Nauru' ? 'selected' : '' }}>Nauru
                                        </option>
                                        <option value="Nepal"
                                            {{ old('country', '') === 'Nepal' ? 'selected' : '' }}>Nepal
                                        </option>
                                        <option value="Netherlands"
                                            {{ old('country', '') === 'Netherlands' ? 'selected' : '' }}>
                                            Netherlands
                                        </option>
                                        <option value="New Zealand"
                                            {{ old('country', '') === 'New Zealand' ? 'selected' : '' }}>New
                                            Zealand
                                        </option>
                                        <option value="Nicaragua"
                                            {{ old('country', '') === 'Nicaragua' ? 'selected' : '' }}>
                                            Nicaragua
                                        </option>
                                        <option value="Niger"
                                            {{ old('country', '') === 'Niger' ? 'selected' : '' }}>Niger
                                        </option>
                                        <option value="Nigeria"
                                            {{ old('country', '') === 'Nigeria' ? 'selected' : '' }}>Nigeria
                                        </option>
                                        <option value="North Macedonia"
                                            {{ old('country', '') === 'North Macedonia' ? 'selected' : '' }}>
                                            North
                                            Macedonia
                                        </option>
                                        <option value="Norway"
                                            {{ old('country', '') === 'Norway' ? 'selected' : '' }}>Norway
                                        </option>
                                        <option value="Oman" {{ old('country', '') === 'Oman' ? 'selected' : '' }}>
                                            Oman</option>
                                        <option value="Pakistan"
                                            {{ old('country', '') === 'Pakistan' ? 'selected' : '' }}>Pakistan
                                        </option>
                                        <option value="Palau"
                                            {{ old('country', '') === 'Palau' ? 'selected' : '' }}>Palau
                                        </option>
                                        <option value="Panama"
                                            {{ old('country', '') === 'Panama' ? 'selected' : '' }}>Panama
                                        </option>
                                        <option value="Papua New Guinea"
                                            {{ old('country', '') === 'Papua New Guinea' ? 'selected' : '' }}>
                                            Papua
                                            New Guinea
                                        </option>
                                        <option value="Paraguay"
                                            {{ old('country', '') === 'Paraguay' ? 'selected' : '' }}>Paraguay
                                        </option>
                                        <option value="Peru" {{ old('country', '') === 'Peru' ? 'selected' : '' }}>
                                            Peru</option>
                                        <option value="Poland"
                                            {{ old('country', '') === 'Poland' ? 'selected' : '' }}>Poland
                                        </option>
                                        <option value="Portugal"
                                            {{ old('country', '') === 'Portugal' ? 'selected' : '' }}>Portugal
                                        </option>
                                        <option value="Qatar"
                                            {{ old('country', '') === 'Qatar' ? 'selected' : '' }}>Qatar
                                        </option>
                                        <option value="Romania"
                                            {{ old('country', '') === 'Romania' ? 'selected' : '' }}>Romania
                                        </option>
                                        <option value="Russia"
                                            {{ old('country', '') === 'Russia' ? 'selected' : '' }}>Russia
                                        </option>
                                        <option value="Rwanda"
                                            {{ old('country', '') === 'Rwanda' ? 'selected' : '' }}>Rwanda
                                        </option>
                                        <option value="Saint Kitts and Nevis"
                                            {{ old('country', '') === 'Saint Kitts and Nevis' ? 'selected' : '' }}>
                                            Saint Kitts and
                                            Nevis</option>
                                        <option value="Saint Lucia"
                                            {{ old('country', '') === 'Saint Lucia' ? 'selected' : '' }}>Saint
                                            Lucia
                                        </option>
                                        <option value="Saint Vincent and the Grenadines"
                                            {{ old('country', '') === 'Saint Vincent and the Grenadines' ? 'selected' : '' }}>
                                            Saint Vincent and
                                            the
                                            Grenadines</option>
                                        <option value="Samoa"
                                            {{ old('country', '') === 'Samoa' ? 'selected' : '' }}>Samoa
                                        </option>
                                        <option value="San Marino"
                                            {{ old('country', '') === 'San Marino' ? 'selected' : '' }}>San
                                            Marino
                                        </option>
                                        <option value="Sao Tome and Principe"
                                            {{ old('country', '') === 'Sao Tome and Principe' ? 'selected' : '' }}>
                                            Sao
                                            Tome and
                                            Principe</option>
                                        <option value="Saudi Arabia"
                                            {{ old('country', '') === 'Saudi Arabia' ? 'selected' : '' }}>
                                            Saudi Arabia
                                        </option>
                                        <option value="Senegal"
                                            {{ old('country', '') === 'Senegal' ? 'selected' : '' }}>Senegal
                                        </option>
                                        <option value="Serbia"
                                            {{ old('country', '') === 'Serbia' ? 'selected' : '' }}>Serbia
                                        </option>
                                        <option value="Seychelles"
                                            {{ old('country', '') === 'Seychelles' ? 'selected' : '' }}>
                                            Seychelles
                                        </option>
                                        <option value="Sierra Leone"
                                            {{ old('country', '') === 'Sierra Leone' ? 'selected' : '' }}>
                                            Sierra Leone
                                        </option>
                                        <option value="Singapore"
                                            {{ old('country', '') === 'Singapore' ? 'selected' : '' }}>
                                            Singapore
                                        </option>
                                        <option value="Slovakia"
                                            {{ old('country', '') === 'Slovakia' ? 'selected' : '' }}>Slovakia
                                        </option>
                                        <option value="Slovenia"
                                            {{ old('country', '') === 'Slovenia' ? 'selected' : '' }}>Slovenia
                                        </option>
                                        <option value="Solomon Islands"
                                            {{ old('country', '') === 'Solomon Islands' ? 'selected' : '' }}>
                                            Solomon
                                            Islands
                                        </option>
                                        <option value="Somalia"
                                            {{ old('country', '') === 'Somalia' ? 'selected' : '' }}>Somalia
                                        </option>
                                        <option value="South Africa"
                                            {{ old('country', '') === 'South Africa' ? 'selected' : '' }}>
                                            South Africa
                                        </option>
                                        <option value="South Sudan"
                                            {{ old('country', '') === 'South Sudan' ? 'selected' : '' }}>South
                                            Sudan
                                        </option>
                                        <option value="Spain"
                                            {{ old('country', '') === 'Spain' ? 'selected' : '' }}>Spain
                                        </option>
                                        <option value="Sri Lanka"
                                            {{ old('country', '') === 'Sri Lanka' ? 'selected' : '' }}>Sri
                                            Lanka
                                        </option>
                                        <option value="Sudan"
                                            {{ old('country', '') === 'Sudan' ? 'selected' : '' }}>Sudan
                                        </option>
                                        <option value="Suriname"
                                            {{ old('country', '') === 'Suriname' ? 'selected' : '' }}>Suriname
                                        </option>
                                        <option value="Sweden"
                                            {{ old('country', '') === 'Sweden' ? 'selected' : '' }}>Sweden
                                        </option>
                                        <option value="Switzerland"
                                            {{ old('country', '') === 'Switzerland' ? 'selected' : '' }}>
                                            Switzerland
                                        </option>
                                        <option value="Syria"
                                            {{ old('country', '') === 'Syria' ? 'selected' : '' }}>Syria
                                        </option>
                                        <option value="Taiwan"
                                            {{ old('country', '') === 'Taiwan' ? 'selected' : '' }}>Taiwan
                                        </option>
                                        <option value="Tajikistan"
                                            {{ old('country', '') === 'Tajikistan' ? 'selected' : '' }}>
                                            Tajikistan
                                        </option>
                                        <option value="Tanzania"
                                            {{ old('country', '') === 'Tanzania' ? 'selected' : '' }}>Tanzania
                                        </option>
                                        <option value="Thailand"
                                            {{ old('country', '') === 'Thailand' ? 'selected' : '' }}>Thailand
                                        </option>
                                        <option value="Timor-Leste"
                                            {{ old('country', '') === 'Timor-Leste' ? 'selected' : '' }}>
                                            Timor-Leste
                                        </option>
                                        <option value="Togo" {{ old('country', '') === 'Togo' ? 'selected' : '' }}>
                                            Togo</option>
                                        <option value="Tonga"
                                            {{ old('country', '') === 'Tonga' ? 'selected' : '' }}>Tonga
                                        </option>
                                        <option value="Trinidad and Tobago"
                                            {{ old('country', '') === 'Trinidad and Tobago' ? 'selected' : '' }}>
                                            Trinidad and
                                            Tobago</option>
                                        <option value="Tunisia"
                                            {{ old('country', '') === 'Tunisia' ? 'selected' : '' }}>Tunisia
                                        </option>
                                        <option value="Turkey"
                                            {{ old('country', '') === 'Turkey' ? 'selected' : '' }}>Turkey
                                        </option>
                                        <option value="Turkmenistan"
                                            {{ old('country', '') === 'Turkmenistan' ? 'selected' : '' }}>
                                            Turkmenistan
                                        </option>
                                        <option value="Tuvalu"
                                            {{ old('country', '') === 'Tuvalu' ? 'selected' : '' }}>Tuvalu
                                        </option>
                                        <option value="Uganda"
                                            {{ old('country', '') === 'Uganda' ? 'selected' : '' }}>Uganda
                                        </option>
                                        <option value="Ukraine"
                                            {{ old('country', '') === 'Ukraine' ? 'selected' : '' }}>Ukraine
                                        </option>
                                        <option value="United Arab Emirates"
                                            {{ old('country', '') === 'United Arab Emirates' ? 'selected' : '' }}>
                                            United Arab
                                            Emirates</option>
                                        <option value="United Kingdom"
                                            {{ old('country', '') === 'United Kingdom' ? 'selected' : '' }}>
                                            United
                                            Kingdom
                                        </option>
                                        <option value="Uruguay"
                                            {{ old('country', '') === 'Uruguay' ? 'selected' : '' }}>Uruguay
                                        </option>
                                        <option value="Uzbekistan"
                                            {{ old('country', '') === 'Uzbekistan' ? 'selected' : '' }}>
                                            Uzbekistan
                                        </option>
                                        <option value="Vanuatu"
                                            {{ old('country', '') === 'Vanuatu' ? 'selected' : '' }}>Vanuatu
                                        </option>
                                        <option value="Vatican City"
                                            {{ old('country', '') === 'Vatican City' ? 'selected' : '' }}>
                                            Vatican City
                                        </option>
                                        <option value="Venezuela"
                                            {{ old('country', '') === 'Venezuela' ? 'selected' : '' }}>
                                            Venezuela
                                        </option>
                                        <option value="Vietnam"
                                            {{ old('country', '') === 'Vietnam' ? 'selected' : '' }}>Vietnam
                                        </option>
                                        <option value="Yemen"
                                            {{ old('country', '') === 'Yemen' ? 'selected' : '' }}>Yemen
                                        </option>
                                        <option value="Zambia"
                                            {{ old('country', '') === 'Zambia' ? 'selected' : '' }}>Zambia
                                        </option>
                                        <option value="Zimbabwe"
                                            {{ old('country', '') === 'Zimbabwe' ? 'selected' : '' }}>Zimbabwe
                                        </option>

                                    </select>
                                    <svg class="pointer-events-none col-start-1 row-start-1 mr-2 size-5 self-center justify-self-end text-gray-500 sm:size-4"
                                        viewBox="0 0 16 16" fill="currentColor" aria-hidden="true" data-slot="icon">
                                        <path fill-rule="evenodd"
                                            d="M4.22 6.22a.75.75 0 0 1 1.06 0L8 8.94l2.72-2.72a.75.75 0 1 1 1.06 1.06l-3.25 3.25a.75.75 0 0 1-1.06 0L4.22 7.28a.75.75 0 0 1 0-1.06Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>

                                @error('country')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        <div class="mt-10">
                            <button type="button" @click="optionalFields = !optionalFields"
                                class="w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 "
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"><span
                                    x-text="optionalFields ? 'Hide optional fields' : 'Add more information'"></span></button>

                            <button type="submit"
                                class="mt-5 w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 "
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">Send</button>
                        </div>
                    </form>
                </div>

                @if ($contacts)
                    <p class="flex items-center justify-center text-center pt-10">
                        Contact me
                    </p>

                    <div class="pt-2 container mx-auto flex items-center justify-center">

                        {{-- @if ($user['email'])
                        <a href="mailto:{{ $user['email'] }}" target="_blank">
                            <x-fas-envelope class="size-6 mx-2" />
                        </a>
                    @endif

                    <a href="tel:{{ $user['phone'] }}" target="_blank">
                        <x-heroicon-s-phone class="size-6 mx-2" />
                    </a>
                    <a href="sms:{{ $user['phone'] }}" target="_blank">
                        <x-fas-sms class="size-6 mx-2" />
                    </a> --}}

                        {{-- Other contact points here --}}

                        <livewire:contact-points-component :username="$user->username" />

                    </div>
                @endif
            </div>
        </div>
    @else
        <div class="h-screen flex justify-center items-center">
            <div>
                <p class="mx-auto text-yellow-500 text-center text-l p-10">
                    <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
                </p>
                <p class="mx-auto font-bold text-center text-2xl">Page not found.
                </p>
            </div>
        </div>
    @endif

    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                Livewire.on('connectFormSubmitted', ({
                    smsUrl
                }) => {
                    window.location.href = smsUrl;
                });
            });
        </script>
    @endpush
</div>
