<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.links') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <x-heroicon-o-users class="size-6 inline-block" />

                &nbsp;&nbsp;Team Members
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a>
            </div>
        </div>


    </div>

    @if ($members_count < 1)
        {{-- <div class="flex justify-center my-20">
            <a wire:navigate href="{{ route('image.add') }}"
                class="flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">Add
                image(s) &nbsp;
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                    <path fill-rule="evenodd"
                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                        clip-rule="evenodd" />
                </svg>
            </a>

        </div> --}}

        <div class=" justify-center items-center my-20">
            <p class="text-center text-slate-600 dark:text-slate-500 text-base mb-2"> No
                team
                member(s).
            </p>
            <a wire:navigate href="{{ route('dashboard.search') }}"
                class="w-fit flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">Search
                Member &nbsp;
                <x-heroicon-o-magnifying-glass class="size-4" />
            </a>
        </div>
    @endif

    @if ($members_count > 0)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 sm:py-10 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">
            <p class="text-slate-600 dark:text-slate-500 text-sm text-center mb-10">Drag the element to rearrange.</p>
            <livewire:sortable-team-members />
        </div>
    @endif
</div>
