<div>
    @guest
        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative my-5">
        @endguest

        @auth
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5  sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">
            @endauth

            <div
                class="grid grid-cols-4 gap-4 pt-5 mb-5 z-10 {{ $profile_layout == 'default_cover' || $profile_layout == 'full_width' ? 'absolute top-0 left-0 w-full' : '' }} ">

                <div class="ml-5 flex items-center col-span-2">
                    <a href="{{ route('card.show', $user->username) }}"
                        class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">

                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-5">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                        </svg>
                    </a>
                </div>

                <!-- Share Card -->
                <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
                    urlTitle: `More Videos | {{ $page_title ?: $card_title }}`,
                    shareUrl: '{{ route('morevideos.show', $user->username) }}',
                    shareCard() {
                        if (navigator.share) {
                            navigator.share({
                                title: this.urlTitle,
                                url: this.shareUrl,
                            }).then(() => {
                                console.log('Thanks for sharing!');
                            }).catch(console.error);
                        } else {
                            console.log('Web Share API not supported');
                        }
                    }
                }">

                    <button type="button" @click="showQRCode=!showQRCode"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                        <x-heroicon-o-qr-code class="size-5" />
                    </button>

                    <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-arrow-up-tray class="size-5" />
                    </a>
                </div>
            </div>

            {{-- cover photo --}}
            @if ($profile_layout == 'default_cover')
                <img loading="lazy"
                    src="{{ $user['cover_pic'] ? asset($user['cover_pic']) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">

                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="rounded-full w-6/12 mx-auto -mt-28"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- circled profile pic --}}
            @if ($profile_layout == 'default')
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="rounded-full w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- rounded profile pic --}}
            @if ($profile_layout == 'rounded')
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important; border-radius: 50px;">
            @endif

            {{-- full width profile pic --}}
            @if ($profile_layout == 'full_width')
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">
            @endif

            <h1 class="flex items-center justify-center text-2xl font-medium text-center mt-5 mx-5">
                More Videos
            </h1>

            <div style="z-index: 0 !important;">
                <livewire:new-videos-component :username="$user->username" />
            </div>

            @if (in_array($user->user_type, ['Basic', 'Gold', 'Platinum']) && $connect_bio == true)
                <a wire:navigate href="{{ route('card.connect', $user->username) }}"
                    class="flex p-3 rounded-full w-10/12 text-black text-center mx-auto mt-10 mb-5 text-l font-bold items-center justify-center"
                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                    <x-fas-handshake class="size-4 inline" />
                    &nbsp;&nbsp;
                    Let's Connect!</a>
                <p class="flex items-center justify-center text-center">
                    or
                </p>
            @endif

            @if ($contacts)
                <p class="flex items-center justify-center text-center pt-5">
                    Contact me
                </p>

                <div class="pt-2 container mx-auto flex items-center justify-center">
                    <livewire:contact-points-component :username="$user->username" />
                </div>
            @endif

        </div>
    </div>

</div>
