<div wire:poll.5s>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">
        <div class="grid grid-cols-5 gap-4">
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-5">
                <x-heroicon-s-bell class="size-6 inline-block" /> &nbsp;&nbsp;Notifications
            </p>
        </div>

        <div class="max-w-3xl mx-auto py-10">
            {{-- Header --}}
            <div class="flex justify-between items-center mb-6">
                <h1 class="text-2xl font-semibold text-slate-800 dark:text-slate-300">Notifications</h1>

                <div class="flex gap-4">
                    @if ($unread_notification_count > 0)
                        <button wire:click="markAllAsRead" class="text-xs text-blue-600 hover:underline">
                            Mark all as read
                        </button>
                    @endif

                    @if ($notification_count > 0)
                        <button wire:click="clearAllNotifications" class="text-xs text-red-600 hover:underline">
                            Clear All
                        </button>
                    @endif
                </div>
            </div>

            @if ($notifications->count() === 0)
                <p class="text-center text-slate-800 dark:text-slate-300 py-10">
                    No notification(s).
                </p>
            @else
                {{-- Loop through grouped notifications --}}
                @foreach ($groups as $groupName => $groupNotifications)
                    @if (count($groupNotifications))
                        <div class="mb-6">
                            <h2 class="text-sm font-semibold text-gray-500 dark:text-gray-400 mb-2 pb-1">
                                {{ $groupName }}
                            </h2>

                            <div class="space-y-4">
                                @foreach ($groupNotifications as $notification)
                                    <div wire:click.prevent="openNotification('{{ $notification->id }}')"
                                        wire:key="notification-{{ $notification->id }}"
                                        wire:loading.class="opacity-60 pointer-events-none"
                                        wire:target="openNotification"
                                        class="p-4 rounded-xl transition cursor-pointer
                                      {{ $notification->read_at
                                          ? 'bg-blue-200 dark:bg-zinc-900'
                                          : 'bg-white dark:bg-zinc-800 hover:bg-blue-100 dark:hover:bg-zinc-700' }}">

                                        <div class="flex justify-between items-start gap-4">
                                            <div class="flex-1">
                                                <p class="font-medium text-slate-800 dark:text-slate-300">
                                                    {{ $notification->data['title'] ?? 'Notification' }}
                                                </p>

                                                <p class="text-sm text-slate-800 dark:text-slate-300">
                                                    {!! $notification->data['message'] !!}
                                                </p>

                                                <p class="text-xs text-slate-800 dark:text-slate-300 mt-1">
                                                    {{ $notification->created_at->diffForHumans() }}
                                                </p>
                                            </div>

                                            @if (!$notification->read_at)
                                                <div class="flex-shrink-0">
                                                    <span
                                                        class="inline-block px-2 py-0.5 text-xs font-semibold text-white bg-blue-600 rounded-full">
                                                        New
                                                    </span>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                @endforeach

                {{-- Pagination --}}
                <div class="mt-6">
                    {{ $notifications->links() }}
                </div>
            @endif
        </div>

    </div>
</div>
