<div class="bg-slate-200">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-10 flex flex-col content-center rounded-2xl text-black">

        <div class="px-5">

            <img class="mx-auto w-[50%] mb-10" src="{{ $logo ? asset($logo) : asset('img/10kcards-black-logo.webp') }}">

            <span class="flex flex-col items-center text-center gap-1">
                <x-heroicon-s-users class="size-10 text-yellow-400 mb-2" />

                <h1 class="text-sm">
                    Partnership Level

                    <div class="mt-2">
                        @if ($selected_plan == 'junior')
                            <span
                                class="inline-flex items-center rounded-md bg-yellow-100 px-2 py-1 text-sm font-bold text-yellow-800 ring-1 ring-yellow-600/20 ring-inset">Junior</span>
                        @elseif ($selected_plan == 'senior')
                            <span
                                class="inline-flex items-center rounded-md bg-gray-100 px-2 py-1 text-sm font-bold text-gray-600 ring-1 ring-gray-500/10 ring-inset">Senior</span>
                        @endif
                    </div>
                </h1>

            </span>

            <div style="border: 4px solid #facc15;"
                class="mt-10 mx-auto p-5 bg-white flex flex-col content-center rounded-2xl mb-5">
                <div
                    class="text-sm prose dark:prose-invert max-w-none text-slate-800 [&_strong]:text-slate-800 [&_li::marker]:text-yellow-600">
                    {!! Purifier::clean($term_description) !!}
                </div>
            </div>

            <div class="flex justify-center items-center">
                <a href="{{ $price_link }}" target="_blank"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs
               focus-visible:outline-2 focus-visible:outline-offset-2
               bg-gradient-to-b from-yellow-400 to-yellow-400
               hover:from-yellow-400 hover:to-yellow-700">
                    Pay ${{ $price }}
                </a>
            </div>

            <form wire:submit.prevent="requestUpgradeCard" class="w-full">

                <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                    <div class="col-span-full">
                        <label for="receipt" class="block text-sm/6 font-medium">
                            After payment, attach receipt.</label>
                        <div class="mt-2">
                            <input type="file" id="receipt" wire:model="receipt"
                                class="block w-full rounded-md px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('receipt') border border-red-600 @enderror" />
                        </div>

                        @error('receipt')
                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                        @enderror

                        <p x-cloack wire:loading wire:target="receipt" class="mt-1 text-sm/6 text-yellow-500">Uploading.
                            Please
                            wait…</p>
                    </div>
                </div>

                <div class="mt-10">
                    {{-- <button type="submit"
                        class="w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400
               hover:from-yellow-400 hover:to-yellow-700">Send
                        Upgrade Request</button> --}}

                    <button type="submit" wire:loading.attr="disabled" wire:target="receipt"
                        class="w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs
           focus-visible:outline-2 focus-visible:outline-offset-2
           bg-gradient-to-b from-yellow-400 to-yellow-400
           hover:from-yellow-400 hover:to-yellow-700
           disabled:opacity-60 disabled:cursor-not-allowed">

                        <span wire:loading.remove wire:target="receipt">
                            Send Partnership Request
                        </span>

                        <span wire:loading wire:target="receipt">
                            Uploading…
                        </span>
                    </button>

                    <a href="{{ route('partnership.index') }}"
                        class="block w-full mt-5 rounded-md px-3 py-2 text-sm font-semibold shadow-xs
           text-center
           focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400
               hover:from-yellow-400 hover:to-yellow-700">
                        Back
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
