<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.profile') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900">
                        <x-bi-chevron-left class="size-4" />
                    </span>
                </a>
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold">
                <x-heroicon-o-users class="size-6 inline-block" />

                &nbsp;&nbsp;Partnership Program
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>

    </div>

    <livewire:switch-card-component />

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-2 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl px-5 mb-5">

        <ul role="list">

            <!-- Card Type -->
            <li class="flex justify-between gap-x-6 sm:py-3">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                        <x-heroicon-o-user class="size-5" />
                    </span>
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm font-semibold text-gray-900 dark:text-slate-300">Partnership Level</p>
                    </div>
                </div>
                <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                    <span class="rounded-full text-gray-600 p-2">
                        <p
                            class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l">

                            @if ($user['partnership_level'] === 'junior')
                                <span
                                    class="inline-flex items-center rounded-md bg-yellow-100 px-2 py-1 text-xs font-semibold text-yellow-800 ring-1 ring-yellow-600/20 ring-inset">Junior</span>
                            @elseif ($user['partnership_level'] === 'senior')
                                <span
                                    class="inline-flex items-center rounded-md bg-gray-100 px-2 py-1 text-xs font-semibold text-gray-600 ring-1 ring-gray-500/10 ring-inset">Senior</span>
                            @elseif ($user['partnership_level'] === 'leader')
                                <span
                                    class="inline-flex items-center rounded-md bg-green-100 px-2 py-1 text-xs font-medium text-green-700 ring-1 ring-pink-700/10 ring-inset mr-2">Leader</span>
                            @else
                                <span
                                    class="inline-flex items-center rounded-md bg-blue-100 px-2 py-1 text-xs font-medium text-blue-700 ring-1 ring-pink-700/10 ring-inset">Default</span>
                            @endif
                        </p>

                    </span>
                </div>
            </li>

            <li class="flex justify-between gap-x-6 sm:py-3">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                        <x-heroicon-o-currency-dollar class="size-5" />
                    </span>
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm font-semibold text-gray-900 dark:text-slate-300">Earning %</p>
                    </div>
                </div>

                <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                    <span class="rounded-full text-gray-600 p-2">
                        <p
                            class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-right font-semibold text-sm">

                            @if ($user['partnership_level'] === 'junior')
                                25%
                            @elseif ($user['partnership_level'] === 'senior')
                                50%
                            @elseif ($user['partnership_level'] === 'leader')
                                20%
                            @else
                                10%
                            @endif

                        </p>

                    </span>
                </div>
            </li>

        </ul>

        @if ($user['partnership_level'] != 'senior')
            <div class="flex items-center justify-end gap-x-6 gap-4 py-5">
                <a href="{{ route('partnership.upgrade') }}"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 flex">
                    Upgrade Partnership
                </a>
            </div>
        @endif

    </div>
</div>
