@php
    $defaultPlan = auth()->user()->partnership_level === 'junior' ? 'senior' : 'junior';
@endphp

<div class="bg-slate-200 h-screen">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-10 flex flex-col content-center rounded-2xl text-black">

        <img class="mx-auto w-[50%] px-5" src="{{ $logo ? asset($logo) : asset('img/10kcards-black-logo.webp') }}">

        <h2 class="mt-10 text-center text-2xl font-bold tracking-tight text-gray-900">
            Partnership Program
        </h2>

        <div id="plans" class="sm:mx-auto sm:w-full sm:max-w-lg">

            <p class="mt-1 text-sm text-center text-gray-600 font-semibold">
                I’m ready to JOIN as a STRATEGIC PARTNER
            </p>

            @if (in_array($current_card, ['Sponsored', 'Influencer', 'Gold', 'Platinum']))
                <div class="plan_selection">

                    {{-- Junior Partner --}}
                    @if (auth()->user()->partnership_level !== 'junior')
                        <div plan="junior"
                            class="plan mt-5 mx-auto py-5 bg-white flex flex-col rounded-2xl mb-5 cursor-pointer"
                            style="border: {{ $defaultPlan === 'junior' ? '4px solid #facc15' : '4px solid white' }};">

                            <div class="grid grid-cols-7 mx-2">
                                <div class="flex items-center justify-center col-span-1">
                                    <x-heroicon-s-check-circle
                                        class="check-icon size-5 text-yellow-400 {{ $defaultPlan === 'junior' ? '' : 'hidden' }}" />
                                    <x-ri-circle-line
                                        class="circle-icon size-5 text-gray-400 {{ $defaultPlan === 'junior' ? 'hidden' : '' }}" />
                                </div>

                                <div class="flex items-center col-span-5">
                                    <div>
                                        <p class="text-xl font-semibold text-gray-900">
                                            Junior Partner
                                        </p>
                                        <p class="mt-1 text-sm text-gray-500">
                                            Earn 25% on all referrals.
                                        </p>
                                    </div>
                                </div>

                                <div class="flex items-center justify-end col-span-1 pr-5">
                                    <p class="text-xl font-semibold text-gray-900">
                                        $2500
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endif

                    {{-- Senior Partner --}}
                    <div plan="senior"
                        class="plan mt-5 mx-auto py-5 bg-white flex flex-col rounded-2xl mb-5 cursor-pointer"
                        style="border: {{ $defaultPlan === 'senior' ? '4px solid #facc15' : '4px solid white' }};">

                        <div class="grid grid-cols-7 mx-2">
                            <div class="flex items-center justify-center col-span-1">
                                <x-heroicon-s-check-circle
                                    class="check-icon size-5 text-yellow-400 {{ $defaultPlan === 'senior' ? '' : 'hidden' }}" />
                                <x-ri-circle-line
                                    class="circle-icon size-5 text-gray-400 {{ $defaultPlan === 'senior' ? 'hidden' : '' }}" />
                            </div>

                            <div class="flex items-center col-span-5">
                                <div>
                                    <p class="text-xl font-semibold text-gray-900">
                                        Senior Partner
                                    </p>
                                    <p class="mt-1 text-sm text-gray-500">
                                        Earn 50% on all referrals.
                                    </p>
                                </div>
                            </div>

                            <div class="flex items-center justify-end col-span-1 pr-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    $5000
                                </p>
                            </div>
                        </div>
                    </div>

                </div>
            @endif

            <div class="mt-10 flex justify-between items-center gap-4">

                <a href="{{ route('dashboard.profile') }}"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs
                          bg-gradient-to-b from-yellow-400 to-yellow-400 hover:to-yellow-700">
                    Back
                </a>

                <a id="proceed-button" href="{{ route('partnership.checkout') }}?selected_plan={{ $defaultPlan }}"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs
                          bg-gradient-to-b from-yellow-400 to-yellow-400 hover:to-yellow-700">
                    Proceed
                </a>
            </div>

        </div>
    </div>

    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const proceedButton = document.getElementById('proceed-button');
                const plans = document.querySelectorAll('.plan');

                plans.forEach(plan => {
                    plan.addEventListener('click', () => {
                        const selectedPlan = plan.getAttribute('plan');

                        plans.forEach(p => {
                            p.style.border = '4px solid white';
                            p.querySelector('.check-icon')?.classList.add('hidden');
                            p.querySelector('.circle-icon')?.classList.remove('hidden');
                        });

                        plan.style.border = '4px solid #facc15';
                        plan.querySelector('.check-icon')?.classList.remove('hidden');
                        plan.querySelector('.circle-icon')?.classList.add('hidden');

                        proceedButton.href =
                            "{{ route('partnership.checkout') }}?selected_plan=" + selectedPlan;
                    });
                });
            });
        </script>
    @endpush
</div>
