<div class="bg-slate-200">


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl text-black dark:text-gray-400">

        <div class="grid grid-cols-2 gap-4 mb-5 pt-5">
            <!-- back -->
            @auth
                <div class="ml-5 flex items-center">
                    <a href="{{ route('dashboard.index') }}"
                        class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-chevron-left class="size-4" />
                    </a>
                </div>
            @endauth

            @guest
                <div class="ml-5 flex items-center">
                    <a href="{{ route('welcome') }}"
                        class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-chevron-left class="size-4" />
                    </a>
                </div>
            @endguest
        </div>

        <img src="{{ $mockup ? asset($mockup) : asset('img/mockup.png') }}" class="w-8/12 floating-animation mx-auto">

        <h1 class="text-[40px] text-center text-slate-800 dark:text-slate-300 px-2 pt-5 font-bold"
            style="background: linear-gradient(to right, {{ $site_slogan_color_1 }} 10%, {{ $site_slogan_color_2 }} 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;">
            {{ $site_slogan }}</h1>

        <p class="text-slate-900 text-base text-center py-2 px-3 sm:px-5 mb-10">
            {!! strip_tags($site_desc, '<strong><em>') !!}
        </p>

        <div style="border: 4px solid #facc15;"
            class="mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

            <div class="mx-5">

                <div class="flex items-center col-span-5">
                    <div>
                        {{-- Title + Price Row --}}
                        <div class="flex justify-between items-center mb-5">
                            <p class="text-xl font-semibold text-gray-900">
                                {{ $term_basic }}
                            </p>

                            <p class="text-xl font-semibold text-gray-900">
                                $100
                            </p>
                        </div>

                        <div
                            class="text-sm mt-1 prose dark:prose-invert max-w-none text-slate-800 [&_strong]:text-slate-800 [&_li::marker]:text-yellow-600">
                            {!! Purifier::clean($term_description_basic) !!}
                        </div>

                        @guest
                            <div class="flex justify-center items-center mt-10">
                                <a href="{{ route('register') }}"
                                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs
               focus-visible:outline-2 focus-visible:outline-offset-2
               bg-gradient-to-b from-yellow-400 to-yellow-400
               hover:from-yellow-400 hover:to-yellow-700">
                                    Sign Up
                                </a>
                            </div>
                        @endguest
                    </div>
                </div>

            </div>

        </div>

        <div style="border: 4px solid #facc15;"
            class="mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

            <div class="mx-5">

                <div class="flex items-center col-span-5">
                    <div>

                        {{-- Title + Price Row --}}
                        <div class="flex justify-between items-center mb-5">
                            <p class="text-xl font-semibold text-gray-900">
                                {{ $term_gold }}
                            </p>

                            <p class="text-xl font-semibold text-gray-900">
                                $300
                            </p>
                        </div>

                        <div
                            class="text-sm mt-1 prose dark:prose-invert max-w-none text-slate-800 [&_strong]:text-slate-800 [&_li::marker]:text-yellow-600">
                            {!! Purifier::clean($term_description_gold) !!}
                        </div>

                        @guest
                            <div class="flex justify-center items-center mt-10">
                                <a href="{{ route('register') }}"
                                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs
               focus-visible:outline-2 focus-visible:outline-offset-2
               bg-gradient-to-b from-yellow-400 to-yellow-400
               hover:from-yellow-400 hover:to-yellow-700">
                                    Sign Up
                                </a>
                            </div>
                        @endguest
                    </div>
                </div>

            </div>

        </div>

        @if ($platinum_enabled)
            <div style="border: 4px solid #facc15;"
                class="mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                <div class="mx-5">

                    <div class="flex items-center col-span-5">
                        <div>

                            {{-- Title + Price Row --}}
                            <div class="flex justify-between items-center mb-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    {{ $term_platinum }}
                                </p>

                                <p class="text-xl font-semibold text-gray-900">
                                    $600
                                </p>
                            </div>

                            <div
                                class="text-sm mt-1 prose dark:prose-invert max-w-none text-slate-800 [&_strong]:text-slate-800 [&_li::marker]:text-yellow-600">
                                {!! Purifier::clean($term_description_platinum) !!}
                            </div>

                            @guest
                                <div class="flex justify-center items-center mt-10">
                                    <a href="{{ route('register') }}"
                                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs
               focus-visible:outline-2 focus-visible:outline-offset-2
               bg-gradient-to-b from-yellow-400 to-yellow-400
               hover:from-yellow-400 hover:to-yellow-700">
                                        Sign Up
                                    </a>
                                </div>
                            @endguest
                        </div>
                    </div>

                </div>

            </div>
        @endif

        @auth
            <div class="mt-10 flex justify-between items-center gap-4">
                @if (
                    (auth()->user()->user_type != null && (auth()->user()->user_type != 'Platinum' && $platinum_enabled)) ||
                        (auth()->user()->user_type != 'Gold' && !$platinum_enabled))
                    <a href="{{ route('upgrade.index') }}"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                        Upgrade
                    </a>
                @endif

                @if (
                    ($platinum_enabled && auth()->user()->user_type == 'Platinum') ||
                        (!$platinum_enabled && auth()->user()->user_type == 'Gold'))
                    <a href="{{ route('dashboard.index') }}"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                        Back
                    </a>
                @endif

                @if (auth()->user()->user_type == null)
                    <a href="{{ route('plan.index') }}"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                        Plan Select
                    </a>
                @endif
            </div>
        @endauth
    </div>
</div>
