<div x-data="{
    cropper: null,
    cropRegion: null,
    dispatchCroppedImage() {
        this.cropper.getCroppedCanvas().toBlob(blob => {
            $dispatch('croppedImageReady', [URL.createObjectURL(blob), this.cropRegion]);
            console.log([URL.createObjectURL(blob), this.cropRegion]);
            @this.closeModal();
        });
    }
}" x-init="$nextTick(() => {
    cropper = new Cropper($refs.image, {
        aspectRatio: 1,
        viewMode: 3,
        autoCropArea: 0.8,
        responsive: true,
        checkOrientation: false,
        crop(e) {
            cropRegion = {
                x: e.detail.x,
                y: e.detail.y,
                width: e.detail.width,
                height: e.detail.height
            }
        }
    })
});" class="p-10 ">

    <div class="mt-4 space-y-3">
        <img src="{{ $temporaryUrl }}" x-ref="image" class="w-full" />
    </div>

    <button type="button" @click="dispatchCroppedImage"
        class="mt-2 flex w-full justify-center rounded-md px-3 py-1.5 text-sm/6 font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 focus-visible:outline-yellow-600">Crop
        and Save</button>
</div>
