<div x-data="{ showToast: false }">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.profile') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <x-heroicon-o-currency-dollar class="size-6 inline-block" />

                &nbsp;&nbsp;Referrals
            </p>
            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', auth()->user()->username) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                {{-- <a href="{{ route('card.show', auth()->user()->username) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-xs font-semibold shadow-xs flex bg-white text-black items-center">
                    View&nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" />
                </a> --}}

                <a href="{{ route('card.show', auth()->user()->username) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>

        </div>
        <div class="h-fit col-span-2">
            <h1 class="text-xl text-slate-800 dark:text-slate-300">Your Referrals
            </h1>
            <p class="text-slate-600 dark:text-slate-500 text-sm">Here are the people who signed up using your referral
                link. Keep sharing your referral link to grow your network and earn!</p>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-4">

        <h1
            class="flex items-center justify-center text-base font-medium text-center text-slate-800 dark:text-slate-300">
            Overview
        </h1>
        <div class="mx-5" wire:ignore>
            <canvas id="referralChart"></canvas>
        </div>
    </div>

    {{-- <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
        <div class="grid grid-cols-3 gap-4 height-auto">

            <div class="flex flex-col">
                <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                    <p
                        class="flex items-center justify-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                        Total Earning
                    </p>

                    <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium text-center">

    </h1>

</div>
</div>

<div class="flex flex-col">
    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
        <p class="flex items-center justify-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
            This Period
        </p>

        <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium text-center">

        </h1>

    </div>
</div>

<div class="flex flex-col">
    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
        <p class="flex items-center justify-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
            Referral Total
        </p>

        <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium text-center">
            {{ $referral_total }}
        </h1>

    </div>
</div>
</div>
</div> --}}


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <div class="w-full  px-5">
            @if ($referrals->count())
                <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600">
                    @foreach ($referrals as $referral)
                        @php
                            if ($referral->firstname && $referral->lastname) {
                                $fullname = $referral->firstname . ' ' . $referral->lastname;
                            }
                        @endphp
                        <li>
                            <a href="{{ route('referrals.info', $referral->user_id) }}"
                                class="flex justify-between gap-x-6 py-1 sm:py-3 items-center">
                                <div class="flex min-w-0 gap-x-4">
                                    <img class="size-12 flex-none rounded-full bg-gray-50"
                                        src="{{ $referral->profile_pic ? asset($referral->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                                        alt="{{ $fullname ?? 'User #' . $referral->user_id }}">
                                    <div class="min-w-0 flex-auto">
                                        <p class="truncate text-sm/6 font-semibold text-gray-900 dark:text-slate-300">
                                            {{ $fullname ?? 'User #' . $referral->user_id }}
                                        </p>
                                        <p class="truncate text-xs/5 text-gray-500">
                                            {{ $referral->job_title ?? 'Setup Incomplete' }}
                                        </p>
                                    </div>
                                </div>

                                <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                                    <span class="rounded-full text-gray-600 p-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="size-4">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="m8.25 4.5 7.5 7.5-7.5 7.5" />
                                        </svg>

                                    </span>
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>

                <div class="mt-4">
                    {{ $referrals->links() }}
                    {{-- {{ $referrals->links('livewire::tailwind') }} --}}
                </div>
            @else
                <div class=" justify-center items-center my-20">
                    <p class="text-center text-slate-600 dark:text-slate-500 text-base mb-2"> No
                        referrals. Share your referral link!
                    </p>
                    <a @click="showCopyReferCodeModal=!showCopyReferCodeModal"
                        class="cursor-pointer w-fit flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">My
                        link &nbsp;
                        <x-heroicon-o-link class="size-4" />
                    </a>
                </div>
            @endif
        </div>

        <!-- Toast Notification -->
        <div x-show="showToast" x-cloak x-transition:enter="transition transform ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0"
            x-transition:leave="transition transform ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0" x-transition:leave-end="opacity-0 translate-y-2"
            class="fixed bottom-5 left-1/2 transform -translate-x-1/2 bg-green-500 text-white text-sm font-semibold px-4 py-2 rounded-md shadow-lg z-50"
            style="z-index: 99999px">
            Copied to clipboard.
        </div>

    </div>

    {{-- @endif --}}

    {{-- @push('scripts')
        <script>
            document.addEventListener('livewire:navigated', () => {

                const component = Livewire.find(document.querySelector('[wire\\:id]')?.getAttribute('wire:id'));
                if (!component) return;

                const chartEl = document.getElementById('referralChart');

                const referral_count_by_month = component.referral_count_by_month;

                const months = component.months;

                let referralChart;

                if (!chartEl) return;

                const ctx = chartEl.getContext('2d');

                if (window.referralChart instanceof Chart) {
                    window.referralChart.destroy();
                }

                window.referralChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: months,
                        datasets: [{
                            label: 'Referral Count',
                            data: referral_count_by_month,
                            borderWidth: 1
                        }, ]
                    },
                    options: {
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    stepSize: 1
                                }
                            }
                        }
                    }
                });

            });
        </script>
    @endpush --}}


    @push('scripts')
        <script>
            // document.addEventListener('livewire:navigated', () => {
            //     const component = Livewire.find(document.querySelector('[wire\\:id]')?.getAttribute('wire:id'));
            //     if (!component) return;

            //     const chartEl = document.getElementById('referralChart');

            //     if (!chartEl) return;

            //     const ctx = chartEl.getContext('2d');

            //     // Destroy existing chart instance if it exists
            //     if (window.referralChart instanceof Chart) {
            //         window.referralChart.destroy();
            //     }

            //     const referral_count_by_month = component.referral_count_by_month;
            //     const months = component.months;

            //     // Initialize the chart
            //     window.referralChart = new Chart(ctx, {
            //         type: 'line',
            //         data: {
            //             labels: months,
            //             datasets: [{
            //                 label: 'Referral Count',
            //                 data: referral_count_by_month,
            //                 borderWidth: 1
            //             }]
            //         },
            //         options: {
            //             scales: {
            //                 y: {
            //                     beginAtZero: true,
            //                     ticks: {
            //                         stepSize: 1
            //                     }
            //                 }
            //             }
            //         }
            //     });
            // });


            function initChart() {
                const component = Livewire.find(document.querySelector('[wire\\:id]')?.getAttribute('wire:id'));
                if (!component) return;

                const chartEl = document.getElementById('referralChart');

                if (!chartEl) return;

                const ctx = chartEl.getContext('2d');

                // Destroy existing chart instance if it exists
                if (window.referralChart instanceof Chart) {
                    window.referralChart.destroy();
                }

                const referral_count_by_month = component.referral_count_by_month;
                const months = component.months;

                // Initialize the chart
                window.referralChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: months,
                        datasets: [{
                            label: 'Referral Count',
                            data: referral_count_by_month,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    stepSize: 1
                                }
                            }
                        }
                    }
                });
            }

            document.addEventListener('livewire:navigated', () => {
                initChart();
            });
        </script>
    @endpush

</div>
