<div class="mb-20">

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">
        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.referrals') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <x-heroicon-o-information-circle class="size-6 inline-block" />

                {{-- &nbsp;&nbsp;{{ $ref_fullname }} --}}
                &nbsp;&nbsp;Referred Information
            </p>


            @if ($exist)
                <div class="flex items-center col-span-1 place-content-end">
                    {{-- <a href="{{ route('card.show', $referred->username) }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                    </a> --}}

                    {{-- <a href="{{ route('card.show', $referred->username) }}"
                        class="w-fit rounded-md px-2 py-1.5 text-xs font-semibold shadow-xs flex bg-white text-black items-center">
                        View&nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" />
                    </a> --}}

                    <a href="{{ route('card.show', $referred->username) }}"
                        class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                        View Card
                        {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                    </a>
                </div>
            @endif

        </div>
    </div>

    @if ($exist)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-4">

            <div class="mx-auto w-6/12">
                <img src="{{ asset($referred->profile_pic ?? 'img/profile-placeholder.jpg') }}"
                    class="rounded-full border-2 border-yellow-600 p-2 w-full z-0">

            </div>

            <h1
                class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center text-slate-800 dark:text-slate-300 mt-5 mx-5">
                <span> {{ $ref_fullname }}
                    @if ($referred->user_type == 'Gold')
                        <x-gmdi-verified class="size-4 inline text-yellow-400" />
                    @elseif($referred->user_type == 'Platinum')
                        <x-gmdi-verified class="size-4 inline text-blue-500" />
                    @endif
                </span>
            </h1>

            {{-- Display Card Type --}}
            <p class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1">
                @if (auth()->user()->onTrial())
                    <span
                        class="inline-flex items-center rounded-md bg-green-100 px-2 py-1 text-xs font-medium text-green-700 ring-1 ring-pink-700/10 ring-inset mr-2">Trial</span>
                @endif

                @if ($referred->user_type === 'Basic')
                    <span
                        class="inline-flex items-center rounded-md bg-pink-100 px-2 py-1 text-xs font-medium text-pink-700 ring-1 ring-pink-700/10 ring-inset">{{ $term_basic }}</span>
                @elseif($referred->user_type === 'Gold')
                    <span
                        class="inline-flex items-center rounded-md bg-yellow-100 px-2 py-1 text-xs font-medium text-yellow-800 ring-1 ring-yellow-600/20 ring-inset">{{ $term_gold }}</span>
                @elseif($referred->user_type === 'Sponsored')
                    <span
                        class="inline-flex items-center rounded-md bg-red-400 px-2 py-1 text-xs font-medium text-red-800 ring-1 ring-yellow-600/20 ring-inset">{{ $referred->user_type }}</span>
                @elseif($referred->user_type === 'Platinum')
                    <span
                        class="inline-flex items-center rounded-md bg-gray-100 px-2 py-1 text-xs font-medium text-gray-600 ring-1 ring-gray-500/10 ring-inset">{{ $term_platinum->user_type }}</span>
                @elseif($referred->user_type === 'Influencer')
                    <span
                        class="inline-flex items-center rounded-md bg-pink-400 px-2 py-1 text-xs font-medium text-pink-800 ring-1 ring-yellow-600/20 ring-inset">{{ $referred->user_type }}</span>
                @else
                    <span
                        class="inline-flex items-center rounded-md bg-gray-100 px-2 py-1 text-xs font-medium text-gray-600 ring-1 ring-gray-500/10 ring-inset">{{ $referred->user_type ?? 'Setup Incomplete' }}</span>
                @endif
            </p>

        </div>

        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-4">

            <h1 class="flex text-base text-slate-800 dark:text-slate-300 mb-2 items-center">
                Transactions&nbsp;&nbsp;<x-heroicon-o-arrow-path class="size-5 inline-block" />
            </h1>

            {{-- <div class="w-full bg-white dark:bg-zinc-900 rounded-2xl p-5">
            @if ($invoices->count() && $is_subscribed)

                <ul role="list" class="w-full divide-y divide-gray-100 dark:divide-gray-600">
                    @foreach ($invoices as $invoice)
                        <li class="flex justify-between gap-x-6 py-3">
                            <div class="min-w-0 gap-x-4 items-center">
                                <p class="font-bold text-base text-gray-900 dark:text-slate-300">
                                    {{ $invoice->total() }}
                                </p>
                                <p class="text-sm/6 text-gray-900 dark:text-slate-300">
                                    {{ $invoice->date()->format('M d, Y') }}
                                </p>
                            </div>
                            <div class="shrink-0 flex items-center">
                                <p class="text-green-600 font-bold text-base">
                                    + ${{ number_format(($invoice->rawTotal() / 100) * 0.1, 2) }}
                                </p>
                            </div>
                        </li>
                    @endforeach
                </ul>

                <div class="mt-4">
                    {{ $invoices->links() }}
                </div>
            @else
                <div class="w-full items-center my-10">
                    <p class="text-center text-slate-600 dark:text-slate-500 text-base mb-2"> No
                        transaction(s).
                    </p>
                </div>
            @endif

        </div> --}}

            <div class="w-full bg-white dark:bg-zinc-900 rounded-2xl p-5">
                @if ($commissions->count() && $is_subscribed)
                    <ul role="list" class="w-full divide-y divide-gray-100 dark:divide-gray-600">
                        @foreach ($commissions as $commission)
                            <li class="flex justify-between gap-x-6 py-3">
                                <div class="min-w-0 gap-x-4 items-center">
                                    <p class="text-base text-gray-900 dark:text-slate-300">
                                        <span
                                            class="font-bold">{{ $commission->stripe_invoice_total ?? 'No Invoice' }}</span>
                                        <small>({{ number_format($commission->commission_rate, 0) }}%)</small>
                                    </p>
                                    <p class="text-sm/6 text-gray-900 dark:text-slate-300">
                                        {{ $commission->created_at->format('M d, Y') }}
                                    </p>
                                </div>
                                <div class="shrink-0 flex items-center">
                                    <p class="text-green-600 font-bold text-base">
                                        + ${{ $commission->amount }}
                                    </p>
                                </div>
                            </li>
                        @endforeach
                    </ul>

                    <div class="mt-4">
                        {{-- {{ $commissions->links() }} --}}

                    </div>
                @else
                    <div class="w-full items-center my-10">
                        <p class="text-center text-slate-600 dark:text-slate-500 text-base mb-2"> No
                            transaction(s).
                        </p>
                    </div>
                @endif

            </div>
        </div>
    @endif
</div>
