<div class="bg-slate-200">
    <div class="flex min-h-full flex-col justify-center px-6 py-12 lg:px-8">
        <div class="sm:mx-auto sm:w-full sm:max-w-sm">
            <img class="mx-auto w-sm" src="{{ $logo ? asset($logo) : asset('img/10kcards-black-logo.webp') }}">

            <h2 class="mt-10 text-center text-2xl/9 font-bold tracking-tight text-gray-900">Sign Up</h2>
        </div>

        <div class="mt-10 sm:mx-auto sm:w-full sm:max-w-lg">

            <form wire:submit.prevent="registerUser">

                <div class="space-y-12">
                    <div class="border-b border-gray-900/10 pb-12">
                        <h2 class="text-base/7 font-semibold text-gray-900">Account Information</h2>
                        <p class="mt-1 text-sm/6 text-gray-600">Please provide the necessary details for account
                            registration to complete the process and set up your account.</p>
                        <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">
                            @if ($referrer)
                                <div class="col-span-full">
                                    <label for="referrer" class="block text-sm/6 font-medium text-gray-900">Referred
                                        by</label>
                                    <div class="mt-2">
                                        <div
                                            class="flex items-center rounded-md bg-white pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('referrer') border border-red-600 @enderror {{ session('referrer') ? 'border border-red-600' : '' }}">
                                            <input disabled type="text" id="referrer" wire:model="referrer"
                                                class="block min-w-0 grow py-1.5 pr-3 pl-1 text-sm/6 text-gray-900 placeholder:text-gray-400 focus:outline-none rounded-md"
                                                placeholder="referrer" value="{{ old('referrer') }}">
                                        </div>
                                    </div>

                                    @error('referrer')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror

                                    {{-- Custom error message --}}
                                    @if (session('referrer'))
                                        <p class="mt-1 text-sm/6 text-red-600">
                                            {{ session('referrer') }}
                                        </p>
                                    @endif
                                </div>
                            @endif

                            <div class="col-span-full">
                                <livewire:register-profile-picture-field />
                                <p class="block text-sm/6 font-medium text-gray-900 text-center py-5">Profile Picture
                                </p>
                            </div>

                            <div class="col-span-full">
                                <label for="username" class="block text-sm/6 font-medium text-gray-900">Username</label>
                                <div class="mt-2">
                                    <div
                                        class="flex items-center rounded-md bg-white pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('username') border border-red-600 @enderror {{ session('username') ? 'border border-red-600' : '' }}">
                                        <div
                                            class="shrink-0 text-sm/6 font-medium text-gray-500 select-none sm:text-sm/6">
                                            {{ $site_url }}</div>
                                        <input type="text" id="username" wire:model="username" inputmode="search"
                                            autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false"
                                            name="search"
                                            class="block min-w-0 grow py-1.5 pr-3 pl-1 text-sm/6 text-gray-900 placeholder:text-gray-400 focus:outline-none rounded-md"
                                            placeholder="username" value="{{ old('username') }}">
                                    </div>
                                </div>

                                @error('username')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                                {{-- Custom error message --}}
                                @if (session('username'))
                                    <p class="mt-1 text-sm/6 text-red-600">
                                        {{ session('username') }}
                                    </p>
                                @endif
                            </div>

                            <div class="col-span-full">
                                <label for="email" class="block text-sm/6 font-medium text-gray-900">Email
                                    address</label>
                                <div class="mt-2">
                                    <input id="email" type="email" wire:model="email"
                                        class="block w-full rounded-md bg-white px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 {{ session('email') ? 'border border-red-600' : '' }} @error('email') border border-red-600 @enderror"
                                        value="{{ old('email') }}">
                                </div>
                                @error('email')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                                {{-- Custom error message --}}
                                @if (session('email'))
                                    <p class="mt-1 text-sm/6 text-red-600">
                                        {{ session('email') }}
                                    </p>
                                @endif
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="password" class="block text-sm/6 font-medium text-gray-900">
                                    Password</label>
                                <div class="mt-2">
                                    <input id="password" type="password" wire:model="password"
                                        class="block w-full rounded-md bg-white px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('password') border border-red-600 @enderror">
                                </div>

                                @error('password')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="password_confirmation" class="block text-sm/6 font-medium text-gray-900">
                                    Retype Password</label>
                                <div class="mt-2">
                                    <input id="password_confirmation" wire:model="password_confirmation" type="password"
                                        class="block w-full rounded-md bg-white px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('password_confirmation') border border-red-600 @enderror">
                                </div>
                            </div>

                            {{-- Firstname --}}
                            <div class="col-span-full sm:col-span-2">
                                <label for="firstname" class="block text-sm/6 font-medium text-gray-900">
                                    First Name</label>
                                <div class="mt-2">
                                    <input id="firstname" type="text" wire:model="firstname"
                                        class="block w-full rounded-md bg-white px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('firstname') border border-red-600 @enderror">
                                </div>

                                @error('firstname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                            </div>

                            {{-- Last Name --}}
                            <div class="col-span-full sm:col-span-2">
                                <label for="lastname" class="block text-sm/6 font-medium text-gray-900">
                                    Last Name</label>
                                <div class="mt-2">
                                    <input id="lastname" type="text" wire:model="lastname"
                                        class="block w-full rounded-md bg-white px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('lastname') border border-red-600 @enderror">
                                </div>

                                @error('lastname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            {{-- Job Title --}}
                            <div class="col-span-full">
                                <label for="job_title" class="block text-sm/6 font-medium text-gray-900">
                                    Job Title</label>
                                <div class="mt-2">
                                    <input id="job_title" type="text" wire:model="job_title"
                                        class="block w-full rounded-md bg-white px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('job_title') border border-red-600 @enderror">
                                </div>

                                @error('job_title')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="phone" class="block text-sm/6 font-semibold text-gray-900">Phone
                                    number</label>
                                <div class="mt-2">
                                    <input id="phone" type="tel" wire:model="phone"
                                        class="block w-full rounded-md bg-white px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('phone') border border-red-600 @enderror"
                                        placeholder="1234567890" value="{{ old('phone') }}">
                                </div>

                                @error('phone')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="country"
                                    class="block text-sm/6 font-medium text-gray-900">Country</label>
                                <div class="mt-2 grid grid-cols-1">
                                    <select id="country" wire:model.live="country" wire:key="country-select"
                                        class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('country') border border-red-600 @enderror">
                                        <option {{ old('country', '') === '' ? 'selected' : '' }}>Select
                                            Country
                                        </option>

                                        {{-- <option {{ old('gender', '') === '' ? 'selected' : '' }}>Select Gender
                                        </option> --}}
                                        <option value="United States"
                                            {{ old('country', '') === 'United States' ? 'selected' : '' }}>
                                            United States
                                        </option>
                                        <option value="Philippines"
                                            {{ old('country', '') === 'Philippines' ? 'selected' : '' }}>Philippines
                                        </option>
                                        <option value="Afghanistan"
                                            {{ old('country', '') === 'Afghanistan' ? 'selected' : '' }}>Afghanistan
                                        </option>
                                        <option value="Albania"
                                            {{ old('country', '') === 'Albania' ? 'selected' : '' }}>
                                            Albania</option>
                                        <option value="Algeria"
                                            {{ old('country', '') === 'Algeria' ? 'selected' : '' }}>
                                            Algeria</option>
                                        <option value="Andorra"
                                            {{ old('country', '') === 'Andorra' ? 'selected' : '' }}>
                                            Andorra</option>
                                        <option value="Angola"
                                            {{ old('country', '') === 'Angola' ? 'selected' : '' }}>
                                            Angola</option>
                                        <option value="Antigua and Barbuda"
                                            {{ old('country', '') === 'Antigua and Barbuda' ? 'selected' : '' }}>
                                            Antigua and
                                            Barbuda</option>
                                        <option value="Argentina"
                                            {{ old('country', '') === 'Argentina' ? 'selected' : '' }}>Argentina
                                        </option>
                                        <option value="Armenia"
                                            {{ old('country', '') === 'Armenia' ? 'selected' : '' }}>
                                            Armenia</option>
                                        <option value="Australia"
                                            {{ old('country', '') === 'Australia' ? 'selected' : '' }}>Australia
                                        </option>
                                        <option value="Austria"
                                            {{ old('country', '') === 'Austria' ? 'selected' : '' }}>
                                            Austria</option>
                                        <option value="Azerbaijan"
                                            {{ old('country', '') === 'Azerbaijan' ? 'selected' : '' }}>Azerbaijan
                                        </option>
                                        <option value="Bahamas"
                                            {{ old('country', '') === 'Bahamas' ? 'selected' : '' }}>
                                            Bahamas</option>
                                        <option value="Bahrain"
                                            {{ old('country', '') === 'Bahrain' ? 'selected' : '' }}>
                                            Bahrain</option>
                                        <option value="Bangladesh"
                                            {{ old('country', '') === 'Bangladesh' ? 'selected' : '' }}>Bangladesh
                                        </option>
                                        <option value="Barbados"
                                            {{ old('country', '') === 'Barbados' ? 'selected' : '' }}>Barbados</option>
                                        <option value="Belarus"
                                            {{ old('country', '') === 'Belarus' ? 'selected' : '' }}>
                                            Belarus</option>
                                        <option value="Belgium"
                                            {{ old('country', '') === 'Belgium' ? 'selected' : '' }}>
                                            Belgium</option>
                                        <option value="Belize"
                                            {{ old('country', '') === 'Belize' ? 'selected' : '' }}>
                                            Belize</option>
                                        <option value="Benin" {{ old('country', '') === 'Benin' ? 'selected' : '' }}>
                                            Benin</option>
                                        <option value="Bhutan"
                                            {{ old('country', '') === 'Bhutan' ? 'selected' : '' }}>
                                            Bhutan</option>
                                        <option value="Bolivia"
                                            {{ old('country', '') === 'Bolivia' ? 'selected' : '' }}>
                                            Bolivia</option>
                                        <option value="Bosnia and Herzegovina"
                                            {{ old('country', '') === 'Bosnia and Herzegovina' ? 'selected' : '' }}>
                                            Bosnia and
                                            Herzegovina</option>
                                        <option value="Botswana"
                                            {{ old('country', '') === 'Botswana' ? 'selected' : '' }}>Botswana</option>
                                        <option value="Brazil"
                                            {{ old('country', '') === 'Brazil' ? 'selected' : '' }}>
                                            Brazil</option>
                                        <option value="Brunei"
                                            {{ old('country', '') === 'Brunei' ? 'selected' : '' }}>
                                            Brunei</option>
                                        <option value="Bulgaria"
                                            {{ old('country', '') === 'Bulgaria' ? 'selected' : '' }}>Bulgaria</option>
                                        <option value="Burkina Faso"
                                            {{ old('country', '') === 'Burkina Faso' ? 'selected' : '' }}>Burkina Faso
                                        </option>
                                        <option value="Burundi"
                                            {{ old('country', '') === 'Burundi' ? 'selected' : '' }}>
                                            Burundi</option>
                                        <option value="Cabo Verde"
                                            {{ old('country', '') === 'Cabo Verde' ? 'selected' : '' }}>Cabo Verde
                                        </option>
                                        <option value="Cambodia"
                                            {{ old('country', '') === 'Cambodia' ? 'selected' : '' }}>Cambodia</option>
                                        <option value="Cameroon"
                                            {{ old('country', '') === 'Cameroon' ? 'selected' : '' }}>Cameroon</option>
                                        <option value="Canada"
                                            {{ old('country', '') === 'Canada' ? 'selected' : '' }}>
                                            Canada</option>
                                        <option value="Central African Republic"
                                            {{ old('country', '') === 'Central African Republic' ? 'selected' : '' }}>
                                            Central African
                                            Republic</option>
                                        <option value="Chad" {{ old('country', '') === 'Chad' ? 'selected' : '' }}>
                                            Chad</option>
                                        <option value="Chile" {{ old('country', '') === 'Chile' ? 'selected' : '' }}>
                                            Chile</option>
                                        <option value="China" {{ old('country', '') === 'China' ? 'selected' : '' }}>
                                            China</option>
                                        <option value="Colombia"
                                            {{ old('country', '') === 'Colombia' ? 'selected' : '' }}>Colombia</option>
                                        <option value="Comoros"
                                            {{ old('country', '') === 'Comoros' ? 'selected' : '' }}>
                                            Comoros</option>
                                        <option value="Congo (Congo-Brazzaville)"
                                            {{ old('country', '') === 'Congo (Congo-Brazzaville)' ? 'selected' : '' }}>
                                            Congo
                                            (Congo-Brazzaville)</option>
                                        <option value="Congo (Congo-Kinshasa)"
                                            {{ old('country', '') === 'Congo (Congo-Kinshasa)' ? 'selected' : '' }}>
                                            Congo
                                            (Congo-Kinshasa)</option>
                                        <option value="Costa Rica"
                                            {{ old('country', '') === 'Costa Rica' ? 'selected' : '' }}>Costa Rica
                                        </option>
                                        <option value="Croatia"
                                            {{ old('country', '') === 'Croatia' ? 'selected' : '' }}>
                                            Croatia</option>
                                        <option value="Cuba" {{ old('country', '') === 'Cuba' ? 'selected' : '' }}>
                                            Cuba</option>
                                        <option value="Cyprus"
                                            {{ old('country', '') === 'Cyprus' ? 'selected' : '' }}>
                                            Cyprus</option>
                                        <option value="Czech Republic"
                                            {{ old('country', '') === 'Czech Republic' ? 'selected' : '' }}>Czech
                                            Republic
                                        </option>
                                        <option value="Denmark"
                                            {{ old('country', '') === 'Denmark' ? 'selected' : '' }}>
                                            Denmark</option>
                                        <option value="Djibouti"
                                            {{ old('country', '') === 'Djibouti' ? 'selected' : '' }}>Djibouti</option>
                                        <option value="Dominica"
                                            {{ old('country', '') === 'Dominica' ? 'selected' : '' }}>Dominica</option>
                                        <option value="Dominican Republic"
                                            {{ old('country', '') === 'Dominican Republic' ? 'selected' : '' }}>
                                            Dominican Republic
                                        </option>
                                        <option value="Ecuador"
                                            {{ old('country', '') === 'Ecuador' ? 'selected' : '' }}>
                                            Ecuador</option>
                                        <option value="Egypt" {{ old('country', '') === 'Egypt' ? 'selected' : '' }}>
                                            Egypt</option>
                                        <option value="El Salvador"
                                            {{ old('country', '') === 'El Salvador' ? 'selected' : '' }}>El Salvador
                                        </option>
                                        <option value="Equatorial Guinea"
                                            {{ old('country', '') === 'Equatorial Guinea' ? 'selected' : '' }}>
                                            Equatorial Guinea
                                        </option>
                                        <option value="Eritrea"
                                            {{ old('country', '') === 'Eritrea' ? 'selected' : '' }}>
                                            Eritrea</option>
                                        <option value="Estonia"
                                            {{ old('country', '') === 'Estonia' ? 'selected' : '' }}>
                                            Estonia</option>
                                        <option value="Eswatini"
                                            {{ old('country', '') === 'Eswatini' ? 'selected' : '' }}>Eswatini</option>
                                        <option value="Ethiopia"
                                            {{ old('country', '') === 'Ethiopia' ? 'selected' : '' }}>Ethiopia</option>
                                        <option value="Fiji" {{ old('country', '') === 'Fiji' ? 'selected' : '' }}>
                                            Fiji</option>
                                        <option value="Finland"
                                            {{ old('country', '') === 'Finland' ? 'selected' : '' }}>
                                            Finland</option>
                                        <option value="France"
                                            {{ old('country', '') === 'France' ? 'selected' : '' }}>
                                            France</option>
                                        <option value="Gabon" {{ old('country', '') === 'Gabon' ? 'selected' : '' }}>
                                            Gabon</option>
                                        <option value="Gambia"
                                            {{ old('country', '') === 'Gambia' ? 'selected' : '' }}>
                                            Gambia</option>
                                        <option value="Georgia"
                                            {{ old('country', '') === 'Georgia' ? 'selected' : '' }}>
                                            Georgia</option>
                                        <option value="Germany"
                                            {{ old('country', '') === 'Germany' ? 'selected' : '' }}>
                                            Germany</option>
                                        <option value="Ghana" {{ old('country', '') === 'Ghana' ? 'selected' : '' }}>
                                            Ghana</option>
                                        <option value="Greece"
                                            {{ old('country', '') === 'Greece' ? 'selected' : '' }}>
                                            Greece</option>
                                        <option value="Grenada"
                                            {{ old('country', '') === 'Grenada' ? 'selected' : '' }}>
                                            Grenada</option>
                                        <option value="Guatemala"
                                            {{ old('country', '') === 'Guatemala' ? 'selected' : '' }}>Guatemala
                                        </option>
                                        <option value="Guinea"
                                            {{ old('country', '') === 'Guinea' ? 'selected' : '' }}>
                                            Guinea</option>
                                        <option value="Guinea-Bissau"
                                            {{ old('country', '') === 'Guinea-Bissau' ? 'selected' : '' }}>
                                            Guinea-Bissau
                                        </option>
                                        <option value="Guyana"
                                            {{ old('country', '') === 'Guyana' ? 'selected' : '' }}>
                                            Guyana</option>
                                        <option value="Haiti" {{ old('country', '') === 'Haiti' ? 'selected' : '' }}>
                                            Haiti</option>
                                        <option value="Honduras"
                                            {{ old('country', '') === 'Honduras' ? 'selected' : '' }}>Honduras
                                        </option>
                                        <option value="Hungary"
                                            {{ old('country', '') === 'Hungary' ? 'selected' : '' }}>
                                            Hungary</option>
                                        <option value="Iceland"
                                            {{ old('country', '') === 'Iceland' ? 'selected' : '' }}>
                                            Iceland</option>
                                        <option value="India" {{ old('country', '') === 'India' ? 'selected' : '' }}>
                                            India</option>
                                        <option value="Indonesia"
                                            {{ old('country', '') === 'Indonesia' ? 'selected' : '' }}>Indonesia
                                        </option>
                                        <option value="Iran" {{ old('country', '') === 'Iran' ? 'selected' : '' }}>
                                            Iran</option>
                                        <option value="Iraq" {{ old('country', '') === 'Iraq' ? 'selected' : '' }}>
                                            Iraq</option>
                                        <option value="Ireland"
                                            {{ old('country', '') === 'Ireland' ? 'selected' : '' }}>
                                            Ireland</option>
                                        <option value="Israel"
                                            {{ old('country', '') === 'Israel' ? 'selected' : '' }}>
                                            Israel</option>
                                        <option value="Italy"
                                            {{ old('country', '') === 'Italy' ? 'selected' : '' }}>
                                            Italy</option>
                                        <option value="Jamaica"
                                            {{ old('country', '') === 'Jamaica' ? 'selected' : '' }}>
                                            Jamaica</option>
                                        <option value="Japan"
                                            {{ old('country', '') === 'Japan' ? 'selected' : '' }}>
                                            Japan</option>
                                        <option value="Jordan"
                                            {{ old('country', '') === 'Jordan' ? 'selected' : '' }}>
                                            Jordan</option>
                                        <option value="Kazakhstan"
                                            {{ old('country', '') === 'Kazakhstan' ? 'selected' : '' }}>Kazakhstan
                                        </option>
                                        <option value="Kenya"
                                            {{ old('country', '') === 'Kenya' ? 'selected' : '' }}>
                                            Kenya</option>
                                        <option value="Kiribati"
                                            {{ old('country', '') === 'Kiribati' ? 'selected' : '' }}>Kiribati
                                        </option>
                                        <option value="Korea, North"
                                            {{ old('country', '') === 'Korea, North' ? 'selected' : '' }}>Korea, North
                                        </option>
                                        <option value="Korea, South"
                                            {{ old('country', '') === 'Korea, South' ? 'selected' : '' }}>Korea, South
                                        </option>
                                        <option value="Kuwait"
                                            {{ old('country', '') === 'Kuwait' ? 'selected' : '' }}>
                                            Kuwait</option>
                                        <option value="Kyrgyzstan"
                                            {{ old('country', '') === 'Kyrgyzstan' ? 'selected' : '' }}>Kyrgyzstan
                                        </option>
                                        <option value="Laos" {{ old('country', '') === 'Laos' ? 'selected' : '' }}>
                                            Laos</option>
                                        <option value="Latvia"
                                            {{ old('country', '') === 'Latvia' ? 'selected' : '' }}>
                                            Latvia</option>
                                        <option value="Lebanon"
                                            {{ old('country', '') === 'Lebanon' ? 'selected' : '' }}>
                                            Lebanon</option>
                                        <option value="Lesotho"
                                            {{ old('country', '') === 'Lesotho' ? 'selected' : '' }}>
                                            Lesotho</option>
                                        <option value="Liberia"
                                            {{ old('country', '') === 'Liberia' ? 'selected' : '' }}>
                                            Liberia</option>
                                        <option value="Libya"
                                            {{ old('country', '') === 'Libya' ? 'selected' : '' }}>
                                            Libya</option>
                                        <option value="Liechtenstein"
                                            {{ old('country', '') === 'Liechtenstein' ? 'selected' : '' }}>
                                            Liechtenstein
                                        </option>
                                        <option value="Lithuania"
                                            {{ old('country', '') === 'Lithuania' ? 'selected' : '' }}>Lithuania
                                        </option>
                                        <option value="Luxembourg"
                                            {{ old('country', '') === 'Luxembourg' ? 'selected' : '' }}>Luxembourg
                                        </option>
                                        <option value="Madagascar"
                                            {{ old('country', '') === 'Madagascar' ? 'selected' : '' }}>Madagascar
                                        </option>
                                        <option value="Malawi"
                                            {{ old('country', '') === 'Malawi' ? 'selected' : '' }}>
                                            Malawi</option>
                                        <option value="Malaysia"
                                            {{ old('country', '') === 'Malaysia' ? 'selected' : '' }}>Malaysia
                                        </option>
                                        <option value="Maldives"
                                            {{ old('country', '') === 'Maldives' ? 'selected' : '' }}>Maldives
                                        </option>
                                        <option value="Mali" {{ old('country', '') === 'Mali' ? 'selected' : '' }}>
                                            Mali</option>
                                        <option value="Malta"
                                            {{ old('country', '') === 'Malta' ? 'selected' : '' }}>
                                            Malta</option>
                                        <option value="Marshall Islands"
                                            {{ old('country', '') === 'Marshall Islands' ? 'selected' : '' }}>Marshall
                                            Islands
                                        </option>
                                        <option value="Mauritania"
                                            {{ old('country', '') === 'Mauritania' ? 'selected' : '' }}>Mauritania
                                        </option>
                                        <option value="Mauritius"
                                            {{ old('country', '') === 'Mauritius' ? 'selected' : '' }}>Mauritius
                                        </option>
                                        <option value="Mexico"
                                            {{ old('country', '') === 'Mexico' ? 'selected' : '' }}>
                                            Mexico</option>
                                        <option value="Micronesia"
                                            {{ old('country', '') === 'Micronesia' ? 'selected' : '' }}>Micronesia
                                        </option>
                                        <option value="Moldova"
                                            {{ old('country', '') === 'Moldova' ? 'selected' : '' }}>
                                            Moldova</option>
                                        <option value="Monaco"
                                            {{ old('country', '') === 'Monaco' ? 'selected' : '' }}>
                                            Monaco</option>
                                        <option value="Mongolia"
                                            {{ old('country', '') === 'Mongolia' ? 'selected' : '' }}>Mongolia
                                        </option>
                                        <option value="Montenegro"
                                            {{ old('country', '') === 'Montenegro' ? 'selected' : '' }}>Montenegro
                                        </option>
                                        <option value="Morocco"
                                            {{ old('country', '') === 'Morocco' ? 'selected' : '' }}>
                                            Morocco</option>
                                        <option value="Mozambique"
                                            {{ old('country', '') === 'Mozambique' ? 'selected' : '' }}>Mozambique
                                        </option>
                                        <option value="Myanmar (Burma)"
                                            {{ old('country', '') === 'Myanmar (Burma)' ? 'selected' : '' }}>Myanmar
                                            (Burma)
                                        </option>
                                        <option value="Namibia"
                                            {{ old('country', '') === 'Namibia' ? 'selected' : '' }}>
                                            Namibia</option>
                                        <option value="Nauru"
                                            {{ old('country', '') === 'Nauru' ? 'selected' : '' }}>
                                            Nauru</option>
                                        <option value="Nepal"
                                            {{ old('country', '') === 'Nepal' ? 'selected' : '' }}>
                                            Nepal</option>
                                        <option value="Netherlands"
                                            {{ old('country', '') === 'Netherlands' ? 'selected' : '' }}>Netherlands
                                        </option>
                                        <option value="New Zealand"
                                            {{ old('country', '') === 'New Zealand' ? 'selected' : '' }}>New Zealand
                                        </option>
                                        <option value="Nicaragua"
                                            {{ old('country', '') === 'Nicaragua' ? 'selected' : '' }}>Nicaragua
                                        </option>
                                        <option value="Niger"
                                            {{ old('country', '') === 'Niger' ? 'selected' : '' }}>
                                            Niger</option>
                                        <option value="Nigeria"
                                            {{ old('country', '') === 'Nigeria' ? 'selected' : '' }}>
                                            Nigeria</option>
                                        <option value="North Macedonia"
                                            {{ old('country', '') === 'North Macedonia' ? 'selected' : '' }}>North
                                            Macedonia
                                        </option>
                                        <option value="Norway"
                                            {{ old('country', '') === 'Norway' ? 'selected' : '' }}>
                                            Norway</option>
                                        <option value="Oman" {{ old('country', '') === 'Oman' ? 'selected' : '' }}>
                                            Oman</option>
                                        <option value="Pakistan"
                                            {{ old('country', '') === 'Pakistan' ? 'selected' : '' }}>Pakistan
                                        </option>
                                        <option value="Palau"
                                            {{ old('country', '') === 'Palau' ? 'selected' : '' }}>
                                            Palau</option>
                                        <option value="Panama"
                                            {{ old('country', '') === 'Panama' ? 'selected' : '' }}>
                                            Panama</option>
                                        <option value="Papua New Guinea"
                                            {{ old('country', '') === 'Papua New Guinea' ? 'selected' : '' }}>Papua
                                            New Guinea
                                        </option>
                                        <option value="Paraguay"
                                            {{ old('country', '') === 'Paraguay' ? 'selected' : '' }}>Paraguay
                                        </option>
                                        <option value="Peru" {{ old('country', '') === 'Peru' ? 'selected' : '' }}>
                                            Peru</option>
                                        <option value="Poland"
                                            {{ old('country', '') === 'Poland' ? 'selected' : '' }}>
                                            Poland</option>
                                        <option value="Portugal"
                                            {{ old('country', '') === 'Portugal' ? 'selected' : '' }}>Portugal
                                        </option>
                                        <option value="Qatar"
                                            {{ old('country', '') === 'Qatar' ? 'selected' : '' }}>
                                            Qatar</option>
                                        <option value="Romania"
                                            {{ old('country', '') === 'Romania' ? 'selected' : '' }}>
                                            Romania</option>
                                        <option value="Russia"
                                            {{ old('country', '') === 'Russia' ? 'selected' : '' }}>
                                            Russia</option>
                                        <option value="Rwanda"
                                            {{ old('country', '') === 'Rwanda' ? 'selected' : '' }}>
                                            Rwanda</option>
                                        <option value="Saint Kitts and Nevis"
                                            {{ old('country', '') === 'Saint Kitts and Nevis' ? 'selected' : '' }}>
                                            Saint Kitts and
                                            Nevis</option>
                                        <option value="Saint Lucia"
                                            {{ old('country', '') === 'Saint Lucia' ? 'selected' : '' }}>Saint Lucia
                                        </option>
                                        <option value="Saint Vincent and the Grenadines"
                                            {{ old('country', '') === 'Saint Vincent and the Grenadines' ? 'selected' : '' }}>
                                            Saint Vincent and
                                            the
                                            Grenadines</option>
                                        <option value="Samoa"
                                            {{ old('country', '') === 'Samoa' ? 'selected' : '' }}>
                                            Samoa</option>
                                        <option value="San Marino"
                                            {{ old('country', '') === 'San Marino' ? 'selected' : '' }}>San Marino
                                        </option>
                                        <option value="Sao Tome and Principe"
                                            {{ old('country', '') === 'Sao Tome and Principe' ? 'selected' : '' }}>Sao
                                            Tome and
                                            Principe</option>
                                        <option value="Saudi Arabia"
                                            {{ old('country', '') === 'Saudi Arabia' ? 'selected' : '' }}>Saudi Arabia
                                        </option>
                                        <option value="Senegal"
                                            {{ old('country', '') === 'Senegal' ? 'selected' : '' }}>
                                            Senegal</option>
                                        <option value="Serbia"
                                            {{ old('country', '') === 'Serbia' ? 'selected' : '' }}>
                                            Serbia</option>
                                        <option value="Seychelles"
                                            {{ old('country', '') === 'Seychelles' ? 'selected' : '' }}>Seychelles
                                        </option>
                                        <option value="Sierra Leone"
                                            {{ old('country', '') === 'Sierra Leone' ? 'selected' : '' }}>Sierra Leone
                                        </option>
                                        <option value="Singapore"
                                            {{ old('country', '') === 'Singapore' ? 'selected' : '' }}>Singapore
                                        </option>
                                        <option value="Slovakia"
                                            {{ old('country', '') === 'Slovakia' ? 'selected' : '' }}>Slovakia
                                        </option>
                                        <option value="Slovenia"
                                            {{ old('country', '') === 'Slovenia' ? 'selected' : '' }}>Slovenia
                                        </option>
                                        <option value="Solomon Islands"
                                            {{ old('country', '') === 'Solomon Islands' ? 'selected' : '' }}>Solomon
                                            Islands
                                        </option>
                                        <option value="Somalia"
                                            {{ old('country', '') === 'Somalia' ? 'selected' : '' }}>
                                            Somalia</option>
                                        <option value="South Africa"
                                            {{ old('country', '') === 'South Africa' ? 'selected' : '' }}>South Africa
                                        </option>
                                        <option value="South Sudan"
                                            {{ old('country', '') === 'South Sudan' ? 'selected' : '' }}>South Sudan
                                        </option>
                                        <option value="Spain"
                                            {{ old('country', '') === 'Spain' ? 'selected' : '' }}>
                                            Spain</option>
                                        <option value="Sri Lanka"
                                            {{ old('country', '') === 'Sri Lanka' ? 'selected' : '' }}>Sri Lanka
                                        </option>
                                        <option value="Sudan"
                                            {{ old('country', '') === 'Sudan' ? 'selected' : '' }}>
                                            Sudan</option>
                                        <option value="Suriname"
                                            {{ old('country', '') === 'Suriname' ? 'selected' : '' }}>Suriname
                                        </option>
                                        <option value="Sweden"
                                            {{ old('country', '') === 'Sweden' ? 'selected' : '' }}>
                                            Sweden</option>
                                        <option value="Switzerland"
                                            {{ old('country', '') === 'Switzerland' ? 'selected' : '' }}>Switzerland
                                        </option>
                                        <option value="Syria"
                                            {{ old('country', '') === 'Syria' ? 'selected' : '' }}>
                                            Syria</option>
                                        <option value="Taiwan"
                                            {{ old('country', '') === 'Taiwan' ? 'selected' : '' }}>
                                            Taiwan</option>
                                        <option value="Tajikistan"
                                            {{ old('country', '') === 'Tajikistan' ? 'selected' : '' }}>Tajikistan
                                        </option>
                                        <option value="Tanzania"
                                            {{ old('country', '') === 'Tanzania' ? 'selected' : '' }}>Tanzania
                                        </option>
                                        <option value="Thailand"
                                            {{ old('country', '') === 'Thailand' ? 'selected' : '' }}>Thailand
                                        </option>
                                        <option value="Timor-Leste"
                                            {{ old('country', '') === 'Timor-Leste' ? 'selected' : '' }}>Timor-Leste
                                        </option>
                                        <option value="Togo" {{ old('country', '') === 'Togo' ? 'selected' : '' }}>
                                            Togo</option>
                                        <option value="Tonga"
                                            {{ old('country', '') === 'Tonga' ? 'selected' : '' }}>
                                            Tonga</option>
                                        <option value="Trinidad and Tobago"
                                            {{ old('country', '') === 'Trinidad and Tobago' ? 'selected' : '' }}>
                                            Trinidad and
                                            Tobago</option>
                                        <option value="Tunisia"
                                            {{ old('country', '') === 'Tunisia' ? 'selected' : '' }}>
                                            Tunisia</option>
                                        <option value="Turkey"
                                            {{ old('country', '') === 'Turkey' ? 'selected' : '' }}>
                                            Turkey</option>
                                        <option value="Turkmenistan"
                                            {{ old('country', '') === 'Turkmenistan' ? 'selected' : '' }}>Turkmenistan
                                        </option>
                                        <option value="Tuvalu"
                                            {{ old('country', '') === 'Tuvalu' ? 'selected' : '' }}>
                                            Tuvalu</option>
                                        <option value="Uganda"
                                            {{ old('country', '') === 'Uganda' ? 'selected' : '' }}>
                                            Uganda</option>
                                        <option value="Ukraine"
                                            {{ old('country', '') === 'Ukraine' ? 'selected' : '' }}>
                                            Ukraine</option>
                                        <option value="United Arab Emirates"
                                            {{ old('country', '') === 'United Arab Emirates' ? 'selected' : '' }}>
                                            United Arab
                                            Emirates</option>
                                        <option value="United Kingdom"
                                            {{ old('country', '') === 'United Kingdom' ? 'selected' : '' }}>United
                                            Kingdom
                                        </option>
                                        <option value="Uruguay"
                                            {{ old('country', '') === 'Uruguay' ? 'selected' : '' }}>
                                            Uruguay</option>
                                        <option value="Uzbekistan"
                                            {{ old('country', '') === 'Uzbekistan' ? 'selected' : '' }}>Uzbekistan
                                        </option>
                                        <option value="Vanuatu"
                                            {{ old('country', '') === 'Vanuatu' ? 'selected' : '' }}>
                                            Vanuatu</option>
                                        <option value="Vatican City"
                                            {{ old('country', '') === 'Vatican City' ? 'selected' : '' }}>Vatican City
                                        </option>
                                        <option value="Venezuela"
                                            {{ old('country', '') === 'Venezuela' ? 'selected' : '' }}>Venezuela
                                        </option>
                                        <option value="Vietnam"
                                            {{ old('country', '') === 'Vietnam' ? 'selected' : '' }}>
                                            Vietnam</option>
                                        <option value="Yemen"
                                            {{ old('country', '') === 'Yemen' ? 'selected' : '' }}>
                                            Yemen</option>
                                        <option value="Zambia"
                                            {{ old('country', '') === 'Zambia' ? 'selected' : '' }}>
                                            Zambia</option>
                                        <option value="Zimbabwe"
                                            {{ old('country', '') === 'Zimbabwe' ? 'selected' : '' }}>Zimbabwe
                                        </option>

                                    </select>
                                    <svg class="pointer-events-none col-start-1 row-start-1 mr-2 size-5 self-center justify-self-end text-gray-500 sm:size-4"
                                        viewBox="0 0 16 16" fill="currentColor" aria-hidden="true" data-slot="icon">
                                        <path fill-rule="evenodd"
                                            d="M4.22 6.22a.75.75 0 0 1 1.06 0L8 8.94l2.72-2.72a.75.75 0 1 1 1.06 1.06l-3.25 3.25a.75.75 0 0 1-1.06 0L4.22 7.28a.75.75 0 0 1 0-1.06Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>

                                @error('country')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="state" class="block text-sm/6 font-medium text-gray-900">State</label>
                                <div class="mt-2 grid grid-cols-1">
                                    <select id="state" wire:model="state" wire:key="state-select"
                                        @if (empty($availableStates)) disabled @endif
                                        class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-gray-100 py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('state') border border-red-600 @enderror">
                                        <option value="">Select State</option>
                                        @foreach ($availableStates as $stateName => $value)
                                            <option value="{{ $stateName }}" {{-- @if ($stateName === $state) selected @endif --}}>
                                                {{ $stateName }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <svg class="pointer-events-none col-start-1 row-start-1 mr-2 size-5 self-center justify-self-end text-gray-500 sm:size-4"
                                        viewBox="0 0 16 16" fill="currentColor" aria-hidden="true" data-slot="icon">
                                        <path fill-rule="evenodd"
                                            d="M4.22 6.22a.75.75 0 0 1 1.06 0L8 8.94l2.72-2.72a.75.75 0 1 1 1.06 1.06l-3.25 3.25a.75.75 0 0 1-1.06 0L4.22 7.28a.75.75 0 0 1 0-1.06Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>

                                @error('state')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                        </div>

                    </div>

                    {{-- @if ($default_ads_enabled) --}}
                    @if ($default_ads_enabled && collect($ad_items)->where('is_active', true)->count())
                        <div class="border-b border-gray-900/10 pb-12">

                            {{-- Heading --}}
                            @if ($ads_heading)
                                <h2 class="text-base/7 font-semibold text-gray-900">{{ $ads_heading }}</h2>
                            @endif

                            {{-- Description --}}
                            @if ($ads_description)
                                <p class="mt-1 text-sm/6 text-gray-600">{{ $ads_description }}</p>
                            @endif

                            {{-- ADS --}}
                            <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                                @if ($ad_items)
                                    @foreach ($ad_items as $item)
                                        @if ($item['is_active'] === true)
                                            <div class="col-span-full">
                                                {{-- <div class="col-span-2 flex flex-col gap-2"> --}}

                                                {{-- Ad image --}}
                                                {{-- <img src="{{ asset('storage/' . $item['image']) }}"
                                                class="rounded-lg w-full" alt="Ad Banner"> --}}

                                                {{-- Ad Title (Caption) --}}
                                                <p class="text-sm font-semibold text-gray-800">
                                                    {{ $item['caption'] }}
                                                </p>

                                                {{-- Optional field: let FREE users edit their link --}}
                                                {{-- <label class="block text-sm font-medium text-gray-900">
                                                Ad Link (User Editable)
                                            </label> --}}
                                                <div class="mt-2">
                                                    <input type="text"
                                                        wire:model="ads.{{ $loop->index }}.user_link"
                                                        class="block w-full rounded-md bg-white px-3 py-1.5 text-gray-900 outline outline-1 outline-gray-300 focus:outline-yellow-600 text-sm">
                                                </div>

                                            </div>
                                        @endif
                                    @endforeach
                                @endif

                            </div>

                        </div>
                    @endif

                </div>

                <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                    <a href="{{ route('login') }}" class="text-sm/6 font-semibold text-gray-900">Back to
                        Login</a>
                    <button type="submit"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2"
                        style="background: {{ $site_button_color }} !important; color: {{ $site_button_text_color }} !important;">Sign
                        Up</button>
                </div>

            </form>

        </div>
    </div>
</div>
