<div>
    @if ($user && $sale_page)
        <livewire:card-view-tracker :username="$user->username" />
        @if ($ads_top->count() > 0)
            <div wire:ignore x-data="carouselData_top()" x-cloak x-init="init"
                @touchstart.window="startTouch($event)" @touchend.window="endTouch($event)"
                class="sticky top-0 left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-full m-0 p-0 mx-auto flex flex-col content-center rounded-2xl z-50"
                style="margin-top: 0 !important; padding-top: 0 !important;">

                <!-- Carousel -->
                @if ($ad_banner_w && $ad_banner_h)
                    <div class="relative overflow-hidden w-full"
                        style="padding-top: {{ ($ad_banner_h / $ad_banner_w) * 100 }}%;">

                        <livewire:ad-component :ads="$ads_top" :username="$user->username" />
                    </div>
                @endif
            </div>

            <!-- Alpine Component -->
            @push('scripts')
                <script>
                    function carouselData_top() {
                        return {
                            activeIndex: 0,
                            ads: @js($ads_top),
                            timer: null,
                            startX: 0,

                            next() {
                                this.activeIndex = (this.activeIndex + 1) % this.ads.length;
                            },

                            prev() {
                                this.activeIndex = (this.activeIndex - 1 + this.ads.length) % this.ads.length;
                            },

                            goTo(index) {
                                this.activeIndex = index;
                            },

                            init() {
                                // this.timer = setInterval(() => {
                                //     this.next();
                                // }, 3000);

                                if (this.timer) clearInterval(this.timer);
                                this.timer = setInterval(() => this.next(), 5000);
                            },

                            startTouch(event) {
                                this.startX = event.touches[0].clientX;
                            },

                            endTouch(event) {
                                let endX = event.changedTouches[0].clientX;
                                let diffX = this.startX - endX;

                                if (Math.abs(diffX) > 50) {
                                    if (diffX > 0) {
                                        this.next(); // swipe left
                                    } else {
                                        this.prev(); // swipe right
                                    }
                                }
                            }
                        }
                    }
                </script>
            @endpush
        @endif

        @guest
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-10 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin && $ads_bottom->count() == 0 ? 'mb-20' : 'mb-2' }}">

            @endguest
            @auth

                <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin && $ads_bottom->count() == 0 ? 'mb-20' : 'mb-2' }}">
                @endauth

                <div class="grid grid-cols-2 gap-4 mb-5 pt-5">
                    <!-- back -->
                    <div class="ml-5  flex items-center">
                        <a href="{{ route('card.sales', $user->username) }}"
                            class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-chevron-left class="size-4" />
                        </a>
                    </div>

                    <!-- Share Card -->
                    <div class="mr-5 flex items-center place-content-end" x-data="{
                        urlTitle: `{{ $user['firstname'] }} {{ $user['lastname'] }} | {{ $user['job_title'] }}`,
                        shareUrl: '{{ $site_url . $user['username'] }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).then(() => {
                                    console.log('Thanks for sharing!');
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">

                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>

                        <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-up-tray class="size-5" />
                        </a>
                    </div>
                </div>

                <h1 class="text-2xl font-medium text-center mt-5 px-2">
                    {{ $sale_page->title }}</h1>

                <p class="mx-auto text-center text-base py-1 px-5">
                    {{ $sale_page->description }}
                </p>

                {{-- Gallery --}}
                @if ($image_count > 0)
                    <div class="mb-5">
                        <livewire:sales-image-component :username="$user->username" :sales_id="$sale_page->id" />
                    </div>
                @endif

                @if ($videos)
                    <div class="w-full relative mx-auto px-5 mt-10" style="z-index: 0; position: relative;"
                        x-data="initSwiper()">

                        <script>
                            // ---------- inside init(), after Swiper init() ----------
                            function updatePaginationActive(swiper) {
                                if (!swiper || !swiper.pagination || !swiper.pagination.el) return;
                                const bullets = Array.from(swiper.pagination.el.querySelectorAll('.swiper-pagination-bullet'));
                                // prefer realIndex (handles looped slides), fallback to activeIndex
                                const activeIndex = (typeof swiper.realIndex !== 'undefined') ? swiper.realIndex : (swiper.activeIndex || 0);
                                bullets.forEach((bullet, i) => {
                                    bullet.classList.toggle('swiper-pagination-bullet-active', i === activeIndex);
                                });
                            }

                            // replace the earlier pagination click handler with this:
                            const paginationEl = this.swiper.pagination && this.swiper.pagination.el;
                            if (paginationEl) {
                                paginationEl.addEventListener('click', (e) => {
                                    const bullet = e.target.closest('.swiper-pagination-bullet');
                                    if (!bullet) return;

                                    // find which bullet index was clicked
                                    const bullets = Array.from(paginationEl.querySelectorAll('.swiper-pagination-bullet'));
                                    const index = bullets.indexOf(bullet);
                                    if (index === -1) return;

                                    // explicitly ask Swiper to go to the correct real slide (handles loop)
                                    try {
                                        self.swiper.slideToLoop(index);
                                    } catch (err) {
                                        /* ignore */
                                    }

                                    // Immediately update UI so the clicked bullet looks active
                                    updatePaginationActive(self.swiper);

                                    // keep your autoplay pause behavior
                                    self._pauseAutoplayFor(10000);
                                }, {
                                    passive: true
                                });
                            }

                            function initSwiper() {
                                return {
                                    swiper: null,
                                    videoIsPlaying: false,
                                    userPausedByInteraction: false,
                                    awaitingPlayFromInteraction: false,
                                    autoplayDelay: 10000,
                                    _autoplayTimer: null,
                                    _awaitTimer: null,
                                    lastIndex: 0,
                                    _resumeTimer: null,

                                    _pauseAutoplayFor(ms = 10000) {
                                        this._stopAutoplayNow();
                                        this.userPausedByInteraction = true;

                                        if (this._resumeTimer) {
                                            clearTimeout(this._resumeTimer);
                                            this._resumeTimer = null;
                                        }

                                        this._resumeTimer = setTimeout(() => {
                                            this.userPausedByInteraction = false;
                                            this._scheduleAutoplay();
                                        }, ms);
                                    },
                                    _stopAutoplayNow() {
                                        if (this._autoplayTimer) {
                                            clearTimeout(this._autoplayTimer);
                                            this._autoplayTimer = null;
                                        }
                                    },

                                    _scheduleAutoplay() {
                                        this._stopAutoplayNow();
                                        if (this.videoIsPlaying || this.userPausedByInteraction) return;
                                        const self = this;
                                        this._autoplayTimer = setTimeout(() => {
                                            if (!self.videoIsPlaying && !self.userPausedByInteraction && self.swiper) {
                                                try {
                                                    self.swiper.slideNext();
                                                } catch {}
                                            }
                                            self._scheduleAutoplay();
                                        }, this.autoplayDelay);
                                    },

                                    _clearAwaiting() {
                                        if (this._awaitTimer) {
                                            clearTimeout(this._awaitTimer);
                                            this._awaitTimer = null;
                                        }
                                        this.awaitingPlayFromInteraction = false;
                                    },

                                    pauseAllVideos() {
                                        // Pause HTML5 videos
                                        document.querySelectorAll('.default-carousel video').forEach(v => {
                                            try {
                                                v.pause();
                                            } catch {}
                                        });

                                        // Pause Vimeo videos via SDK
                                        if (typeof Vimeo !== 'undefined') {
                                            document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                                try {
                                                    new Vimeo.Player(iframe).pause();
                                                } catch {}
                                            });
                                        }

                                        // Pause YouTube videos via postMessage
                                        document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                            try {
                                                iframe.contentWindow.postMessage(
                                                    JSON.stringify({
                                                        event: 'command',
                                                        func: 'pauseVideo',
                                                        args: []
                                                    }),
                                                    "https://www.youtube.com" // ✅ correct target origin
                                                );
                                            } catch {}
                                        });
                                    },

                                    init() {
                                        const self = this;
                                        const isLoop = {{ $video_count > 1 ? 'true' : 'false' }};
                                        const container = document.querySelector('.default-carousel');
                                        if (!container) {
                                            console.warn('initSwiper: .default-carousel not found');
                                        }

                                        // ⬇️ interaction handler — updated here
                                        const onMediaInteraction = (ev) => {
                                            const slide = ev.target && ev.target.closest ? ev.target.closest('.swiper-slide') : null;
                                            if (!slide) return;

                                            if (slide.querySelector('video, iframe')) {
                                                self.userPausedByInteraction = true;
                                                self.awaitingPlayFromInteraction = true;
                                                self._clearAwaiting();
                                                self._stopAutoplayNow();
                                            }
                                        };

                                        document.addEventListener('pointerdown', onMediaInteraction, true);
                                        document.addEventListener('touchstart', onMediaInteraction, true);
                                        document.addEventListener('mousedown', onMediaInteraction, true);
                                        document.addEventListener('click', onMediaInteraction, true);
                                        document.addEventListener('focusin', onMediaInteraction, true);

                                        // === Video event listeners ===
                                        document.querySelectorAll('.default-carousel video').forEach(video => {
                                            video.addEventListener('play', () => {
                                                self._clearAwaiting();
                                                self.videoIsPlaying = true;
                                                self.userPausedByInteraction = true;
                                                self._stopAutoplayNow();
                                            }, {
                                                passive: true
                                            });

                                            video.addEventListener('pause', () => {
                                                self.videoIsPlaying = false;
                                                self.userPausedByInteraction = false;
                                                self._clearAwaiting();
                                                self._scheduleAutoplay();
                                            }, {
                                                passive: true
                                            });

                                            video.addEventListener('ended', () => {
                                                self.videoIsPlaying = false;
                                                self.userPausedByInteraction = false;
                                                self._clearAwaiting();
                                                try {
                                                    self.swiper.slideNext();
                                                } catch {}
                                                self._scheduleAutoplay();
                                            }, {
                                                passive: true
                                            });
                                        });

                                        // YouTube: ensure enablejsapi=1
                                        document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                            try {
                                                const src = iframe.getAttribute('src') || '';
                                                if (!/enablejsapi=1/.test(src)) {
                                                    const sep = src.includes('?') ? '&' : '?';
                                                    iframe.setAttribute('src', src + sep + 'enablejsapi=1');
                                                }
                                            } catch {}
                                        });

                                        // Vimeo API events
                                        if (typeof Vimeo !== 'undefined') {
                                            document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                                try {
                                                    const player = new Vimeo.Player(iframe);
                                                    player.on('play', () => {
                                                        self._clearAwaiting();
                                                        self.videoIsPlaying = true;
                                                        self.userPausedByInteraction = true;
                                                        self._stopAutoplayNow();
                                                    });
                                                    player.on('pause', () => {
                                                        self.videoIsPlaying = false;
                                                        self.userPausedByInteraction = false;
                                                        self._scheduleAutoplay();
                                                    });
                                                    player.on('ended', () => {
                                                        self.videoIsPlaying = false;
                                                        self.userPausedByInteraction = false;
                                                        try {
                                                            self.swiper.slideNext();
                                                        } catch {}
                                                        self._scheduleAutoplay();
                                                    });
                                                } catch {}
                                            });
                                        }

                                        // YouTube API events
                                        const buildYT = () => {
                                            document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                                try {
                                                    new YT.Player(iframe, {
                                                        events: {
                                                            onStateChange: (e) => {
                                                                if (e.data === YT.PlayerState.PLAYING || e.data === YT
                                                                    .PlayerState.BUFFERING) {
                                                                    self._clearAwaiting();
                                                                    self.videoIsPlaying = true;
                                                                    self.userPausedByInteraction = true;
                                                                    self._stopAutoplayNow();
                                                                } else if (e.data === YT.PlayerState.PAUSED) {
                                                                    self.videoIsPlaying = false;
                                                                    self.userPausedByInteraction = false;
                                                                    self._scheduleAutoplay();
                                                                } else if (e.data === YT.PlayerState.ENDED) {
                                                                    self.videoIsPlaying = false;
                                                                    self.userPausedByInteraction = false;
                                                                    try {
                                                                        self.swiper.slideNext();
                                                                    } catch {}
                                                                    self._scheduleAutoplay();
                                                                }
                                                            }
                                                        }
                                                    });
                                                } catch {}
                                            });
                                        };
                                        if (window.YT && YT.Player) buildYT();
                                        else window.onYouTubeIframeAPIReady = buildYT;

                                        // Swiper init
                                        this.swiper = new Swiper('.default-carousel', {
                                            loop: isLoop,
                                            pagination: {
                                                el: '.swiper-pagination',
                                                clickable: true,
                                                dynamicBullets: false,
                                            },
                                            on: {
                                                init() {
                                                    updatePaginationActive(this);
                                                },
                                                slideChange() {
                                                    self.pauseAllVideos();
                                                    self._stopAutoplayNow();

                                                    if (!self.userPausedByInteraction && !self.videoIsPlaying) {
                                                        self._scheduleAutoplay();
                                                    }

                                                    updatePaginationActive(this);
                                                }
                                            }
                                        });

                                        // ✅ Fixed pagination handler
                                        function updatePaginationActive(swiper) {
                                            if (!swiper || !swiper.pagination || !swiper.pagination.el) return;
                                            const bullets = Array.from(swiper.pagination.el.querySelectorAll('.swiper-pagination-bullet'));
                                            const activeIndex = (typeof swiper.realIndex !== 'undefined') ? swiper.realIndex : (swiper
                                                .activeIndex || 0);
                                            bullets.forEach((bullet, i) => {
                                                bullet.classList.toggle('swiper-pagination-bullet-active', i === activeIndex);
                                            });
                                        }

                                        const paginationEl = this.swiper.pagination && this.swiper.pagination.el;
                                        if (paginationEl) {
                                            paginationEl.addEventListener('click', (e) => {
                                                const bullet = e.target.closest('.swiper-pagination-bullet');
                                                if (!bullet) return;

                                                const bullets = Array.from(paginationEl.querySelectorAll('.swiper-pagination-bullet'));
                                                const index = bullets.indexOf(bullet);
                                                if (index === -1) return;

                                                try {
                                                    self.swiper.slideToLoop(index);
                                                } catch {}

                                                updatePaginationActive(self.swiper);
                                                self._pauseAutoplayFor(10000);
                                            }, {
                                                passive: true
                                            });
                                        }

                                        this._scheduleAutoplay();
                                    }

                                };
                            }
                        </script>

                        <script src="https://www.youtube.com/iframe_api"></script>
                        <script src="https://player.vimeo.com/api/player.js"></script>

                        <div class="swiper default-carousel  mb-5" x-init="init()">
                            <div class="swiper-wrapper {{ $video_count > 1 ? 'mb-12' : 'mb-5' }}">
                                {{-- Helper: server-side Vimeo aspect detection (cached) --}}
                                @php
                                    if (!function_exists('vimeo_aspect_ratio')) {
                                        function vimeo_aspect_ratio(string $videoId, ?string $videoHash = null): string
                                        {
                                            $cacheKey = 'vimeo_oembed_ar_' . $videoId . '_' . ($videoHash ?? 'nohash');

                                            return cache()->remember($cacheKey, 86400, function () use (
                                                $videoId,
                                                $videoHash,
                                            ) {
                                                try {
                                                    // Use the exact player URL (hash-aware) for oEmbed
                                                    $playerUrl =
                                                        'https://player.vimeo.com/video/' .
                                                        $videoId .
                                                        ($videoHash ? '?h=' . $videoHash : '');
                                                    $oembedUrl =
                                                        'https://vimeo.com/api/oembed.json?url=' .
                                                        urlencode($playerUrl);

                                                    $resp = \Illuminate\Support\Facades\Http::timeout(5)
                                                        ->retry(2, 100)
                                                        ->get($oembedUrl);
                                                    if ($resp->ok()) {
                                                        $data = $resp->json();
                                                        if (!empty($data['width']) && !empty($data['height'])) {
                                                            return $data['height'] > $data['width'] ? '9/16' : '16/9';
                                                        }
                                                    }
                                                } catch (\Throwable $e) {
                                                    // swallow and fall back
                                                }
                                                return '16/9'; // safe default
                                            });
                                        }
                                    }
                                @endphp

                                {{-- Slides --}}
                                @foreach ($videos as $index => $video)
                                    @php
                                        $videoUrl = $video->video_link;
                                        $videoId = null;
                                        $videoHash = null;
                                        $isVimeo = false;
                                        $isShorts = false;
                                        $aspectRatio = '16/9'; // default
                                        $maxWidth = '800px'; // default

                                        // --- YouTube detections ---
                                        if (
                                            preg_match(
                                                '#(?:https?://)?(?:www\.)?youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#',
                                                $videoUrl,
                                                $m,
                                            )
                                        ) {
                                            $videoId = $m[1];
                                        } elseif (
                                            preg_match(
                                                '#(?:https?://)?(?:www\.)?youtube\.com/shorts/([a-zA-Z0-9_-]{11})#',
                                                $videoUrl,
                                                $m,
                                            )
                                        ) {
                                            $videoId = $m[1];
                                            $isShorts = true;
                                        } elseif (
                                            preg_match(
                                                '#(?:https?://)?(?:www\.)?youtu\.be/([a-zA-Z0-9_-]+)#',
                                                $videoUrl,
                                                $m,
                                            )
                                        ) {
                                            $videoId = $m[1];
                                        } elseif (
                                            preg_match(
                                                '#(?:https?://)?(?:www\.)?m\.youtube\.com/v/([a-zA-Z0-9_-]+)#',
                                                $videoUrl,
                                                $m,
                                            )
                                        ) {
                                            $videoId = $m[1];
                                        }
                                        // --- Vimeo detection ---
                                        elseif (
                                            preg_match('#vimeo\.com/([0-9]+)(?:/([a-zA-Z0-9]+))?#', $videoUrl, $m)
                                        ) {
                                            $videoId = $m[1];
                                            $isVimeo = true;

                                            // hash from /{videoId}/{hash}
                                            if (!empty($m[2])) {
                                                $videoHash = $m[2];
                                            }

                                            // also check for ?h= param
                                            $query = parse_url($videoUrl, PHP_URL_QUERY);
                                            if ($query) {
                                                parse_str($query, $params);
                                                if (!empty($params['h'])) {
                                                    $videoHash = $params['h'];
                                                }
                                            }

                                            // server-side aspect detection via oEmbed (cached)
                                            $aspectRatio = vimeo_aspect_ratio($videoId, $videoHash);
                                        }

                                        // Decide max width
                                        if ($isVimeo && $aspectRatio === '9/16') {
                                            $maxWidth = '450px';
                                        } elseif ($isShorts) {
                                            $aspectRatio = '9/16';
                                            $maxWidth = '450px';
                                        }
                                    @endphp

                                    <div class="swiper-slide w-full rounded-xl" data-slide-index="{{ $index }}">
                                        <div class="rounded-xl flex justify-center items-center bg-black"
                                            style="width:100%; border: 2px solid {{ $color_settings_profile_pic_border }} !important;">

                                            @if ($isVimeo)
                                                <iframe id="vimeo-player-{{ $index }}" class="rounded-xl"
                                                    src="https://player.vimeo.com/video/{{ $videoId }}{{ $videoHash ? '?h=' . $videoHash : '' }}"
                                                    frameborder="0" allow="autoplay; fullscreen" allowfullscreen
                                                    style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                                </iframe>
                                            @else
                                                <iframe id="youtube-player-{{ $index }}" class="rounded-xl"
                                                    src="https://www.youtube.com/embed/{{ $videoId }}?enablejsapi=1"
                                                    frameborder="0"
                                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                                    referrerpolicy="strict-origin-when-cross-origin" allowfullscreen
                                                    style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                                </iframe>
                                            @endif
                                        </div>

                                        <h1 class="text-xl font-medium text-center mt-5 px-2">
                                            {{ $video->product_name }}</h1>

                                        <p class="text-base font-medium text-center px-2">
                                            Price: {{ $video->price }} | Stock: {{ $video->stock }}</p>

                                        <p class="mx-auto mt-5 text-center text-base py-1 px-2">
                                            {{ $video->description }}
                                        </p>

                                        <div class="flex mt-5 justify-center gap-5">
                                            {{-- <a href="{{ route('video.cashandcarry', ['username' => $user->username, 'sales' => $sale_id, 'sales_videos' => $video->id]) }}"
                                                class="text-sm inline-flex px-5 py-3 rounded-md font-bold items-center justify-center"
                                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                                Cash & Carry
                                            </a> --}}

                                            @if ($video->shop_online_link)
                                                <a href="{{ $video->shop_online_link }}" target="_blank"
                                                    class="text-sm inline-flex px-5 py-3 rounded-md text-center font-bold items-center justify-center max-w-[83.333333%]"
                                                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                                    {{ $video->shop_online_button ? $video->shop_online_button : 'Shop' }}
                                                </a>
                                            @endif
                                        </div>

                                        <!-- Add to Cart -->
                                        <div class="flex justify-center mt-5">
                                            <div class="flex items-center gap-2">
                                                <span class="font-bold text-base mr-5">Add to Cart</span>
                                                <div class="flex items-center border rounded-md overflow-hidden">
                                                    <button type="button" class="px-2 py-1 text-lg font-bold"
                                                        onclick="updateQuantity('{{ $video->id }}', -1, 'video')">-</button>

                                                    <input type="number" value="0" min="0"
                                                        data-type="video" data-name="{{ $video->product_name }}"
                                                        data-price="{{ $video->price }}"
                                                        data-image="{{ $video->image ?? '' }}"
                                                        id="quantity-{{ $video->id }}"
                                                        class="w-12 text-center border-black focus:ring-0 focus:outline-none text-black"
                                                        oninput="saveToCart('{{ $video->id }}', 'video', this.value, this.getAttribute('data-name'), parseFloat(this.getAttribute('data-price')), this.getAttribute('data-image'))">

                                                    <button type="button" class="px-2 py-1 text-lg font-bold"
                                                        onclick="updateQuantity('{{ $video->id }}', 1, 'video')">+</button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                @endforeach

                            </div>

                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                @endif

                {{-- Direction Links --}}
                @if (in_array($user['user_type'], ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored']))
                    @if ($directions)
                        <p class="flex items-center justify-center text-center pt-5">
                            Driving Directions
                        </p>

                        <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">
                            @foreach ($directions as $direction)
                                @if ($direction['type'] == 'google_map')
                                    <a href="{{ $direction['link'] }}" target="_blank">
                                        <x-mdi-google-maps class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($direction['type'] == 'apple_map')
                                    <a href="{{ $direction['link'] }}" target="_blank">
                                        <x-fab-apple class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($direction['type'] == 'waze')
                                    <a href="{{ $direction['link'] }}" target="_blank">
                                        <x-fab-waze class="size-7 mx-2 my-2" />
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    @endif
                @endif

                {{-- @if ($payments)
                    <p class="flex items-center justify-center text-center pt-5">
                        Payment links
                    </p>

                    <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center mb-10">
                        @foreach ($payments as $payment)
                            @if ($payment['type'] === 'credit')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-heroicon-s-credit-card class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($payment['type'] == 'zelle')
                                <button
                                    @click="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{{ $payment['link'] }}'">
                                    <x-si-zelle class="size-7 mx-2 my-2" />
                                </button>
                            @elseif($payment['type'] == 'apple_pay')
                                <button
                                    @click="openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{{ $payment['link'] }}'">
                                    <x-fab-apple class="size-7 mx-2 my-2" />
                                </button>
                            @elseif($payment['type'] == 'venmo')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-bxl-venmo class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($payment['type'] == 'cashapp')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-si-cashapp class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($payment['type'] == 'paypal_email')
                                <button
                                    @click="openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{{ $payment['link'] }}'">
                                    <x-fab-paypal class="size-7 mx-2 my-2" />
                                </button>
                            @elseif($payment['type'] == 'paypal_link')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-fab-paypal class="size-7 mx-2 my-2" />
                                </a>
                            @endif
                        @endforeach
                    </div>

                @endif --}}

            </div>

            <!-- Sticky Footer -->
            <div id="cart-footer"
                class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 shadow-lg p-4 flex justify-between items-center z-50 hidden">

                <a href="{{ route('sales.cart', $user->username) }}"
                    class="bg-blue-600 text-white font-bold px-6 py-3 rounded-lg hover:bg-blue-700 transition">
                    Checkout
                </a>

                <span class="font-bold text-lg">Total: $<span id="cart-total">0.00</span></span>
            </div>

            {{-- @push('scripts')
                <script>
                    // function getCartItems() {
                    //     let items = [];
                    //     for (let key in localStorage) {
                    //         if (key.startsWith("cart_")) {
                    //             try {
                    //                 const item = JSON.parse(localStorage.getItem(key));
                    //                 if (item.quantity > 0) items.push(item);
                    //             } catch (e) {}
                    //         }
                    //     }
                    //     return items;
                    // }

                    // function updateCartFooter() {
                    //     const items = getCartItems();
                    //     const total = items.reduce((sum, item) => sum + (item.quantity * item.price), 0);

                    //     const footer = document.getElementById("cart-footer");
                    //     const totalEl = document.getElementById("cart-total");

                    //     if (items.length > 0) {
                    //         footer.classList.remove("hidden");
                    //         totalEl.textContent = total.toFixed(2);
                    //     } else {
                    //         footer.classList.add("hidden");
                    //     }
                    // }

                    // ✅ Run on load
                    document.addEventListener("DOMContentLoaded", updateCartFooter);

                    // ✅ Update whenever cart changes
                    window.addEventListener("storage", updateCartFooter);
                </script>
            @endpush --}}

            @if ($ads_bottom->count() > 0)
                <div wire:ignore x-data="carouselData_bottom()" x-init="init"
                    @touchstart.window="startTouch($event)" @touchend.window="endTouch($event)"
                    class="top-0 left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-full m-0 p-0 mx-auto flex flex-col content-center rounded-2xl z-50 {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}"
                    style="margin-top: 0 !important; padding-top: 0 !important;">

                    <!-- Carousel -->
                    @if ($ad_banner_w && $ad_banner_h)
                        <div class="relative overflow-hidden w-full"
                            style="padding-top: {{ ($ad_banner_h / $ad_banner_w) * 100 }}%;">

                            <livewire:ad-component :ads="$ads_bottom" :username="$user->username" />


                        </div>
                    @endif

                </div>

                <!-- Alpine Component -->
                @push('scripts')
                    <script>
                        function carouselData_bottom() {
                            return {
                                activeIndex: 0,
                                ads: @js($ads_bottom),
                                timer: null,
                                startX: 0,

                                next() {
                                    this.activeIndex = (this.activeIndex + 1) % this.ads.length;
                                },

                                prev() {
                                    this.activeIndex = (this.activeIndex - 1 + this.ads.length) % this.ads.length;
                                },

                                goTo(index) {
                                    this.activeIndex = index;
                                },

                                init() {


                                    if (this.timer) clearInterval(this.timer);
                                    this.timer = setInterval(() => this.next(), 5000);
                                },

                                startTouch(event) {
                                    this.startX = event.touches[0].clientX;
                                },

                                endTouch(event) {
                                    let endX = event.changedTouches[0].clientX;
                                    let diffX = this.startX - endX;

                                    if (Math.abs(diffX) > 50) {
                                        if (diffX > 0) {
                                            this.next(); // swipe left
                                        } else {
                                            this.prev(); // swipe right
                                        }
                                    }
                                }
                            }
                        }
                    </script>
                @endpush
            @endif

        </div>
    @else
        <div class="h-screen flex justify-center items-center">
            <div>
                <p class="mx-auto text-yellow-500 text-center text-l p-10">
                    <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
                </p>
                <p class="mx-auto font-bold text-center text-2xl">Event not found
                </p>

            </div>
        </div>
    @endif
</div>
