<div>
    <div id="custom_bg"
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-20 mt-5 text-black dark:text-gray-400">

        <div class="px-5">
            <h1 class="text-xl md:text-2xl font-medium text-center mt-5">
                Send us your Business Card </h1>
            {{-- form here --}}
            <form wire:submit.prevent="sendCardForm" class="w-full">

                <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                    <div class="col-span-full">
                        <livewire:register-profile-picture-field />
                        <p class="block text-sm/6 font-medium text-center pt-5">
                            Help me recognize you by uploading your picture/logo
                        </p>
                    </div>

                    <div class="col-span-full sm:col-span-2">
                        <label for="email" class="block text-sm/6 font-medium">Email
                            address</label>
                        <div class="mt-2">
                            <input id="email" type="email" wire:model="email"
                                class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 {{ session('email') ? 'border border-red-600' : '' }} @error('email') border border-red-600 @enderror"
                                value="{{ old('email') }}" placeholder="(Required)">
                        </div>
                        @error('email')
                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                        @enderror

                        {{-- Custom error message --}}
                        @if (session('email'))
                            <p class="mt-1 text-sm/6 text-red-600">
                                {{ session('email') }}
                            </p>
                        @endif
                    </div>

                    <div class="col-span-full sm:col-span-2">
                        <label for="phone" class="block text-sm/6 font-semibold">Phone
                            number</label>
                        <div class="mt-2">
                            <input id="phone" type="tel" wire:model="phone"
                                class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('phone') border border-red-600 @enderror"
                                value="{{ old('phone') }}" placeholder="(Required)">
                        </div>

                        @error('phone')
                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="col-span-full sm:col-span-2">
                        <label for="firstname" class="block text-sm/6 font-medium">First
                            name</label>
                        <div class="mt-2">
                            <input type="text" id="firstname" wire:model="firstname"
                                class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('firstname') border border-red-600 @enderror"
                                value="{{ old('firstname') }}" placeholder="(Required)">
                        </div>

                        @error('firstname')
                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="col-span-full sm:col-span-2">
                        <label for="lastname" class="block text-sm/6 font-medium">Last
                            name</label>
                        <div class="mt-2">
                            <input type="text" id="lastname" wire:model="lastname"
                                class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('lastname') border border-red-600 @enderror"
                                value="{{ old('lastname') }}" placeholder="(Required)">
                        </div>

                        @error('lastname')
                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="col-span-full">
                        <label for="digital_card" class="block text-sm/6 font-medium">
                            Your existing digital card or website</label>
                        <div class="mt-2">
                            <input type="text" id="digital_card" wire:model="digital_card"
                                class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('digital_card') border border-red-600 @enderror"
                                value="{{ old('digital_card') }}" placeholder="(Optional)">
                        </div>

                        @error('digital_card')
                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="col-span-full">
                        <livewire:physical-card-field />

                        @error('image')
                            <p class="text-sm/6 text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="col-span-full">
                        <livewire:physical-card-back-field />

                        @error('image')
                            <p class="text-sm/6 text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                </div>

                <div class="mt-10">
                    <button type="submit"
                        class="w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 "
                        style="color: {{ $site_button_text_color }} !important; background-color: {{ $site_button_color }} !important;">Send</button>
                </div>
            </form>
        </div>
    </div>
</div>
