<a href="{{ $link }}" target="_blank" data-social-id="{{ $social_id }}" data-title="{{ $title }}"
    class="socialIcon">

    @if ($social_type === 'facebook')
        <x-fab-facebook class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'snapchat')
        <x-fab-snapchat-ghost class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'fanbase')
        <fanbase-icon class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'skool')
        <skool-icon-mono class="size-8 mx-2 my-2" />
    @elseif ($social_type === 'clubhouse')
        <x-si-clubhouse class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'threads')
        <x-fab-threads class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'tiktok')
        <x-fab-tiktok class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'linkedin')
        <x-fab-linkedin class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'x')
        <x-ri-twitter-x-fill class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'instagram')
        <x-fab-instagram class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'youtube')
        <x-fab-youtube class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'pinterest')
        <x-ri-pinterest-fill class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'soundcloud')
        <x-fab-soundcloud class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'apple_podcasts')
        <x-si-applepodcasts class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'spotify')
        <x-fab-spotify class="size-6 mx-2 my-2" />
    @elseif ($social_type === 'discord')
        <x-fab-discord class="size-6 mx-2 my-2" />
    @endif
</a>

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            function getDeviceType() {
                const ua = navigator.userAgent;
                if (/mobile/i.test(ua)) return "Mobile";
                if (/tablet/i.test(ua)) return "Tablet";
                if (/iPad|Android(?!.*Mobile)/i.test(ua)) return "Tablet";
                return "Desktop";
            }

            const deviceType = getDeviceType();

            fetch('https://get.geojs.io/v1/ip/geo.json')
                .then(res => res.json())
                .then(data => {
                    const location = {
                        city: data.city,
                        region: data.region,
                        country: data.country,
                        ip: data.ip
                    };

                    const buttons = document.getElementsByClassName('socialIcon');
                    Array.from(buttons).forEach(button => {
                        button.addEventListener('click', function(e) {
                            const buttonId = this.getAttribute('data-social-id');
                            const title = this.getAttribute('data-title');

                            @this.buttonClicked(buttonId, deviceType, location);
                        });
                    });
                })
                .catch(() => {
                    const buttons = document.getElementsByClassName('socialIcon');
                    Array.from(buttons).forEach(button => {
                        button.addEventListener('click', function(e) {
                            const buttonId = this.getAttribute('data-button-id');
                            const title = this.getAttribute('data-title');

                            @this.buttonClicked(buttonId, deviceType, null);
                        });
                    });
                });
        });
    </script>
@endpush
