<div>
    <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5" x-data x-sortable
        x-on:sorted="$wire.updateOrder($event.detail)">
        @foreach ($buttons as $button)
            @php
                $shouldShow = true;
                $href = '#';
                $onclick = '';
                $target = '_blank';

                switch ($button['type']) {
                    case 'driving':
                        // $shouldShow = in_array($user->user_type, ['Gold', 'Platinum']);
                        $onclick = 'openDrivingDirectionModal=!openDrivingDirectionModal;';
                        $target = '';
                        break;

                    case 'zelle':
                        $onclick = "openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{$button['link']}'";
                        $target = '';
                        break;

                    case 'apple_pay':
                        $onclick = "openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{$button['link']}'";
                        $target = '';
                        break;

                    case 'paypal_email':
                        $onclick = "openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{$button['link']}'";
                        $target = '';
                        break;

                    case 'sms':
                        $href = 'sms:' . $button['link'];
                        break;

                    // case 'podcast':
                    //     $href = $button['link'];
                    //     break;
                    case 'email':
                        $href = 'mailto:' . $button['link'];
                        break;

                    case 'phone':
                        $href = 'tel:' . $button['link'];
                        break;

                    case 'help':
                        $shouldShow = in_array($user->user_type, [
                            'Basic',
                            'Sponsored',
                            'Influencer',
                            'Gold',
                            'Platinum',
                        ]);
                        $href = route('card.connect', $user->username);
                        break;

                    case 'exchange':
                        $shouldShow = in_array($user->user_type, [
                            'Basic',
                            'Sponsored',
                            'Influencer',
                            'Gold',
                            'Platinum',
                        ]);
                        $href = route('card.exchange', $user->username);
                        break;

                    case 'form':
                        $slug = \App\Models\LeadCaptureForm::where('id', $button->form_id)->value('slug');
                        $shouldShow = in_array($user->user_type, ['Gold', 'Platinum']);
                        $href = route('form.show', [$user->username, $slug]);
                        break;

                    case 'feedback':
                        $shouldShow = in_array($user->user_type, [
                            'Basic',
                            'Sponsored',
                            'Influencer',
                            'Gold',
                            'Platinum',
                        ]);
                        $href = route('card.feedback', $user->username);
                        break;

                    case 'bio':
                        $shouldShow = in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum']);
                        $href = route('bio.show', $user->username);
                        break;

                    case 'shop':
                        $shouldShow = in_array($user->user_type, ['Gold', 'Platinum']);
                        $href = route('card.products', $user->username);
                        break;

                    case 'services':
                        $shouldShow = in_array($user->user_type, ['Gold', 'Platinum']);
                        $href = route('card.services', $user->username);
                        break;

                    case 'events':
                        $shouldShow = in_array($user->user_type, ['Basic', 'Gold', 'Platinum']);
                        $href = route('card.events', $user->username);
                        break;

                    // case 'sales':
                    //     $shouldShow = in_array($user->user_type, ['Gold', 'Platinum']);
                    //     break;

                    case 'team':
                        $shouldShow = in_array($user->user_type, ['Gold', 'Platinum']);
                        $href = route('card.team', [$user->username, $button->id]);
                        break;

                    case 'zoom_replay':
                        $shouldShow = in_array($user->user_type, ['Gold', 'Platinum']);
                        $href = route('card.zoomreplay', $user->username);
                        break;

                    case 'reviews':
                        $shouldShow = in_array($user->user_type, ['Gold', 'Platinum']);
                        $href = route('card.reviews', $user->username);
                        break;

                    case 'trusted_network':
                        $shouldShow = in_array($user->user_type, ['Platinum']);
                        $href = route('card.trustednetwork', $user->username);
                        break;

                    case 'payments':
                        $shouldShow = $user->user_type != 'Free';
                        $href = route('card.pay', $user->username);
                        break;

                    default:
                        $href = $button['link'];
                        break;
                }
            @endphp

            @if ($shouldShow)
                <li class="bg-white dark:bg-zinc-900 grid grid-cols-5 items-center justify-between gap-x-6 py-3"
                    x-data="{ button: {{ $button['is_active'] }} }" wire:key="{{ $button->id }}" x-sortable-item="{{ $button->id }}">

                    {{-- Drag handle --}}
                    {{-- <div class="col-span-1 flex items-center">
                        <div class="h-6 w-6 cursor-grab" x-sortable.handle>
                            <svg class="w-4 h-4 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M7 4a1 1 0 012 0v0a1 1 0 01-2 0v0zm4 0a1 1 0 012 0v0a1 1 0 01-2 0v0zM7 10a1 1 0 012 0v0a1 1 0 01-2 0v0zm4 0a1 1 0 012 0v0a1 1 0 01-2 0v0zM7 16a1 1 0 012 0v0a1 1 0 01-2 0v0zm4 0a1 1 0 012 0v0a1 1 0 01-2 0v0z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                    </div> --}}

                    {{-- Main button link with icon and label --}}
                    <a href="{{ $href }}" class="col-span-3"
                        @if ($onclick) @click.prevent="{{ $onclick }}" @endif
                        @if ($target) target="{{ $target }}" @endif>
                        <div class="flex min-w-0 gap-x-4 items-center">
                            @php
                                $iconType = $button['type'];
                                $iconBg = 'bg-red-500';

                                $iconMap = [
                                    'email' => 'bg-blue-500',
                                    'phone' => 'bg-yellow-500',
                                    'sms' => 'bg-indigo-500',
                                    'venmo' => 'bg-[#008CFF]',
                                    'credit' => 'bg-[#000000]',
                                    'telegram' => 'bg-[#24A1DE]',
                                    'whatsapp' => 'bg-[#25D366]',
                                    'zalo' => 'bg-[#2196f3]',
                                    'wechat' => 'bg-[#7BC142]',
                                    'zoom' => 'bg-[#2d8cff]',
                                    'apple_pay' => 'bg-[#A2AAAD]',
                                    'zelle' => 'bg-[#6534D1]',
                                    'cashapp' => 'bg-[#00CF31]',
                                    'paypal_email' => 'bg-[#253B80]',
                                    'paypal_link' => 'bg-[#253B80]',
                                    'chime' => 'bg-[#1EC677]',
                                    'square' => 'bg-white',
                                    'zoom_replay' => 'bg-[#2d8cff]',
                                    'amazon_shop' => 'bg-[#FF9900]',
                                ];

                                if (isset($iconMap[$iconType])) {
                                    $iconBg = $iconMap[$iconType];
                                }
                            @endphp

                            <span
                                class="rounded-full @if ($iconType == 'chime') text-white px-2 pt-2 pb-0.5 @elseif($iconType == 'square') text-black p-2  @else p-2 text-white @endif  {{ $iconBg }}">
                                @switch($iconType)
                                    @case('vcf')
                                        <x-heroicon-s-arrow-down-tray class="size-5" />
                                    @break

                                    @case('form')
                                        <x-heroicon-s-pencil-square class="size-5" />
                                    @break

                                    @case('help')
                                    @case('exchange')
                                        <x-fas-handshake class="size-5" />
                                    @break

                                    @case('podcast')
                                        {{-- <x-fas-handshake class="size-5" /> --}}
                                        <x-heroicon-s-microphone class="size-5" />
                                    @break

                                    @case('feedback')
                                        <x-ri-feedback-fill class="size-5" />
                                    @break

                                    @case('bio')
                                        <x-heroicon-s-user class="size-5" />
                                    @break

                                    @case('shop')
                                        <x-heroicon-s-shopping-bag class="size-5" />
                                    @break

                                    @case('services')
                                        <x-heroicon-s-briefcase class="size-5" />
                                    @break

                                    @case('events')
                                        <x-heroicon-s-calendar-days class="size-5" />
                                    @break

                                    {{-- @case('sales')
                                        <x-heroicon-s-shopping-bag class="size-5" />
                                    @break --}}
                                    @case('team')
                                        <x-heroicon-s-users class="size-5" />
                                    @break

                                    @case('square')
                                        <x-si-square class="size-5" />
                                    @break

                                    @case('driving')
                                        <x-fas-map-location-dot class="size-5" />
                                    @break

                                    @case('zoom_replay')
                                        <x-bxl-zoom class="size-5" />
                                    @break

                                    @case('reviews')
                                        <x-heroicon-s-star class="size-5" />
                                    @break

                                    @case('trusted_network')
                                        <x-heroicon-s-users class="size-5" />
                                    @break

                                    @case('payments')
                                        <x-heroicon-s-banknotes class="size-5" />
                                    @break

                                    @case('link')
                                        <svg class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M13.213 9.787a3.391 3.391 0 0 0-4.795 0l-3.425 3.426a3.39 3.39 0 0 0 4.795 4.794l.321-.304m-.321-4.49a3.39 3.39 0 0 0 4.795 0l3.424-3.426a3.39 3.39 0 0 0-4.794-4.795l-1.028.961" />
                                        </svg>
                                    @break

                                    @case('community')
                                        <x-fas-users class="size-5" />
                                    @break

                                    @case('email')
                                        <x-heroicon-s-envelope class="size-5" />
                                    @break

                                    @case('phone')
                                        <x-heroicon-s-phone class="size-5" />
                                    @break

                                    @case('sms')
                                        <x-heroicon-s-chat-bubble-left-right class="size-5" />
                                    @break

                                    @case('venmo')
                                        <x-bxl-venmo class="size-5" />
                                    @break

                                    @case('credit')
                                        <x-heroicon-s-credit-card class="size-5" />
                                    @break

                                    @case('telegram')
                                        <x-fab-telegram class="size-5" />
                                    @break

                                    @case('whatsapp')
                                        <x-fab-whatsapp class="size-5" />
                                    @break

                                    @case('zalo')
                                        <x-si-zalo class="size-5" />
                                    @break

                                    @case('wechat')
                                        <x-ri-wechat-fill class="size-5" />
                                    @break

                                    @case('amazon_shop')
                                        <x-fab-amazon class="size-5" />
                                    @break

                                    @case('zoom')
                                        <x-bxl-zoom class="size-5" />
                                    @break

                                    @case('apple_pay')
                                        <x-fab-apple class="size-5" />
                                    @break

                                    @case('zelle')
                                        <x-si-zelle class="size-5" />
                                    @break

                                    @case('payment_other')
                                        <x-fas-dollar-sign class="size-5" />
                                    @break

                                    @case('chime')
                                        <chime-icon class="size-5" />
                                    @break

                                    @case('cashapp')
                                        <x-tabler-brand-cashapp class="size-5" />
                                    @break

                                    @case('paypal_email')
                                    @case('paypal_link')
                                        <x-fab-paypal class="size-5" />
                                    @break
                                @endswitch
                            </span>

                            <div class="min-w-0 flex-auto">
                                <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">
                                    {{ \Illuminate\Support\Str::limit($button['title'], 20) }}
                                </p>
                            </div>
                        </div>
                    </a>

                    {{-- Controls --}}
                    <div class="col-span-2 flex gap-5 items-center justify-end">
                        @if ($button->type !== 'form')
                            <button wire:click="getLink({{ $button->id }})"
                                @click="editButton=!editButton;button_{{ $button->type }}=true;selected_button='{{ $button->type }}'"
                                class="flex rounded-full bg-green-500 p-1 text-white">
                                <x-heroicon-s-pencil-square class="size-4 sm:size-5" />
                            </button>
                        @endif

                        @if (
                            !in_array($button->type, [
                                'vcf',
                                'help',
                                'exchange',
                                'bio',
                                'shop',
                                'services',
                                'feedback',
                                'events',
                                // 'sales',
                                'team',
                                'driving',
                                'zoom_replay',
                                'reviews',
                                'trusted_network',
                                'payments',
                                'form',
                            ]))
                            <button wire:click="delete({{ $button->id }})"
                                wire:confirm="Are you sure you want to delete this link? Deleting this will also delete all the analytics associated with the link."
                                class="flex rounded-full bg-red-500 p-1 text-white">
                                <x-heroicon-s-trash class="size-4 sm:size-5" />
                            </button>
                        @endif

                        <span class="rounded-full text-gray-600">
                            <button wire:click="activate({{ $button->id }})"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $button['is_active'] ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset">
                                <span aria-hidden="true"
                                    class="size-4 {{ $button['is_active'] ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>
                </li>
            @endif
        @endforeach
    </ul>
</div>
