<div>
    <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5" x-data x-sortable
        x-on:sorted="$wire.updateOrder($event.detail)">

        @foreach ($videos as $video)
            <li class="bg-white dark:bg-zinc-900 grid grid-cols-6 items-center justify-between gap-x-6 py-3"
                x-data="{ video: {{ $video['is_active'] }} }" wire:key="{{ $video->id }}" x-sortable-item="{{ $video->id }}">
                <a href="{{ $video['link'] }}" target="_blank" class='col-span-3'>
                    <div class="flex min-w-0 gap-x-4 items-center">
                        {{-- <img src="{{ asset('/img/youtube-icon.svg') }}" class="size-10 rounded-full border-0"> --}}

                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">
                                {{ \Illuminate\Support\Str::limit($video['title'], 30) }}
                            </p>
                        </div>
                    </div>
                </a>

                {{-- Edit and Delete Button --}}
                <div class="col-span-3 flex gap-5 items-center justify-end">
                    {{-- Edit product --}}
                    <a wire:navigate href="{{ route('video.edit', $video['id']) }}"
                        class="flex rounded-full bg-green-500 p-1 text-white" role="switch" aria-checked="false"
                        aria-labelledby="switch-1-label">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-4 sm:size-5">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                        </svg>
                    </a>

                    {{-- Delete product --}}
                    <button wire:click="delete({{ $video->id }})"
                        wire:confirm="Are you sure you want to delete this video?"
                        class="flex rounded-full bg-red-500 p-1 text-white" role="switch" aria-checked="false"
                        aria-labelledby="switch-1-label">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-4 sm:size-5">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0" />
                        </svg>
                    </button>

                    <span class="rounded-full text-gray-600">
                        <!-- Enabled: "bg-indigo-600", Not Enabled: "bg-gray-200" -->
                        <button wire:click="activate({{ $video['id'] }})"
                            class="flex w-8 flex-none cursor-pointer rounded-full {{ $video['is_active'] ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                            role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                            <!-- <span class="sr-only">Agree to policies</span> -->
                            <!-- Enabled: "translate-x-3.5", Not Enabled: "translate-x-0" -->
                            <span aria-hidden="true"
                                class="size-4 {{ $video['is_active'] ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                        </button>
                    </span>
                </div>

            </li>
        @endforeach
    </ul>
</div>
