<div class="cart-wrapper" x-cloak>

    @if (isset($username))
        <livewire:payment-link-view-modal :username="$username" />
    @endif

    <div id="cart-page-sub">
        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 sm:mx-auto ml-2 mr-2 mb-20 relative">

            <div class="grid grid-cols-2 gap-4 mb-5 pt-5">
                <!-- back -->
                <div class="ml-5 flex items-center">
                    <a href="{{ route('card.products', $username) }}"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-chevron-left class="size-4" />
                    </a>
                </div>
            </div>

            <div class="p-5" wire:ignore>
                <h1 class="text-2xl font-bold mb-6 text-gray-500 dark:text-white">Your Cart</h1>

                <!-- Cart items container -->
                <div id="cart-items-sub" class="space-y-5"></div>

                <!-- Total + Checkout -->
                <div class="mt-8 text-center justify-center items-center">
                    <span class="font-bold text-xl text-gray-500 dark:text-white">
                        Total: $<span id="cart-page-total-sub">0.00</span>
                    </span>

                    {{-- Coin --}}
                    <span class="mt-2 font-semibold text-base text-yellow-600 flex items-center justify-center gap-1">
                        <span id="tier-coin"></span>
                        <x-fas-coins class="size-5" />
                    </span>

                    {{-- <button
                        class="bg-green-600 text-white font-bold px-6 py-3 rounded-lg hover:bg-green-700 transition">
                        Proceed to Payment
                    </button> --}}

                    <a id="subscription-btn"
                        class="mt-5 block p-1.5 px-5 rounded-full text-center mx-auto text-base max-w-[50%] font-semibold"
                        style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                        target="_blank">Subscribe
                    </a>
                </div>
            </div>

            {{-- @if ($payments)
                <p class="flex items-center justify-center text-center pt-5 text-gray-500 dark:text-white">
                    Payment links
                </p>

                <div
                    class="pt-2 container mx-auto flex flex-wrap items-center justify-center text-gray-500 dark:text-white">
                    @foreach ($payments as $payment)
                        @if ($payment['type'] === 'credit')
                            <a href="{{ $payment['link'] }}" target="_blank">
                                <x-heroicon-s-credit-card class="size-7 mx-2 my-2" />
                            </a>
                        @elseif ($payment['type'] === 'payment_other')
                            <a href="{{ $payment['link'] }}" target="_blank">
                                <x-fas-dollar-sign class="size-7 mx-2 my-2" />
                            </a>
                        @elseif ($payment['type'] === 'chime')
                            <a href="{{ $payment['link'] }}" target="_blank">
                                <chime-icon class="size-7 mx-2 my-2"></chime-icon>
                            </a>
                        @elseif($payment['type'] == 'zelle')
                            <button
                                @click="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{{ $payment['link'] }}'">
                                <x-si-zelle class="size-7 mx-2 my-2" />
                            </button>
                        @elseif($payment['type'] == 'apple_pay')
                            <button
                                @click="openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{{ $payment['link'] }}'">
                                <x-fab-apple class="size-7 mx-2 my-2" />
                            </button>
                        @elseif($payment['type'] == 'venmo')
                            <a href="{{ $payment['link'] }}" target="_blank">
                                <x-bxl-venmo class="size-7 mx-2 my-2" />
                            </a>
                        @elseif($payment['type'] == 'cashapp')
                            <a href="{{ $payment['link'] }}" target="_blank">
                                <x-si-cashapp class="size-7 mx-2 my-2" />
                            </a>
                        @elseif($payment['type'] == 'square')
                            <a href="{{ $payment['link'] }}" target="_blank">
                                <x-si-square class="size-7 mx-2 my-2" />
                            </a>
                        @elseif($payment['type'] == 'paypal_email')
                            <button
                                @click="openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{{ $payment['link'] }}'">
                                <x-fab-paypal class="size-7 mx-2 my-2" />
                            </button>
                        @elseif($payment['type'] == 'paypal_link')
                            <a href="{{ $payment['link'] }}" target="_blank">
                                <x-fab-paypal class="size-7 mx-2 my-2" />
                            </a>
                        @endif
                    @endforeach
                </div>

            @endif --}}

            <div class="p-5">
                <form wire:submit.prevent="checkoutForm" class="w-full text-gray-500 dark:text-white">

                    <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                        <input type="hidden" id="cartData" wire:model="cartData">

                        <div class="col-span-full">
                            <label for="receipt" class="block text-sm/6 font-medium">After Payment, Upload
                                Receipt</label>
                            <div class="mt-2">
                                <input type="file" id="receipt" wire:model="receipt"
                                    class="block w-full text-sm text-gray-900 border border-gray-300 rounded-md cursor-pointer bg-slate-100 focus:outline-none focus:ring-2 focus:ring-yellow-600 @error('receipt') border-red-600 @enderror">
                            </div>

                            @error('receipt')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <!-- Livewire upload progress -->
                            <div wire:loading wire:target="receipt" class="text-sm text-gray-500 mt-1">
                                Uploading receipt...
                            </div>
                        </div>

                        <div class="col-span-full sm:col-span-2">
                            <label for="firstname" class="block text-sm/6 font-medium">First
                                name</label>
                            <div class="mt-2">
                                <input type="text" id="firstname" wire:model="firstname"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('firstname') border border-red-600 @enderror">
                            </div>

                            @error('firstname')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full sm:col-span-2">
                            <label for="lastname" class="block text-sm/6 font-medium">Last
                                name</label>
                            <div class="mt-2">
                                <input type="text" id="lastname" wire:model="lastname"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('lastname') border border-red-600 @enderror">
                            </div>

                            @error('lastname')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">

                            <label for="phone" class="block text-sm/6 font-medium">Phone
                            </label>

                            <div class="mt-2">
                                <input type="text" id="phone" wire:model="phone"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('phone') border border-red-600 @enderror">
                            </div>

                            @error('phone')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">

                            <label for="phone" class="block text-sm/6 font-medium">Email
                            </label>

                            <div class="mt-2">
                                <input type="text" id="sender_email" wire:model="sender_email"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('sender_email') border border-red-600 @enderror">
                            </div>

                            @error('sender_email')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full" x-data="() => ({
                            maxChars: 100,
                            text: `{{ addslashes(old('special_note', $special_note ?? '')) }}`,
                            currentChar: 0,
                            updateCount() {
                                this.currentChar = this.text.length;
                            },
                            init() {
                                this.currentChar = this.text.length;
                            }
                        })">
                            <label for="special_note"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Special Notes
                            </label>
                            <div class="mt-2">
                                <textarea wire:model="special_note" rows="3" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6"
                                    placeholder="(Optional)">{{ old('special_note', $special_note) }}</textarea>
                            </div>
                            <p class="mt-3 text-sm/6 text-gray-600">
                                (<span x-text="`${currentChar}/${maxChars}`" class="text-sm/6 text-gray-600"></span>)
                            </p>

                        </div>

                        <div class="col-span-full">
                            <label class="block text-sm/6 font-medium">What’s your best way to connect?</label>
                            <div class="mt-3 space-y-2">
                                <label class="flex items-center space-x-2">
                                    <input type="radio" wire:model="preferred_contact" value="Text" checked
                                        class="h-4 w-4 text-yellow-600 focus:ring-yellow-600 border-gray-300">
                                    <span class="text-sm">Text</span>
                                </label>

                                <label class="flex items-center space-x-2">
                                    <input type="radio" wire:model="preferred_contact" value="WhatsApp"
                                        class="h-4 w-4 text-yellow-600 focus:ring-yellow-600 border-gray-300">
                                    <span class="text-sm">WhatsApp</span>
                                </label>

                                <label class="flex items-center space-x-2">
                                    <input type="radio" wire:model="preferred_contact" value="Email"
                                        class="h-4 w-4 text-yellow-600 focus:ring-yellow-600 border-gray-300">
                                    <span class="text-sm">Email</span>
                                </label>
                            </div>
                            @error('preferred_contact')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            {{-- <button type="submit"
                                class="mt-5 w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 "
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">Send</button> --}}

                            <button type="submit"
                                class="mt-5 w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                wire:loading.attr="disabled" wire:loading.class="opacity-50 cursor-not-allowed"
                                wire:target="receipt">

                                <!-- Normal text when NOT uploading -->
                                <span wire:loading.remove wire:target="receipt">
                                    Send
                                </span>

                                <!-- Uploading text while uploading -->
                                <span wire:loading wire:target="receipt">
                                    Uploading Receipt...
                                </span>
                            </button>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Empty cart -->
    <div wire:ignore id="empty-cart-sub" class="h-screen flex justify-center items-center">
        <div>
            <p class="mx-auto font-medium text-center text-xl text-gray-500 dark:text-white">No Subscriptions</p>

            <a href="{{ route('card.products', $username) }}"
                class="flex mt-5 px-4 py-3 rounded-full justify-center text-l font-bold"
                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                Shop now
            </a>
        </div>
    </div>
</div>
