<div>
    @guest
        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-40 my-5">
        @endguest
        @auth
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-40 mt-5">
            @endauth

            <!-- Product Header, Share & Back Buttons -->
            <div class="grid grid-cols-2 gap-4 mb-5">
                <div class="ml-5 flex items-center">
                    <a href="{{ route('card.products', $user->username) }}"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-chevron-left class="size-4" />
                    </a>
                </div>

                <div class="mr-5 flex items-center place-content-end" x-data="{
                    urlTitle: `{{ $product_title }} | {{ $page_title ?: $card_title }}`,
                    shareUrl: '{{ route('subscription.show', [$user->username, $id]) }}',
                    shareCard() {
                        if (navigator.share) {
                            navigator.share({ title: this.urlTitle, url: this.shareUrl })
                                .then(() => console.log('Thanks for sharing!'))
                                .catch(console.error);
                        } else {
                            console.log('Web Share API not supported');
                        }
                    }
                }">
                    <button type="button" @click="showQRCode=!showQRCode"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                        <x-heroicon-o-qr-code class="size-5" />
                    </button>

                    <a href="#" x-on:click.prevent="shareCard"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-arrow-up-tray class="size-5" />
                    </a>
                </div>
            </div>

            <!-- Product Name -->
            <h1 class="text-2xl font-medium text-center px-5">{{ $product->product_name }}</h1>

            <!-- Product Description -->
            <div class="px-5 my-10">
                <div
                    class="prose dark:prose-invert max-w-none text-black dark:text-white [&_strong]:text-black dark:[&_strong]:text-white">
                    {!! Purifier::clean($product->description) !!}
                </div>
            </div>

            <!-- Product Image -->
            <img src="{{ $product->featured_image ? asset($product->featured_image) : asset('/img/product-placeholder.jpg') }}"
                alt="{{ $product->product_name }}" class="rounded-t-md">

            <!-- Subscription Options -->
            @php
                $tiers = collect($product->subscription_options ?? [])
                    ->filter(fn($t) => isset($t['title']))
                    ->values()
                    ->toArray();
                // dd( $tiers);
                $defaultTier = $tiers[0] ?? null;
            @endphp

            <div x-cloak x-data="{
                product: @js([
    'id' => $product->id,
    'subscription' => $product->shop_online_link,
    'product_name' => $product->product_name,
    'description' => $product->description,
    'featured_image' => $product->featured_image,
    'price' => $product->price,
    'coin' => $product->coin,
]),
                tiers: @js($tiers),
                selectedTitle: @js($defaultTier['title'] ?? ''),
                get selectedTier() {
                    return this.tiers.find(t => t.title === this.selectedTitle) ?? {};
                }
            }" class="w-full p-5 space-y-4 mx-auto">

                <template x-if="tiers.length > 0">
                    <div>
                        <label class="block text-base font-medium mb-1">Select Tier</label>

                        <select x-model="selectedTitle"
                            class="p-2 block w-full rounded-md border-gray-300 shadow-sm text-black">
                            <template x-for="(tier, index) in tiers" :key="index">
                                <option :value="tier.title" x-text="tier.title"></option>
                            </template>
                        </select>


                        <!-- Selected Tier Details -->
                        <div x-show="selectedTier.title" x-transition>
                            <div class="prose dark:prose-invert mt-5" x-html="selectedTier.tier_description"></div>

                            <div class="flex justify-between items-center font-semibold mt-5">
                                <h2 class="text-xl font-medium">$<span x-text="selectedTier.price"></span></h2>

                                @if ($product->has_coins)
                                    <p class="flex items-center text-yellow-500">
                                        <span x-text="selectedTier.coin"></span>&nbsp;<x-fas-coins class="size-3" />
                                    </p>
                                @endif
                            </div>

                            <button class="block w-full text-center font-semibold py-2 mt-4 rounded transition"
                                style="background-color: {{ $color_settings_custom_button }} !important;
                color: {{ $color_settings_custom_button_text }} !important;"
                                @click="saveSubscriptionToCart({ ...selectedTier, product: product });
                        window.location.href = '{{ route('subscription.cart', ['username' => $user->username]) }}';"
                                x-text="'Subscribe to ' + selectedTier.title">
                            </button>
                        </div>
                    </div>
                </template>


                <!-- Fallback for single product without tiers -->
                <template x-if="tiers.length === 0">
                    <div>
                        <div class="flex justify-between items-center font-semibold mt-4">
                            <h2 class="text-xl font-medium">${{ $product->price }}</h2>
                            @if ($product->has_coins && $product->coin)
                                <p class="flex items-center text-yellow-500">
                                    {{ $product->coin }}&nbsp;<x-fas-coins class="size-3" />
                                </p>
                            @endif
                        </div>

                        <button class="block w-full text-center font-semibold py-2 mt-4 rounded transition"
                            style="background-color: {{ $color_settings_custom_button }} !important;
                            color: {{ $color_settings_custom_button_text }} !important;"
                            @click="saveSubscriptionToCart({ product }); window.location.href = '{{ route('subscription.cart', ['username' => $user->username]) }}';">
                            Subscribe
                        </button>
                    </div>
                </template>
            </div>

        </div>
