<div>

    <!-- Overlay (Initially hidden) -->
    {{-- <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden toggleSocialActionSheet"></div> --}}

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.profile') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900">
                        <x-bi-chevron-left class="size-4" />
                    </span>
                </a>
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold ">

                <x-heroicon-o-star class="size-6 inline-block" />

                &nbsp;&nbsp;Subscription
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>

    </div>

    <livewire:switch-card-component />

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-2 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl px-5 mb-5">

        <ul role="list">

            <!-- Card Type -->
            <li class="flex justify-between gap-x-6 sm:py-3">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                        <x-heroicon-o-user class="size-5" />
                    </span>
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Current plan</p>
                    </div>
                </div>
                <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                    <span class="rounded-full text-gray-600 p-2">
                        {{-- <x-bi-chevron-right class="size-4" /> --}}
                        <p
                            class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l">
                            @if (auth()->user()->onTrial() && !in_array($user->access, ['Month', 'Year']))
                                <span
                                    class="inline-flex items-center rounded-md bg-green-100 px-2 py-1 text-xs font-medium text-green-700 ring-1 ring-pink-700/10 ring-inset mr-2">Trial</span>
                            @endif

                            @if ($user['user_type'] === 'Free')
                                <span
                                    class="inline-flex items-center rounded-md bg-blue-100 px-2 py-1 text-xs font-medium text-blue-700 ring-1 ring-pink-700/10 ring-inset">{{ $user['user_type'] }}</span>
                            @elseif ($user['user_type'] === 'Basic')
                                <span
                                    class="inline-flex items-center rounded-md bg-pink-100 px-2 py-1 text-xs font-medium text-pink-700 ring-1 ring-pink-700/10 ring-inset">{{ $term_basic }}</span>
                            @elseif($user['user_type'] === 'Gold')
                                <span
                                    class="inline-flex items-center rounded-md bg-yellow-100 px-2 py-1 text-xs font-medium text-yellow-800 ring-1 ring-yellow-600/20 ring-inset">{{ $term_gold }}</span>
                            @elseif($user['user_type'] === 'Sponsored')
                                <span
                                    class="inline-flex items-center rounded-md bg-red-400 px-2 py-1 text-xs font-medium text-red-800 ring-1 ring-yellow-600/20 ring-inset">{{ $user['user_type'] }}</span>
                            @elseif($user['user_type'] === 'Influencer')
                                <span
                                    class="inline-flex items-center rounded-md bg-pink-400 px-2 py-1 text-xs font-medium text-pink-800 ring-1 ring-yellow-600/20 ring-inset">{{ $user['user_type'] }}</span>
                            @else
                                <span
                                    class="inline-flex items-center rounded-md bg-gray-100 px-2 py-1 text-xs font-medium text-gray-600 ring-1 ring-gray-500/10 ring-inset">{{ $term_platinum }}</span>
                            @endif
                        </p>

                    </span>
                </div>
            </li>

            @php
                $upcomingInvoice = auth()->user()->upcomingInvoice();
                $invoices = auth()->user()->invoices();
            @endphp

            {{-- if subscribed --}}
            @if (auth()->user()->subscribed())
                @if (!is_null($upcomingInvoice))

                    @if (!$manual_capture_mode)
                        <li class="flex justify-between gap-x-6 sm:py-3">
                            <div class="flex min-w-0 gap-x-4 items-center">
                                <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                                    <x-heroicon-o-calendar-days class="size-5" />
                                </span>
                                <div class="min-w-0 flex-auto">
                                    <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Renews on</p>
                                </div>
                            </div>
                            <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                                <span class="rounded-full text-gray-600 p-2">
                                    {{-- <x-bi-chevron-right class="size-4" /> --}}
                                    <p
                                        class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-right text-sm/6">
                                        {{ $upcomingInvoice->date()->format('M d, Y') }}
                                        <br>({{ $upcomingInvoice->date()->diffForHumans() }})
                                    </p>

                                </span>
                            </div>
                        </li>
                    @endif

                    @if (!$manual_capture_mode)
                        <li class="flex justify-between gap-x-6 sm:py-3">
                            <div class="flex min-w-0 gap-x-4 items-center">
                                <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                                    <x-heroicon-o-currency-dollar class="size-5" />
                                </span>
                                <div class="min-w-0 flex-auto">
                                    <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Upcoming total
                                    </p>
                                </div>
                            </div>
                            <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                                <span class="rounded-full text-gray-600 p-2">
                                    <p
                                        class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-right text-sm/6">
                                        {{ $upcomingInvoice->total() }}
                                    </p>

                                </span>
                            </div>
                        </li>
                    @endif
                @else
                    <li class="flex justify-between gap-x-6 sm:py-3">
                        <div class="flex min-w-0 gap-x-4 items-center">
                            <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                                <x-heroicon-o-calendar-days class="size-5" />
                            </span>
                            <div class="min-w-0 flex-auto">
                                <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Deactivates at
                                </p>
                            </div>
                        </div>
                        <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                            <span class="rounded-full text-gray-600 p-2">
                                {{-- <x-bi-chevron-right class="size-4" /> --}}
                                <p
                                    class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-right text-sm/6">
                                    {{ auth()->user()->subscription()->ends_at->format('M d, Y') }}
                                </p>

                            </span>
                        </div>
                    </li>
                @endif
            @endif

            {{-- Trial Ends --}}
            @if (auth()->user()->onTrial() && !in_array($user->access, ['Month', 'Year']))
                <li class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-calendar-days class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Trial ends at
                            </p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        <span class="rounded-full text-gray-600 p-2">
                            {{-- <x-bi-chevron-right class="size-4" /> --}}
                            <p
                                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-right text-sm/6">
                                {{ auth()->user()->trialEndsAt()->format('M d, Y') }}
                                <br>({{ auth()->user()->trialEndsAt()->diffForHumans() }})
                            </p>

                        </span>
                    </div>
                </li>
            @endif
        </ul>

        @auth
            <div class="flex items-center justify-end gap-x-6 gap-4 py-5">
                @if (auth()->user()->subscribed() && !$manual_capture_mode)
                    <a href="{{ route('subscription.portal') }}"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 flex">
                        Manage Subscription
                    </a>
                @endif

                @if ($user['user_type'] != 'Platinum' && $platinum_enabled === true)
                    <a href="{{ route('upgrade.index') }}"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 flex">
                        Manage Subscription
                    </a>
                @endif
            </div>
        @endauth
    </div>

    @if (auth()->user()->subscribed() && !$manual_capture_mode)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-2 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl px-5 mb-5">
            <ul role="list">

                <li class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-cog-6-tooth class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Action</p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        {{-- @if (auth()->user()->subscription('default')->onTrial())
                            <form action="{{ route('trial.end') }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="rounded-md px-3 py-2 text-sm font-semibold text-white shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b bg-red-500 hover:from-red-500 hover:to-red-700 flex">
                                    End trial
                                </button>
                            </form>
                        @elseif (auth()->user()->subscription()->canceled())
                            <form action="{{ route('subscription.resume') }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 flex">
                                    Resume subscription
                                </button>
                            </form>
                        @else
                            <form action="{{ route('subscription.cancel') }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="rounded-md px-3 py-2 text-sm font-semibold text-white shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b bg-red-500 hover:from-red-500 hover:to-red-700 flex">
                                    Cancel subscription
                                </button>
                            </form>
                        @endif --}}

                        @if (auth()->user()->subscription()->canceled())
                            <form action="{{ route('subscription.resume') }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-green-400 to-green-400 hover:from-green-400 hover:to-green-700 flex">
                                    Resume subscription
                                </button>
                            </form>
                        @else
                            <form action="{{ route('subscription.cancel') }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="rounded-md px-3 py-2 text-sm font-semibold text-white shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b bg-red-500 hover:from-red-500 hover:to-red-700 flex">
                                    Cancel subscription
                                </button>
                            </form>
                        @endif
                    </div>
                </li>
            </ul>
        </div>
    @endif

    {{-- Invoices --}}
    @if (auth()->user()->subscribed() && !$manual_capture_mode)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-2 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl px-5 mb-20">
            <ul role="list">

                <li class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-banknotes class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Invoices</p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">

                    </div>
                </li>

                @foreach ($invoices as $invoice)
                    <li class="flex justify-between gap-x-6 sm:py-3">
                        <div class="flex min-w-0 gap-x-4 items-center">
                            <p class="text-sm/6 text-gray-900 dark:text-slate-300">
                                {{ $invoice->date()->format('M d, Y') }} - {{ $invoice->total() }}
                            </p>
                        </div>
                        <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                            <a href="{{ route('subscription.invoice', ['invoice' => $invoice->id]) }}"
                                class="text-sm/6 text-yellow-600">
                                Download
                            </a>
                        </div>
                    </li>
                @endforeach
            </ul>
        </div>
    @endif


</div>
