<!-- Upload Profile Pic Modal  -->
<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 bg-white dark:bg-zinc-900 shadow-lg transform translate-y-full transition-transform duration-300 rounded-t-2xl"
    :class="{ 'translate-y-full': !openEventUploadModal, 'translate-y-0': openEventUploadModal }" x-data="{
        saving: false,
        cropperReady: false,
        uploading: false,
        uploadError: false,
        progress: 0,
        startUploading: false,
        showImage: true,
        finishUploading: false,
        displayCropButton: false,
        finishCropping: false,
        showPreview: false,
        dontShowPreview: false,
        imageURL: '',
        cropper: null,
        cropRegion: null,

        resetUploader() {
            this.showImage = false;
            this.finishCropping = false;
            this.cropperReady = false;
            this.uploading = false;
            this.uploadError = false;
            this.progress = 0;
            this.startUploading = false;
            this.finishUploading = false;
            this.displayCropButton = false;
            this.finishCropping = false;
            this.showPreview = false;
            this.dontShowPreview = false;
            this.imageURL = '';
            this.cropRegion = null;

            if (this.cropper) {
                this.cropper.destroy();
                this.cropper = null;
            }

            this.$refs.profile_pic.value = null; // Reset file input
        },

        handleFileChange(event) {

            this.finishCropping = false;
            this.showPreview = false;
            this.dontShowPreview = false;
            this.displayCropButton = false;
            this.imageURL = '';

            const file = event.target.files[0];
            if (!file) return;

            // Check if it's an accepted image type
            const validTypes = [
                'image/jpeg',
                'image/png',
                'image/jpg',
                'image/webp',
                'image/heic',
                'image/heif'
            ];
            if (!validTypes.includes(file.type)) {
                console.error('Invalid file type. Please select a valid image.');
                this.uploadError = true;
                this.uploading = false;
                this.startUploading = false;
                return;
            }

            // Check if the file is HEIC/HEIF
            if (file.type === 'image/heic' || file.type === 'image/heif') {
                const reader = new FileReader();
                reader.readAsArrayBuffer(file);

                reader.onload = async () => {
                    const buffer = reader.result;
                    try {
                        // Use heic2any to convert HEIC/HEIF to a JPEG blob
                        const convertedBlob = await heic2any({ blob: new Blob([buffer]), toType: 'image/jpeg' });

                        // Create a JPEG file
                        const jpegFile = new File([convertedBlob], 'converted.jpg', { type: 'image/jpeg' });

                        // Proceed with uploading the converted JPEG file
                        const readerJpeg = new FileReader();
                        readerJpeg.readAsDataURL(jpegFile);

                        readerJpeg.onload = () => {
                            const img = new Image();
                            img.src = readerJpeg.result;

                            img.onload = async () => {
                                const canvas = document.createElement('canvas');
                                canvas.width = img.width;
                                canvas.height = img.height;

                                const ctx = canvas.getContext('2d');
                                ctx.drawImage(img, 0, 0);

                                // Get original file size
                                console.log('Original file size:', (file.size / 1024 / 1024).toFixed(2), 'MB');

                                let jpegDataUrl;

                                // If file > 2MB, compress more
                                if (file.size > 2 * 1024 * 1024) {
                                    jpegDataUrl = canvas.toDataURL('image/jpeg', 0.6); // Compress harder (quality 0.6)
                                } else {
                                    jpegDataUrl = canvas.toDataURL('image/jpeg', 0.9); // Normal compression (quality 0.9)
                                }
                                // Convert to JPEG
                                {{-- const jpegDataUrl = canvas.toDataURL('image/jpeg', 0.9); --}}
                                const blob = await (await fetch(jpegDataUrl)).blob();
                                const jpegFileForUpload = new File([blob], 'converted.jpg', { type: 'image/jpeg' });

                                // Log compressed size
                                console.log('Compressed file size:', (jpegFileForUpload.size / 1024 / 1024).toFixed(2), 'MB');

                                // Upload the JPEG file manually using Livewire
                                @this.upload('image', jpegFileForUpload, () => {
                                    {{-- console.log('Upload finished'); --}}
                                    this.uploading = false;
                                    this.uploadError = false;
                                    this.finishUploading = true;
                                    this.displayCropButton = true;
                                    this.startUploading = true;
                                }, (error) => {
                                    console.error('Upload error', error);
                                    this.uploading = false;
                                    this.uploadError = true;
                                }, (event) => {
                                    {{-- console.log('Upload progress event:', event); --}}
                                    this.uploading = true;
                                    this.progress = event.detail.progress ?? 0;
                                });
                            };
                        };
                    } catch (error) {
                        console.error('Error converting HEIC/HEIF file', error);
                    }
                };
            } else {
                // Handle regular image files (non-HEIC/HEIF)
                const reader = new FileReader();
                reader.readAsDataURL(file);

                reader.onload = async () => {
                    const img = new Image();
                    img.src = reader.result;

                    img.onload = async () => {
                        const canvas = document.createElement('canvas');
                        canvas.width = img.width;
                        canvas.height = img.height;

                        const ctx = canvas.getContext('2d');
                        ctx.drawImage(img, 0, 0);

                        // Get original file size
                        console.log('Original file size:', (file.size / 1024 / 1024).toFixed(2), 'MB');

                        let jpegDataUrl;

                        // If file > 2MB, compress more
                        if (file.size > 2 * 1024 * 1024) {
                            jpegDataUrl = canvas.toDataURL('image/jpeg', 0.6); // Compress harder (quality 0.6)
                        } else {
                            jpegDataUrl = canvas.toDataURL('image/jpeg', 0.9); // Normal compression (quality 0.9)
                        }
                        // Convert to JPEG
                        {{-- const jpegDataUrl = canvas.toDataURL('image/jpeg', 0.9); --}}
                        const blob = await (await fetch(jpegDataUrl)).blob();
                        const jpegFile = new File([blob], 'converted.jpg', { type: 'image/jpeg' });

                        // Log compressed size
                        console.log('Compressed file size:', (jpegFile.size / 1024 / 1024).toFixed(2), 'MB');

                        // Upload the JPEG file manually using Livewire
                        @this.upload('image', jpegFile, () => {
                            {{-- console.log('Upload finished'); --}}
                            this.uploading = false;
                            this.uploadError = false;
                            this.finishUploading = true;
                            this.displayCropButton = true;
                            this.startUploading = true;
                        }, (error) => {
                            console.error('Upload error', error);
                            this.uploading = false;
                            this.uploadError = true;
                        }, (event) => {
                            {{-- console.log('Upload progress event:', event); --}}
                            this.uploading = true;
                            this.progress = event.detail.progress ?? 0;
                        });
                    };
                };
            }
        },

        dispatchCroppedImage() {
            this.finishCropping = true;
            this.dontShowPreview = true;

            this.cropper.disable();
            this.displayCropButton = false;

            const jpegBlob = this.cropper.getCroppedCanvas().toDataURL('image/jpeg', 0.9);
            this.imageURL = jpegBlob;

            @this.handleCroppedImage(jpegBlob, this.cropRegion, this.cropper.getCanvasData());

            setTimeout(() => {
                this.showPreview = true;
                this.dontShowPreview = false;
                this.cropper.destroy();
            }, 2000);
        }
    }"
    x-on:livewire-upload-start="uploading=true;uploadError=false;startUploading=true"
    x-on:livewire-upload-finish="uploading=false;uploadError=false;finishUploading=true;displayCropButton=true;"
    x-on:livewire-upload-error="uploading=false; uploadError=true;console.log($event.detail.error)"
    x-on:livewire-upload-progress="progress=$event.detail.progress"
    x-effect="if (finishUploading) {
    $nextTick(() => {
        cropper = new Cropper($refs.image, {
            {{-- aspectRatio: 1, --}}
            viewMode: 1,
            dragMode: 'move',
            autoCropArea: 1,
            cropBoxMovable: false,
            cropBoxResizable: false,
            center: true,
            movable: true,
            scalable: true,
            zoomable: true,
            zoomOnTouch: true,
            checkOrientation: false,
            crop(e) {
                cropRegion = {
                    x: e.detail.x,
                    y: e.detail.y,
                    width: e.detail.width,
                    height: e.detail.height,
                }
            },
            zoom(e){
                cropRegion = {
                    x: e.detail.x,
                    y: e.detail.y,
                    width: e.detail.width,
                    height: e.detail.height,
                }
            }
        })
    });
}">

    <div class="p-4">
        <div class="flex justify-between items-center">
            <h3 class="text-lg font-bold text-slate-800 dark:text-slate-300 flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="m2.25 15.75 5.159-5.159a2.25 2.25 0 0 1 3.182 0l5.159 5.159m-1.5-1.5 1.409-1.409a2.25 2.25 0 0 1 3.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 0 0 1.5-1.5V6a1.5 1.5 0 0 0-1.5-1.5H3.75A1.5 1.5 0 0 0 2.25 6v12a1.5 1.5 0 0 0 1.5 1.5Zm10.5-11.25h.008v.008h-.008V8.25Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" />
                </svg>
                &nbsp;&nbsp;
                Upload Image
            </h3>
            <!-- Close Action Sheet -->
            <button @click="openEventUploadModal=!openEventUploadModal" class="text-gray-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>

        <div class="mt-4 space-y-3">
            <div class="pt-5 px-10">

                {{-- <form wire:submit.prevent="updateProfile"> --}}
                <form>
                    <div @click="$refs.profile_pic.click()" x-show="!startUploading && !uploading" x-cloak
                        class="flex flex-col justify-center items-center text-slate-800 dark:text-slate-300">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-16 text-lg font-bold">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                        </svg>
                        <p class="text-sm mt-5">Tap to Select Image</p>
                    </div>

                    {{-- <input type="file" x-ref="profile_pic" name="profile_pic" id="profile_pic" wire:model="image"
                        accept="image/*" class="hidden" /> --}}

                    <input type="file" x-ref="profile_pic" name="profile_pic" accept="image/*" class="hidden"
                        @change="handleFileChange($event)" />

                    <div x-show="uploading" x-cloak>
                        <progress max="100" x-bind:value="progress" class="mt-10 w-full"></progress>
                        <p class="text-center text-slate-600 mb-3 dark:text-slate-500 font-medium text-sm">
                            Uploading. Please wait...
                        </p>
                    </div>

                    <div x-show="uploadError" x-cloak>
                        {{-- <p class="text-center text-slate-600 mb-3 dark:text-slate-500 font-medium text-sm"> --}}
                        <p class="text-center text-red-600 mb-3 font-medium text-sm">
                            Error uploading image! The file must be an image (jpeg, png, jpg, heif or webp) and
                            not exceeding 5mb.
                        </p>
                    </div>

                    {{-- <div class="my-5 space-y-3">
                        <img src="{{ $temporaryUrl }}" x-ref="image" class="w-64" x-show="!finishCropping" x-cloak />
                        <div x-show="showPreview" x-cloak>
                            <img src="{{ $croppedBlob ? $croppedBlob : ($image ? $image->temporaryUrl() : '') }}"
                                class="rounded-full w-10/12 mx-auto border-2 border-yellow-600 p-2 z-10 static">
                        </div>
                        <div x-show="dontShowPreview" x-cloak>
                            <p class="text-center text-slate-600 mb-3 dark:text-slate-500 font-medium text-sm">
                                Loading. Please wait...
                            </p>
                        </div>
                    </div> --}}

                    <div class="my-5 space-y-3">
                        <!-- Only show this before cropping -->
                        {{-- <img src="{{ $temporaryUrl }}" x-ref="image" class="w-64" x-show="!finishCropping" x-cloak /> --}}
                        <img src="{{ $temporaryUrl }}" x-ref="image" class="w-64"
                            x-show="!finishCropping && showImage" x-cloak />

                        <!-- Show cropped image after Crop button is clicked -->
                        <div x-show="finishCropping && showPreview" x-cloak>
                            <img :src="imageURL"
                                class="w-full mx-auto border-2 border-yellow-600 p-2 z-10 static" />
                        </div>

                        <!-- Loading state between crop and preview -->
                        <div x-show="dontShowPreview" x-cloak>
                            <p class="text-center text-slate-600 mb-3 dark:text-slate-500 font-medium text-sm">
                                Loading. Please wait...
                            </p>
                        </div>
                    </div>

                    <div class="mt-5 flex gap-x-3">
                        {{-- <button @click.prevent="resetUploader();openEventUploadModal=!openEventUploadModal"
                            class="mt-2 flex w-full justify-center rounded-md px-3 py-1.5 text-sm/6 font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 focus-visible:outline-yellow-600"
                            x-show="showPreview" x-cloak>Save</button> --}}

                        <!-- Save button -->
                        <button type="button"
                            class="flex-1 flex justify-center items-center rounded-md py-1.5 font-semibold text-black shadow-xs
               focus-visible:outline-2 focus-visible:outline-offset-2
               bg-gradient-to-b from-yellow-400 to-yellow-400
               hover:from-yellow-400 hover:to-yellow-700
               focus-visible:outline-yellow-600
               disabled:opacity-70 disabled:cursor-not-allowed"
                            x-show="showPreview" x-cloak :disabled="saving"
                            @click.prevent="
            saving = true;

            const imageSize = {
    naturalWidth: $refs.image.naturalWidth,
    naturalHeight: $refs.image.naturalHeight,
};

           $wire.call('handleCroppedImage', imageURL, cropRegion, imageSize)
    .then(() => {
        saving = false;
        resetUploader();
        openEventUploadModal = false;
    })
    .catch(() => saving = false);

        ">

                            <!-- Show normal Save text -->
                            <template x-if="!saving">
                                <span>Save</span>
                            </template>

                            <!-- Show spinner when saving -->
                            <template x-if="saving">
                                <span class="flex items-center gap-2">
                                    <svg class="animate-spin h-4 w-4 text-black" xmlns="http://www.w3.org/2000/svg"
                                        fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10"
                                            stroke="currentColor" stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor"
                                            d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                                    </svg>
                                    Saving...
                                </span>
                            </template>
                        </button>

                        <button type="button" @click="dispatchCroppedImage"
                            class="flex-1 py-1.5 rounded-md font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 focus-visible:outline-yellow-600"
                            x-show="displayCropButton" x-cloak>Save</button>

                        {{-- <button type="button" @click="openEventUploadModal=!openEventUploadModal"
                        class="w-full px-4 py-2 text-red-600 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 text-center">Cancel</button> --}}

                        <button type="button" @click="resetUploader();openEventUploadModal=false"
                            class="flex-1 py-1.5 text-red-600 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 text-center">
                            Cancel
                        </button>
                    </div>

                </form>

            </div>

        </div>
    </div>
</div>
