<div class="w-full relative mx-auto px-5 mt-10" style="z-index: 60; position: relative;" x-data="initSwiper()">
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.swiper-slide').forEach((slide) => {
                const iframe = slide.querySelector('iframe');
                const playButton = slide.querySelector('.play-button');
                const thumbnailOverlay = slide.querySelector('.thumbnail-overlay');

                playButton.addEventListener('click', () => {
                    const root = document.querySelector('[x-data]')?.__x?.$data;
                    if (root && root._stopAutoplayNow) {
                        root._stopAutoplayNow();
                        root.videoIsPlaying = true; // stop autoplay and mark playing immediately
                        root.userPausedByInteraction = true;
                    }

                    if (iframe.src.includes('youtube')) {
                        iframe.contentWindow.postMessage(JSON.stringify({
                            event: 'command',
                            func: 'playVideo',
                            args: []
                        }), '*');
                    } else if (iframe.src.includes('vimeo')) {
                        const player = new Vimeo.Player(iframe);
                        player.play();
                    }

                    // Hide the thumbnail overlay after clicking the play button
                    thumbnailOverlay.style.display = 'none';
                });

            });
        });

        function initSwiper() {
            return {
                swiper: null,
                videoIsPlaying: false,
                userPausedByInteraction: false,
                ytPlayers: [],
                autoplayDelay: 5000,
                _autoplayTimer: null,
                _resumeTimer: null,

                _pauseAutoplayFor(ms = 5000) {
                    this._stopAutoplayNow();
                    this.userPausedByInteraction = true;

                    if (this._resumeTimer) clearTimeout(this._resumeTimer);

                    this._resumeTimer = setTimeout(() => {
                        this.userPausedByInteraction = false;
                        this._scheduleAutoplay();
                    }, ms);
                },

                _stopAutoplayNow() {
                    if (this._autoplayTimer) {
                        clearTimeout(this._autoplayTimer);
                        this._autoplayTimer = null;
                    }
                },

                _scheduleAutoplay() {
                    this._stopAutoplayNow();
                    if (this.videoIsPlaying || this.userPausedByInteraction) return;

                    this._autoplayTimer = setTimeout(() => {
                        if (!this.videoIsPlaying && !this.userPausedByInteraction && this.swiper) {
                            try {
                                this.swiper.slideNext();
                            } catch {}
                        }
                        this._scheduleAutoplay();
                    }, this.autoplayDelay);
                },

                pauseAllVideos() {
                    // HTML5
                    document.querySelectorAll('.default-carousel video').forEach(v => {
                        try {
                            v.pause();
                        } catch {}
                    });

                    // Vimeo
                    if (typeof Vimeo !== 'undefined') {
                        document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                            try {
                                new Vimeo.Player(iframe).pause();
                            } catch {}
                        });
                    }

                    // YouTube
                    this.ytPlayers.forEach(player => {
                        if (player && typeof player.pauseVideo === 'function') player.pauseVideo();
                    });
                },

                initYouTubePlayers() {
                    this.ytPlayers = [];
                    const self = this;

                    document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach((iframe, index) => {
                        try {
                            const player = new YT.Player(iframe, {
                                events: {
                                    onReady: (e) => {
                                        self.ytPlayers[index] = e.target;
                                    },
                                    onStateChange: (e) => {
                                        if ([YT.PlayerState.PLAYING, YT.PlayerState.BUFFERING].includes(
                                                e.data)) {
                                            self.videoIsPlaying = true;
                                            self.userPausedByInteraction = true;
                                            self._stopAutoplayNow();
                                        } else if (e.data === YT.PlayerState.PAUSED) {
                                            self.videoIsPlaying = false;
                                            self.userPausedByInteraction = false;
                                            self._scheduleAutoplay();
                                        } else if (e.data === YT.PlayerState.ENDED) {
                                            self.videoIsPlaying = false;
                                            self.userPausedByInteraction = false;
                                            try {
                                                self.swiper.slideNext();
                                            } catch {}
                                            self._scheduleAutoplay();
                                        }
                                    }
                                }
                            });
                        } catch (err) {
                            console.warn('YT Player init error', err);
                        }
                    });
                },

                init() {
                    const self = this;
                    const container = document.querySelector('.default-carousel');
                    if (!container) return console.warn('initSwiper: .default-carousel not found');

                    const slides = container.querySelectorAll('.swiper-slide').length;
                    const isLoop = slides > 1;

                    // HTML5 Video listeners
                    document.querySelectorAll('.default-carousel video').forEach(video => {
                        video.addEventListener('play', () => {
                            self.videoIsPlaying = true;
                            self.userPausedByInteraction = true;
                            self._stopAutoplayNow();
                        }, {
                            passive: true
                        });

                        video.addEventListener('pause', () => {
                            self.videoIsPlaying = false;
                            self.userPausedByInteraction = false;
                            self._scheduleAutoplay();
                        }, {
                            passive: true
                        });

                        video.addEventListener('ended', () => {
                            self.videoIsPlaying = false;
                            self.userPausedByInteraction = false;
                            try {
                                self.swiper.slideNext();
                            } catch {}
                            self._scheduleAutoplay();
                        }, {
                            passive: true
                        });
                    });

                    // Vimeo listeners
                    if (typeof Vimeo !== 'undefined') {
                        document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                            try {
                                const player = new Vimeo.Player(iframe);
                                player.on('play', () => {
                                    self.videoIsPlaying = true;
                                    self.userPausedByInteraction = true;
                                    self._stopAutoplayNow();
                                });
                                player.on('pause', () => {
                                    self.videoIsPlaying = false;
                                    self.userPausedByInteraction = false;
                                    self._scheduleAutoplay();
                                });
                                player.on('ended', () => {
                                    self.videoIsPlaying = false;
                                    self.userPausedByInteraction = false;
                                    try {
                                        self.swiper.slideNext();
                                    } catch {};
                                    self._scheduleAutoplay();
                                });
                            } catch {}
                        });
                    }

                    // Enable enablejsapi=1 for YouTube
                    document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                        try {
                            const src = iframe.getAttribute('src') || '';
                            if (!/enablejsapi=1/.test(src)) iframe.setAttribute('src', src + (src.includes('?') ?
                                '&' : '?') + 'enablejsapi=1');
                        } catch {}
                    });

                    if (window.YT && YT.Player) self.initYouTubePlayers();
                    else window.onYouTubeIframeAPIReady = () => self.initYouTubePlayers();

                    // Swiper init
                    this.swiper = new Swiper('.default-carousel', {
                        loop: isLoop,
                        pagination: {
                            el: '.swiper-pagination',
                            clickable: true
                        },
                        on: {
                            slideChange() {
                                self.pauseAllVideos();
                                self._stopAutoplayNow();
                                if (!self.userPausedByInteraction && !self.videoIsPlaying) self._scheduleAutoplay();
                            }
                        }
                    });

                    // Pagination click
                    const paginationEl = this.swiper.pagination.el;
                    paginationEl.addEventListener('click', (e) => {
                        if (!e.target.closest('.swiper-pagination-bullet')) return;
                        self._pauseAutoplayFor(5000);
                    }, {
                        passive: true
                    });

                    this._scheduleAutoplay();
                }
            };
        }
    </script>

    <script src="https://www.youtube.com/iframe_api"></script>
    <script src="https://player.vimeo.com/api/player.js"></script>

    <div class="swiper default-carousel mb-5" x-init="init()">
        <div class="swiper-wrapper {{ $video_count > 1 ? 'mb-12' : 'mb-5' }}">
            @foreach ($videos as $index => $video)
                @php
                    $videoUrl = $video['link'];
                    $videoId = null;
                    $videoHash = null;
                    $isVimeo = false;

                    if (
                        preg_match(
                            '#(?:https?://)?(?:www\.)?youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#',
                            $videoUrl,
                            $matches,
                        )
                    ) {
                        $videoId = $matches[1];
                    } elseif (
                        preg_match(
                            '#(?:https?://)?(?:www\.)?youtube\.com/shorts/([a-zA-Z0-9_-]{11})#',
                            $videoUrl,
                            $matches,
                        )
                    ) {
                        $videoId = $matches[1];
                    } elseif (preg_match('#(?:https?://)?(?:www\.)?youtu\.be/([a-zA-Z0-9_-]+)#', $videoUrl, $matches)) {
                        $videoId = $matches[1];
                    } elseif (
                        preg_match('#(?:https?://)?(?:www\.)?m\.youtube\.com/v/([a-zA-Z0-9_-]+)#', $videoUrl, $matches)
                    ) {
                        $videoId = $matches[1];
                    } elseif (
                        preg_match(
                            '#(?:https?://)?(?:www\.|player\.)?vimeo\.com/(?:video/)?(\d+)(?:/(?:[a-zA-Z0-9]+)|\?h=([a-zA-Z0-9]+))?#',
                            $videoUrl,
                            $matches,
                        )
                    ) {
                        $videoId = $matches[1];
                        // check if hash is in path or query
                        if (isset($matches[2]) && $matches[2]) {
                            $videoHash = $matches[2];
                        } elseif (preg_match('#vimeo\.com/\d+/([a-zA-Z0-9]+)#', $videoUrl, $hashMatches)) {
                            $videoHash = $hashMatches[1];
                        } else {
                            $videoHash = null;
                        }
                        $isVimeo = true;
                    }
                @endphp

                <div class="swiper-slide w-full rounded-xl" data-slide-index="{{ $index }}">
                    <div class="rounded-xl"
                        style="position: relative; width: 100%; height: 0; padding-bottom: 56.25%; border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
                        @if ($isVimeo)
                            <iframe id="vimeo-player-{{ $index }}" class="absolute w-full h-full rounded-xl"
                                src="https://player.vimeo.com/video/{{ $videoId }}{{ $videoHash ? '?h=' . $videoHash : '' }}"
                                title="{{ $video['title'] }}" frameborder="0"
                                allow="autoplay; fullscreen; picture-in-picture" allowfullscreen>
                            </iframe>
                        @else
                            <iframe id="youtube-player-{{ $index }}" class="absolute w-full h-full rounded-xl"
                                src="https://www.youtube.com/embed/{{ $videoId }}?enablejsapi=1"
                                title="{{ $video['title'] }}" frameborder="0"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                referrerpolicy="strict-origin-when-cross-origin" allowfullscreen>
                            </iframe>
                        @endif

                        <!-- Custom thumbnail overlay -->
                        <div class="absolute w-full h-full rounded-xl thumbnail-overlay"
                            style="background-image: url('{{ $video->thumbnail }}'); background-size: cover; background-position: center; z-index: 1;">
                            <!-- Play button or other overlay content -->
                            <div class="absolute w-full h-full flex justify-center items-center play-button-container">
                                <svg width="60" height="60" viewBox="0 0 60 60" fill="none"
                                    xmlns="http://www.w3.org/2000/svg" class="play-button">
                                    <circle cx="30" cy="30" r="30" fill="#fff" />
                                    <path d="M25 20L40 30L25 40V20Z" fill="#333" />
                                </svg>
                            </div>
                        </div>
                    </div>

                    @if ($video->button_link)
                        <div class="flex justify-center">
                            <a href="{{ $video->button_link }}" target="_blank"
                                class="inline-flex my-5 px-4 py-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif text-center text-l font-bold items-center justify-center max-w-[83.333333%]"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                {{ $video->button_title ? $video->button_title : 'Click here' }}
                            </a>
                        </div>
                    @endif
                </div>
            @endforeach

        </div>

        <div class="swiper-pagination z-50"></div>
    </div>

</div>
