<div class="m-0 p-0">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">

        <div class="grid grid-cols-5 gap-4">
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('form.edit', $contact_info->form_id) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                &nbsp;&nbsp;{{ $form_info->title }}
            </p>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl py-5 mt-5 mb-20">

        {{-- Display Full Name --}}
        <h1
            class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center text-slate-800 dark:text-slate-300 mt-5">
            {{ $contact_info['firstname'] . ' ' . $contact_info['lastname'] }}&nbsp;

        </h1>

        @if ($contact_info['created_at'])
            <p class="mx-auto text-slate-800 dark:text-slate-300 text-center text-l py-1 mt-5">
                Submitted: {{ $contact_info['created_at'] }}
            </p>
        @endif

        {{-- @if ($contact_info['phone'])
            <p class="mx-auto text-slate-800 dark:text-slate-300 text-center text-l py-1">
                Phone: {{ $contact_info['phone'] }}
            </p>
        @endif --}}

        @if ($contact_info['referrer'])
            <p class="mx-auto text-slate-800 dark:text-slate-300 text-center text-l py-1 mb-5">
                Referrer: {{ $contact_info['referrer'] }}
            </p>
        @endif

        <div class="items-center">

            @if ($contact_info['email'])
                <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                    href="mailto:{{ $contact_info['email'] }}" target="_blank">Personal Email</a>
            @endif

            @if ($contact_info['phone'])
                <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                    href="tel:{{ $contact_info['phone'] }}" target="_blank">Direct Call</a>

                <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                    href="sms:{{ $contact_info['phone'] }}" target="_blank">SMS/Text</a>
            @endif
        </div>
    </div>
</div>
