<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="{{ $site_name }}" />
    <meta property="og:description"
        content="{{ isset($site_desc) ? $site_desc : 'The modern approach to business cards. Leave a lasting impression on your clients with the new way to present yourself.' }}" />
    <meta property="og:image" content="{{ asset($thumbnail) }}" />
    <meta property="og:url" content="{{ $site_url }}" />
    <meta property="og:type" content="website" />

    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="{{ asset($thumbnail) }}" />
    <meta name="twitter:title" content="{{ $site_name }}" />
    <meta name="twitter:description" content="{{ isset($bio) ? $bio : '' }}" />
    <meta name="twitter:image" content="{{ asset($thumbnail) }}" />

    <link rel="icon" type="image/x-icon" href="{{ asset($thumbnail) }}">
    <meta name="description"
        content="{{ isset($site_desc) ? $site_desc : 'The modern approach to business cards. Leave a lasting impression on your clients with the new way to present yourself.' }}">
    <meta name="keywords" content="digital business card, video business card, business card">
    <meta name="robots" content="index, follow">

    <title>Login | {{ $site_name }}</title>
    @vite('resources/css/app.css')
</head>

<body class="bg-slate-200">
    {{-- <div
        class="absolute inset-0 -z-10 w-full bg-white bg-[linear-gradient(to_right,#f0f0f0_1px,transparent_1px),linear-gradient(to_bottom,#f0f0f0_1px,transparent_1px)] bg-[size:6rem_4rem]">
    </div> --}}

    <div class="flex flex-col justify-center px-6 py-12 lg:px-8">
        <div class="sm:mx-auto sm:w-full sm:max-w-sm">
            {{-- <img class="mx-auto w-sm" src="{{ asset('/img/10kcards-black-logo.webp') }}" alt="Your Company"> --}}

            <img class="mx-auto w-sm" src="{{ $logo ? asset($logo) : asset('img/10kcards-black-logo.webp') }}">

            {{-- <p class="rounded-full bg-gray-300 py-1 px-2 text-[8px] text-black mx-auto w-fit mt-2">Prototype
                v0.1</p> --}}
            <h2 class="mt-10 text-center text-2xl/9 font-bold tracking-tight text-gray-900">Sign in</h2>
        </div>

        <p class="mt-10 text-center text-sm/6 text-gray-500">
            Don’t have a card?
            <a href="{{ route('register') }}" class="font-semibold"
                style="color: {{ $site_link_color }} !important;">Register
                now</a>.
        </p>

        <div class="mt-10 sm:mx-auto sm:w-full sm:max-w-sm">
            {{-- This is maintenance message --}}
            @if (session()->has('error'))
                <div class="p-4 mb-4 text-sm text-white text-center rounded bg-red-500">
                    {{ session('error') }}
                </div>
            @endif

            @if (session()->has('success'))
                <div class="p-4 mb-4 text-sm text-white text-center rounded bg-green-500">
                    {{ session('success') }}
                </div>
            @endif

            <form class="space-y-6" action="{{ route('login.authenticate') }}" method="POST">
                @csrf
                <div>
                    <label for="email" class="block text-sm/6 font-medium text-gray-900">Email address</label>
                    <div class="mt-2">
                        <input type="hidden" name="trusted-network" value="{{ request('trusted-network') }}">
                        <input type="email" name="email" id="email"
                            class="block w-full rounded-md bg-white px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 sm:text-sm/6"
                            value="{{ old('email') }}" style="border: 1px solid {{ $site_link_color }} !important;">
                    </div>
                    {{-- @error('email')
                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                    @enderror --}}
                </div>

                <div>
                    <div class="flex items-center justify-between">
                        <label for="password" class="block text-sm/6 font-medium text-gray-900">Password</label>
                        {{-- <div class="text-sm">
                            <a href="#" class="font-semibold text-indigo-600 hover:text-indigo-500">Forgot
                                password?</a>
                        </div> --}}
                    </div>
                    <div class="mt-2">
                        <input type="password" name="password" id="password"
                            class="block w-full rounded-md bg-white px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 sm:text-sm/6"
                            style="border: 1px solid {{ $site_link_color }} !important;">
                    </div>
                    {{-- @error('password')
                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                    @enderror --}}
                </div>

                <div>
                    <button type="submit"
                        class="flex w-full justify-center rounded-md px-3 py-1.5 text-sm/6 font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2"
                        style="background: {{ $site_button_color }} !important; color: {{ $site_button_text_color }} !important;">Sign
                        in</button>
                </div>

                @if ($errors->any())
                    <ul class="px-4 py-2 bg-red-300">
                        @foreach ($errors->all() as $error)
                            <p class="mt-1 text-sm/6 text-red-600">{{ $error }}</p>
                        @endforeach
                    </ul>
                @endif

            </form>

            <p class="mt-10 text-center text-sm/6 text-gray-500">
                <a href="{{ route('password.request') }}" class="font-semibold"
                    style="color: {{ $site_link_color }} !important;">Forgot your password?</a>
            </p>
        </div>
    </div>


    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script> --}}
    {{-- <script src="js/custom.js"></script> --}}

</body>

</html>
