{{-- <div wire:poll.100ms="buttonManager"> --}}
<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">

            {{-- Search button available only for Basic -> Platinum users --}}
            <div class="flex items-center col-span-1">
                {{-- @if (auth()->user()->user_type != 'Free')
                    <a href="{{ route('dashboard.search', $user['username']) }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <x-heroicon-o-magnifying-glass class="size-4" />
                    </a>
                @endif --}}

                @if ($user->user_type != 'Free')
                    <a wire:navigate href="{{ route('dashboard.links') }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                            </svg>
                        </span>
                    </a>
                @endif
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                    class="size-6 inline-block">
                    <path fill-rule="evenodd"
                        d="M19.902 4.098a3.75 3.75 0 0 0-5.304 0l-4.5 4.5a3.75 3.75 0 0 0 1.035 6.037.75.75 0 0 1-.646 1.353 5.25 5.25 0 0 1-1.449-8.45l4.5-4.5a5.25 5.25 0 1 1 7.424 7.424l-1.757 1.757a.75.75 0 1 1-1.06-1.06l1.757-1.757a3.75 3.75 0 0 0 0-5.304Zm-7.389 4.267a.75.75 0 0 1 1-.353 5.25 5.25 0 0 1 1.449 8.45l-4.5 4.5a5.25 5.25 0 1 1-7.424-7.424l1.757-1.757a.75.75 0 1 1 1.06 1.06l-1.757 1.757a3.75 3.75 0 1 0 5.304 5.304l4.5-4.5a3.75 3.75 0 0 0-1.035-6.037.75.75 0 0 1-.354-1Z"
                        clip-rule="evenodd" />
                </svg>

                &nbsp;&nbsp;Links
            </p>
            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-xs font-semibold shadow-xs flex bg-white text-black items-center">
                    View&nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>

        </div>

        @if ($buttons)
            {{-- if FREE User, can only add 4 Buttons --}}
            {{-- @php
                dd($button_count);
            @endphp --}}

            {{-- @if ($buttons && (($user_type == 'Free' && $buttons->where('view', 'links')->count() >= 8) || in_array($user_type, ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored']))) --}}

            @if (
                $buttons &&
                    (($user->user_type == 'Free' && $button_count < 6) ||
                        in_array($user->user_type, ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored'])))
                <div class="grid grid-cols-3 mt-5 gap-4">

                    <div class="h-fit col-span-2">
                        <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New
                        </h1>
                        <p class="text-slate-600 dark:text-slate-500 text-sm">Add a new custom link</p>
                    </div>

                    <div class="flex items-center col-span-1 place-content-end">
                        <a wire:navigate href="{{ route('button.index') }}"
                            class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-6">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>
                            </span>
                        </a>
                    </div>
                </div>
            @endif

        @endif
    </div>

    @if (!$buttons)
        <div class="flex justify-center my-20">
            <a wire:navigate href="{{ route('button.index') }}"
                class="flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">Add
                Button(s) &nbsp;
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                    <path fill-rule="evenodd"
                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                        clip-rule="evenodd" />
                </svg>
            </a>

        </div>
    @endif

    @if ($buttons)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">
            <p class="text-slate-600 dark:text-slate-500 text-sm text-center">Drag the element to rearrange.</p>
            <p
                class="flex items-center justify-center text-slate-600 dark:text-slate-500 text-center text-sm py-1 px-5 mb-10">
                (All the links provided here can be saved as button or icon.)
            </p>
            {{-- Display Sortable Buttons here --}}
            <livewire:sortable-button />
        </div>
    @endif
</div>
