<div>
    @if ($user)
        @guest
            <div
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl my-5">
            @endguest
            {{-- <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20 mt-5"> --}}
            @auth
                <div
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20 mt-5">
                @endauth

                <div class="grid grid-cols-2 gap-4 mb-5">
                    <!-- Download VCF -->
                    <div class="ml-5 flex items-center">
                        <button type="button" wire:click.prevent="test"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-down-tray class="size-5" />
                        </button>
                    </div>

                    <!-- Share Card -->
                    <div class="mr-5 flex items-center place-content-end" x-data="{
                        urlTitle: '{{ $user['firstname'] }} {{ $user['lastname'] }} | {{ $user['job_title'] }}',
                        shareUrl: '{{ $site_url . 'card/' . $user['username'] }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).then(() => {
                                    console.log('Thanks for sharing!');
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">

                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>

                        <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-share class="size-5" />
                        </a>
                    </div>
                </div>

                {{-- Display Profile Picture --}}

                <img src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/10kcards-favicon.jpg') }}"
                    alt="{{ $user['firstname'] . ' ' . $user['lastname'] }}"
                    class="rounded-full w-6/12 mx-auto border-2 border-yellow-600 p-2 z-10 static">

                {{-- Display Full Name --}}
                <h1
                    class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center text-slate-800 dark:text-slate-300 mt-5">
                    {{ $user['firstname'] . ' ' . $user['lastname'] }}&nbsp;
                    @if (in_array($user['user_type'], ['Gold', 'Platinum']))
                        <x-gmdi-verified class="size-4 inline text-yellow-400" />
                    @endif
                </h1>

                <p class="rounded-full bg-yellow-400 py-1 px-2 text-[10px] text-black mx-auto w-fit my-2">
                    {{ '@' . $user['username'] }}
                </p>

                {{-- Display Bio --}}
                @if ($user['bio'])
                    <p class="mx-auto w-10/12 text-slate-800 dark:text-slate-300 text-center text-l py-1">
                        {{ $user['bio'] }}
                    </p>
                @endif

                {{-- Display Job Title --}}
                @if (!empty($user['job_title']) && !empty($user['company']))
                    {{-- @if (!empty($user['job_title']) && !empty($user['company']) && !empty($user['company_website'])) --}}
                    <p
                        class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1">
                        <x-heroicon-o-briefcase class="size-5" />
                        &nbsp;&nbsp;
                        {{ $user['job_title'] }}&nbsp;at&nbsp;
                        {{-- Display Company & Website --}}
                        @if (!empty($user['company_website']))
                            <a href="{{ filter_var($user['company_website'], FILTER_VALIDATE_URL) ? $user['company_website'] : '#' }}"
                                class="text-yellow-600">{{ $user['company'] }}</a>
                        @else
                            {{ $user['company'] }}
                        @endif

                    </p>
                @endif

                {{-- Display Address --}}
                @if ($user['address'] || $user['country'])
                    <p
                        class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1">
                        <x-heroicon-o-map-pin class="size-5" />
                        &nbsp;&nbsp;{{ ($user['address'] ? $user['address'] . ', ' : ' ') . $user['country'] }}
                    </p>
                @endif

                {{-- Display Language --}}
                {{-- @if ($user['language'])
                    <p class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center pt-1">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" class="size-5">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M12 21a9.004 9.004 0 0 0 8.716-6.747M12 21a9.004 9.004 0 0 1-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 0 1 7.843 4.582M12 3a8.997 8.997 0 0 0-7.843 4.582m15.686 0A11.953 11.953 0 0 1 12 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0 1 21 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0 1 12 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 0 1 3 12c0-1.605.42-3.113 1.157-4.418" />
                        </svg>
                        &nbsp;&nbsp;{{ $user['language'] }}
                    </p>
                @endif --}}

                <p class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center pt-5">
                    Contact me
                </p>

                <div class="pt-2 container mx-auto flex items-center justify-center">
                    <a href="mailto:{{ $user['email'] }}" target="_blank" class="text-slate-800 dark:text-slate-300">
                        <x-fas-envelope class="size-6 mx-2" />
                    </a>
                    <a href="tel:{{ $user['phone'] }}" target="_blank" class="text-slate-800 dark:text-slate-300">
                        <x-heroicon-s-phone class="size-6 mx-2" />
                    </a>
                    <a href="sms:{{ $user['phone'] }}" target="_blank" class="text-slate-800 dark:text-slate-300">
                        <x-fas-sms class="size-6 mx-2" />
                    </a>

                    {{-- Other contact points here --}}
                    @if ($contacts)
                        @foreach ($contacts as $contact)
                            @if ($contact['type'] === 'sms')
                                <a href="sms:{{ $contact['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-fas-sms class="size-6 mx-2" />
                                </a>
                            @elseif ($contact['type'] === 'phone')
                                <a href="tel:{{ $contact['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-heroicon-s-phone class="size-6 mx-2" />
                                </a>
                            @elseif ($contact['type'] === 'email')
                                <a href="mailto:{{ $contact['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-fas-envelope class="size-6 mx-2" />
                                </a>
                            @elseif ($contact['type'] === 'whatsapp')
                                <a href="{{ $contact['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-ri-whatsapp-fill class="size-6 mx-2" />
                                </a>
                            @elseif ($contact['type'] === 'telegram')
                                <a href="{{ $contact['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-fileicon-telegram class="size-6 mx-2" />
                                </a>
                            @elseif ($contact['type'] === 'zoom')
                                <a href="{{ $contact['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-bxl-zoom class="size-6 mx-2" />
                                </a>
                            @endif
                        @endforeach
                    @endif
                </div>

                @if ($socials)
                    <p class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center pt-5">
                        Follow me
                    </p>

                    <!-- Social Media Buttons -->
                    <div class="pt-2 container mx-auto flex items-center justify-center">
                        @foreach ($socials as $social)
                            @if ($social['type'] === 'facebook')
                                <!-- Facebook -->
                                <a href="{{ $social['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-fab-facebook class="size-6 mx-2" />
                                </a>
                            @elseif($social['type'] == 'clubhouse')
                                <!-- Clubhouse -->
                                <a href="{{ $social['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-si-clubhouse class="size-6 mx-2" />

                                </a>
                            @elseif($social['type'] == 'tiktok')
                                <!-- LinkedIn -->
                                <a href="{{ $social['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-fab-tiktok class="size-6 mx-2" />

                                </a>
                            @elseif($social['type'] == 'linkedin')
                                <!-- LinkedIn -->
                                <a href="{{ $social['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-fab-linkedin class="size-6 mx-2" />

                                </a>
                            @elseif($social['type'] == 'x')
                                <!-- Twitter -->
                                <a href="{{ $social['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-ri-twitter-x-fill class="size-6 mx-2" />

                                </a>
                            @elseif($social['type'] == 'instagram')
                                <!-- Instagram -->
                                <a href="{{ $social['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-fab-instagram class="size-6 mx-2" />
                                </a>
                            @elseif($social['type'] == 'tiktok')
                                <!-- Tiktok -->
                                <a href="{{ $social['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-fab-tiktok class="size-6 mx-2" />
                                </a>
                            @elseif($social['type'] == 'youtube')
                                <a href="{{ $social['link'] }}" target="_blank"
                                    class="text-slate-800 dark:text-slate-300">
                                    <x-fab-tiktok class="size-6 mx-2" />
                                </a>
                            @endif
                        @endforeach
                    </div>

                @endif

                @if ($videos && $user->user_type == 'Platinum')
                    <!-- Video Carousel-->
                    <div class="w-full relative mx-auto px-5 mt-10" x-data="{
                        swiper: null,
                        initSwiper() {
                            this.swiper = new Swiper('.default-carousel', {
                                loop: true,
                                pagination: {
                                    el: '.swiper-pagination',
                                    clickable: true,
                                },
                                navigation: {
                                    nextEl: '.swiper-button-next',
                                    prevEl: '.swiper-button-prev',
                                },
                            });
                        },
                    }" x-init="initSwiper()">
                        <div class="swiper default-carousel swiper-container">
                            <div class="swiper-wrapper {{ $video_count > 1 ? 'mb-10' : '' }}">

                                @foreach ($videos as $video)
                                    <div class="swiper-slide">
                                        <div
                                            style="position: relative; width: 100%; height: 0; padding-bottom: 56.25%;">

                                            {{-- Inline PHP to extract the YouTube ID --}}
                                            @php
                                                // Extract the video ID from different YouTube URL formats
                                                $videoUrl = $video['link'];
                                                $videoId = null;
                                                $videoHash = null;
                                                $isVimeo = false;

                                                // Regular YouTube link (https://www.youtube.com/watch?v=VIDEO_ID)
                                                if (
                                                    preg_match(
                                                        '#(?:https?://)?(?:www\.)?youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#',
                                                        $videoUrl,
                                                        $matches,
                                                    )
                                                ) {
                                                    $videoId = $matches[1];
                                                }
                                                // Shortened YouTube link (https://youtu.be/VIDEO_ID)
                                                elseif (
                                                    preg_match(
                                                        '#(?:https?://)?(?:www\.)?youtu\.be/([a-zA-Z0-9_-]+)#',
                                                        $videoUrl,
                                                        $matches,
                                                    )
                                                ) {
                                                    $videoId = $matches[1];
                                                }
                                                // YouTube embedded link (https://m.youtube.com/v/VIDEO_ID)
                                                elseif (
                                                    preg_match(
                                                        '#(?:https?://)?(?:www\.)?m\.youtube\.com/v/([a-zA-Z0-9_-]+)#',
                                                        $videoUrl,
                                                        $matches,
                                                    )
                                                ) {
                                                    $videoId = $matches[1];
                                                } elseif (
                                                    // Vimeo link regex (Captures video ID and optional hash)
                                                    preg_match(
                                                        '#(?:https:\/\/(?:player\.)?vimeo\.com\/(?:video\/)?(\d+)(?:\/([a-zA-Z0-9]+))?)#',
                                                        $videoUrl,
                                                        $matches,
                                                    )
                                                ) {
                                                    $videoId = $matches[1];
                                                    $videoHash = isset($matches[2]) ? $matches[2] : null;
                                                    $isVimeo = true;
                                                }
                                            @endphp

                                            @if ($isVimeo)
                                                <!-- Embed Vimeo video with hash -->
                                                <iframe class="absolute w-full h-full"
                                                    src="https://player.vimeo.com/video/{{ $videoId }}?h={{ $videoHash }}"
                                                    title="{{ $video['title'] }}" frameborder="0"
                                                    allow="autoplay; fullscreen">
                                                </iframe>
                                                <script src="https://player.vimeo.com/api/player.js"></script>
                                            @else
                                                <!-- Embed YouTube video -->
                                                <iframe class="absolute w-full h-full"
                                                    src="https://www.youtube.com/embed/{{ $videoId }}"
                                                    title="{{ $video['title'] }}" frameborder="0"
                                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                                    referrerpolicy="strict-origin-when-cross-origin" allowfullscreen>
                                                </iframe>
                                            @endif

                                        </div>
                                    </div>
                                @endforeach


                            </div>
                            <div class="flex items-center gap-8 lg:justify-start justify-center">
                                {{-- <button id="slider-button-left"
                                class="swiper-button-prev group !p-2 flex justify-center items-center border border-solid border-indigo-600 !w-12 !h-12 transition-all duration-500 rounded-full !top-2/4 !-translate-y-8 !left-5 hover:bg-indigo-600 "
                                data-carousel-prev>
                                <svg class="h-5 w-5 text-indigo-600 group-hover:text-white"
                                    xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                    viewBox="0 0 16 16" fill="none">
                                    <path d="M10.0002 11.9999L6 7.99971L10.0025 3.99719" stroke="currentColor"
                                        stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </button> --}}
                                {{-- <button id="slider-button-right"
                                class="swiper-button-next group !p-2 flex justify-center items-center border border-solid border-indigo-600 !w-12 !h-12 transition-all duration-500 rounded-full !top-2/4 !-translate-y-8  !right-5 hover:bg-indigo-600"
                                data-carousel-next>
                                <svg class="h-5 w-5 text-indigo-600 group-hover:text-white"
                                    xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                    viewBox="0 0 16 16" fill="none">
                                    <path d="M5.99984 4.00012L10 8.00029L5.99748 12.0028" stroke="currentColor"
                                        stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </button> --}}
                            </div>
                            <div class="swiper-pagination"></div>

                        </div>
                    </div>
                @endif

                <!-- Buttons -->
                {{-- <div class="items-center mt-5"> --}}
                <div class="items-center">

                    {{-- Button with icon --}}
                    {{-- <a class="flex items-center justify-center bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto mb-5 text-l font-bold"
                        href="https://forms.gle/yAcvdN2PiJXf1kVN7" target="_blank"><svg
                            xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" class="size-5 inline">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M20.25 14.15v4.25c0 1.094-.787 2.036-1.872 2.18-2.087.277-4.216.42-6.378.42s-4.291-.143-6.378-.42c-1.085-.144-1.872-1.086-1.872-2.18v-4.25m16.5 0a2.18 2.18 0 0 0 .75-1.661V8.706c0-1.081-.768-2.015-1.837-2.175a48.114 48.114 0 0 0-3.413-.387m4.5 8.006c-.194.165-.42.295-.673.38A23.978 23.978 0 0 1 12 15.75c-2.648 0-5.195-.429-7.577-1.22a2.016 2.016 0 0 1-.673-.38m0 0A2.18 2.18 0 0 1 3 12.489V8.706c0-1.081.768-2.015 1.837-2.175a48.111 48.111 0 0 1 3.413-.387m7.5 0V5.25A2.25 2.25 0 0 0 13.5 3h-3a2.25 2.25 0 0 0-2.25 2.25v.894m7.5 0a48.667 48.667 0 0 0-7.5 0M12 12.75h.008v.008H12v-.008Z" />
                        </svg>&nbsp;&nbsp;Hire Me</a> --}}
                    @if ($buttons)
                        @foreach ($buttons as $button)
                            @if ($button['type'] === 'sms')
                                <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                    href="sms:{{ $button['link'] }}" target="_blank">{{ $button['title'] }}</a>
                            @elseif($button['type'] === 'phone')
                                <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                    href="tel:{{ $button['link'] }}" target="_blank">{{ $button['title'] }}</a>
                            @elseif($button['type'] === 'email')
                                <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                    href="mailto:{{ $button['link'] }}" target="_blank">{{ $button['title'] }}</a>
                                {{-- @elseif($button['type'] === 'whatsapp')
                                <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                    href="https://wa.me/{{ $button['link'] }}"
                                    target="_blank">{{ $button['title'] }}</a> --}}
                            @else
                                @php
                                    if (!preg_match('/^https?:\/\//', $button['link'])) {
                                        $button['link'] = 'https://' . $button['link'];
                                    }
                                @endphp
                                <a class="block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                    href="{{ $button['link'] }}" target="_blank">{{ $button['title'] }}</a>
                            @endif
                        @endforeach
                    @endif

                    @if ($products && in_array($user->user_type, ['Gold', 'Platinum']))
                        <a wire:navigate href="{{ route('card.products', $user->username) }}"
                            class="flex bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-3 rounded-full w-10/12 text-black text-center mx-auto my-5 text-l font-bold items-center justify-center"
                            href="" target="_blank">
                            <x-heroicon-s-shopping-bag class="size-4 inline" />
                            &nbsp;&nbsp;
                            {{ $shop_text }}</a>
                    @endif

                    @if (in_array($user['user_type'], ['Basic', 'Gold', 'Platinum']))
                        @if ($payments)
                            <p
                                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center pt-5">
                                Payment links
                            </p>

                            <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">
                                @foreach ($payments as $payment)
                                    @if ($payment['type'] === 'credit')
                                        <a href="{{ $payment['link'] }}" target="_blank"
                                            class="text-slate-800 dark:text-slate-300">
                                            <x-heroicon-s-credit-card class="size-7 mx-2 my-2" />
                                        </a>
                                    @elseif($payment['type'] == 'zelle')
                                        <button
                                            @click="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{{ $payment['link'] }}'"
                                            class="text-slate-800 dark:text-slate-300">
                                            <x-si-zelle class="size-7 mx-2 my-2" />
                                        </button>
                                    @elseif($payment['type'] == 'apple_pay')
                                        <button
                                            @click="openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{{ $payment['link'] }}'"
                                            class="text-slate-800 dark:text-slate-300">
                                            <x-fab-apple class="size-7 mx-2 my-2" />
                                        </button>
                                    @elseif($payment['type'] == 'venmo')
                                        <a href="{{ $payment['link'] }}" target="_blank"
                                            class="text-slate-800 dark:text-slate-300">
                                            <x-bxl-venmo class="size-7 mx-2 my-2" />
                                        </a>
                                    @elseif($payment['type'] == 'cashapp')
                                        <a href="{{ $payment['link'] }}" target="_blank"
                                            class="text-slate-800 dark:text-slate-300">
                                            <x-si-cashapp class="size-7 mx-2 my-2" />
                                        </a>
                                    @elseif($payment['type'] == 'paypal_email')
                                        <button
                                            @click="openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{{ $payment['link'] }}'"
                                            class="text-slate-800 dark:text-slate-300">
                                            <x-fab-paypal class="size-7 mx-2 my-2" />
                                        </button>
                                    @elseif($payment['type'] == 'paypal_link')
                                        <a href="{{ $payment['link'] }}" target="_blank"
                                            class="text-slate-800 dark:text-slate-300">
                                            <x-fab-paypal class="size-7 mx-2 my-2" />
                                        </a>
                                    @endif
                                @endforeach
                            </div>

                        @endif
                    @endif
                </div>

                @if ($footer_enabled && $customFooter && in_array($user->user_type, ['Basic', 'Gold', 'Platinum']))
                    <p
                        class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l pt-5 py-1">
                        <a href="{{ $footer_link }}" target="_blank"
                            class="text-yellow-600">{{ $footer_text }}</a>
                    </p>
                @elseif ($footer_enabled && !$customFooter && $default_footer_text && $default_footer_link)
                    <p
                        class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l pt-5 py-1">
                        <a href="{{ $default_footer_link }}" target="_blank"
                            class="text-yellow-600">{{ $default_footer_text }}</a>
                    </p>
                @elseif (!$footer_enabled && in_array($user->user_type, ['Basic', 'Gold', 'Platinum']))
                    <p> </p>
                @else
                    <p
                        class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l pt-5 py-1">
                        <a href="{{ $site_url }}" target="_blank" class="text-yellow-600">Get your card
                            today!</a>
                    </p>
                @endif

            </div>
        </div>
    @else
        <div class="h-screen flex justify-center items-center">
            <div>
                <p class="mx-auto text-yellow-500 text-center text-l p-10">
                    <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
                </p>
                <p class="mx-auto font-bold text-slate-800 dark:text-slate-300 text-center text-2xl">User not found.
                </p>

                <p class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1">
                    <a href="{{ $site_url }}" target="_blank" class="text-yellow-600">Get your card
                        today!</a>
                </p>
            </div>
        </div>
    @endif
</div>
