<div>

    <!-- Overlay (Initially hidden) -->
    {{-- <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden toggleSocialActionSheet"></div> --}}

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('settings.index') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold ">

                <x-heroicon-o-cog-6-tooth class="size-6 inline-block" />

                &nbsp;&nbsp;Customization
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>

        </div>

    </div>

    <livewire:switch-card-component />

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-2 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl">

        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">

            <li>
                <a wire:navigate href="{{ route('card-customization.index') }}"
                    class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-pencil-square class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Contents
                            </p>
                        </div>
                    </div>

                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        <span class="rounded-full text-gray-600 p-2">
                            <x-bi-chevron-right class="size-4" />
                        </span>
                    </div>
                </a>
            </li>

            <!-- Manage Theme -->
            <li>
                <a wire:navigate href="{{ route('customize.themes') }}" class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">

                            <x-heroicon-o-paint-brush class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Manage Theme</p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end justify-center">
                        {{-- <span
                            class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                            New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                        </span> --}}
                        {{-- <span class="rounded-full text-gray-600 p-2">
                        <x-bi-chevron-right class="size-4" />
                    </span> --}}
                    </div>
                </a>
            </li>

            <!-- Layout -->
            <li>
                <a wire:navigate href="{{ route('dashboard.layout') }}" class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-radix-layout class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Layout </p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end justify-center">
                        {{-- <span
                        class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                        Soon
                    </span> --}}

                        <span
                            class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                            New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                        </span>

                        {{-- <span class="rounded-full text-gray-600 p-2">
                        <x-bi-chevron-right class="size-4" />
                    </span> --}}
                    </div>
                </a>
            </li>

        </ul>

    </div>

</div>
