<div class="mb-20">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">
        <div class="grid grid-cols-5 gap-4">

            <div class="flex items-center col-span-1">
                <livewire:notification-bell-component />
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <x-radix-dashboard class="size-6 inline-block" />

                &nbsp;&nbsp;Dashboard
            </p>

            <div class="flex items-center col-span-1 place-content-end">

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                </a>
            </div>
        </div>
    </div>

    @if (auth()->user()->onTrial() && !in_array($user->access, ['Month', 'Year']))
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto rounded-2xl mb-4 py-2 bg-yellow-300">
            <div class="px-3 py-2">
                <p class="text-xs/6 font-semibold text-yellow-800">
                    You are on trial mode that will end on {{ auth()->user()->trialEndsAt()->format('M d, Y') }}
                    ({{ auth()->user()->trialEndsAt()->diffForHumans() }}). To
                    continue enjoying uninterrupted access, please manage your subscription.
                </p>
                <a href="{{ route('upgrade.index') }}"
                    class="mt-5 w-fit rounded-md px-3 py-2 text-xs font-semibold shadow-xs bg-yellow-500 text-black flex">
                    Manage Subscription
                </a>
            </div>
        </div>
    @endif

    <!-- SECTION 1 -->
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-4 py-10">

        <div class="mx-auto">
            <livewire:profile-photo-field :model="auth()->user()" />
        </div>

        {{-- <button id="enablePush" class="text-white">Enable Push Notifications</button> --}}

        <h1
            class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center text-slate-800 dark:text-slate-300 mt-5 mx-5">
            <span> {{ $card_title != '' ? $card_title : $firstname . ' ' . $lastname }}
                @if ($user['user_type'] == 'Gold')
                    <x-gmdi-verified class="size-4 inline text-yellow-400" />
                @elseif($user['user_type'] == 'Platinum')
                    <x-gmdi-verified class="size-4 inline text-blue-500" />
                @endif
            </span>
        </h1>

        {{-- Display Job Title --}}
        @if (!empty($user['job_title']) && empty($user['company']))
            <p class="text-slate-800 dark:text-slate-300 text-center text-base py-1 mx-8">
                <span class="inline-flex items-start gap-2">
                    <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                    <span>{{ $user['job_title'] }}</span>
                </span>
            </p>
        @endif

        {{-- Display Job Title and company --}}
        @if (!empty($user['job_title']) && !empty($user['company']))
            <p class="text-slate-800 dark:text-slate-300 text-center text-base py-1 mx-8">
                <span class="inline-flex items-start gap-2">
                    <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                    <span>{{ $user['job_title'] }}</span>
                </span>
            </p>
        @endif

        {{-- Display Card Type --}}
        <p class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 mt-5">
            @if (auth()->user()->onTrial() && !in_array($user->access, ['Month', 'Year']))
                <span
                    class="inline-flex items-center rounded-md bg-green-100 px-2 py-1 text-xs font-medium text-green-700 ring-1 ring-pink-700/10 ring-inset mr-2">Trial</span>
            @endif

            @if ($user['user_type'] === 'Free')
                <span
                    class="inline-flex items-center rounded-md bg-green-100 px-2 py-1 text-xs font-medium text-green-700 ring-1 ring-pink-700/10 ring-inset mr-2">Free</span>
            @elseif ($user['user_type'] === 'Basic')
                <span
                    class="inline-flex items-center rounded-md bg-pink-100 px-2 py-1 text-xs font-medium text-pink-700 ring-1 ring-pink-700/10 ring-inset">{{ $term_basic }}</span>
            @elseif($user['user_type'] === 'Gold')
                <span
                    class="inline-flex items-center rounded-md bg-yellow-100 px-2 py-1 text-xs font-medium text-yellow-800 ring-1 ring-yellow-600/20 ring-inset">{{ $term_gold }}</span>
            @elseif($user['user_type'] === 'Platinum')
                <span
                    class="inline-flex items-center rounded-md bg-gray-100 px-2 py-1 text-xs font-medium text-gray-600 ring-1 ring-gray-500/10 ring-inset">{{ $term_platinum }}</span>
            @elseif($user['user_type'] === 'Sponsored')
                <span
                    class="inline-flex items-center rounded-md bg-red-400 px-2 py-1 text-xs font-medium text-red-800 ring-1 ring-yellow-600/20 ring-inset">{{ $user['user_type'] }}</span>
            @elseif($user['user_type'] === 'Influencer')
                <span
                    class="inline-flex items-center rounded-md bg-pink-400 px-2 py-1 text-xs font-medium text-pink-800 ring-1 ring-yellow-600/20 ring-inset">{{ $user['user_type'] }}</span>
            @else
                <span
                    class="inline-flex items-center rounded-md bg-violet-100 px-2 py-1 text-xs font-medium text-violet-600 ring-1 ring-violet-500/10 ring-inset">Setup
                    Incomplete</span>
            @endif
        </p>

        @if (
            ($platinum_enabled && in_array(auth()->user()->user_type, ['Free', 'Basic', 'Gold', 'Sponsored', 'Influencer'])) ||
                (!$platinum_enabled && in_array(auth()->user()->user_type, ['Free', 'Basic', 'Sponsored', 'Influencer'])))
            <a href="{{ route('upgrade.index') }}"
                class="inline-flex mt-5 mx-auto items-center justify-center px-2 py-1 text-xs font-medium text-yellow-900 bg-yellow-300 hover:bg-yellow-400 rounded-md shadow-sm transition">
                Upgrade
                <x-heroicon-o-bolt class="size-4 inline" stroke-width="2" />
            </a>
        @endif

        <a href="{{ route('card.show', $user['username']) }}"
            class="inline-flex mt-5 mx-auto items-center justify-center px-2 py-1 text-xs font-medium bg-white text-black rounded-md shadow-sm transition">
            View Card&nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-4 inline" stroke-width="2" />
        </a>

        {{-- Display Job Title --}}
        @if (in_array(auth()->user()->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']))
            <div class="grid grid-cols-4 gap-4 mt-10">
                {{-- update profile --}}
                <div class="col-span-2">
                    <a wire:navigate href="{{ route('profile.edit') }}"
                        class="flex items-center justify-center text-center text-slate-600 ml-1 dark:text-slate-500 mt-5 text-sm">Update
                        Profile&nbsp;&nbsp;
                        <x-heroicon-s-pencil class="size-4 inline" />
                    </a>
                </div>

                {{-- Switch Card --}}
                <div class="col-span-2">
                    <a @click="showSwitchActiveCardModal=!showSwitchActiveCardModal"
                        class="flex items-center justify-center text-center text-slate-600 ml-1 dark:text-slate-500 mt-5 text-sm cursor-pointer">Switch
                        Card
                        &nbsp;&nbsp;

                        <x-heroicon-s-arrows-right-left class="size-4 inline" />
                    </a>

                </div>
            </div>
        @else
            <a wire:navigate href="{{ route('profile.edit') }}"
                class="flex items-center justify-center text-center text-slate-600 ml-1 dark:text-slate-500 mt-10 text-sm">Update
                Profile&nbsp;&nbsp;
                <x-heroicon-s-pencil class="size-4 inline" />
            </a>
        @endif
    </div>

    @can('view', App\Models\Analytics::class)
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-4">
            <h1 class="text-xl text-slate-800 dark:text-slate-300">Analytics
            </h1>
            <p class="text-slate-600 dark:text-slate-500 text-sm">Gain valuable insights into how your audience
                engages with your content. Monitor clicks on your links and social profiles, and see how many views
                your digital business card is attracting — all in one place.</p>
        </div>

        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-4">

            <div class="mx-5">
                <a wire:navigate href="{{ route('dashboard.analytics') }}">
                    <canvas id="myChart"></canvas>
                </a>
            </div>
        </div>
    @endcan

    @if (in_array(auth()->user()->user_type, ['Gold', 'Platinum']))
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
            <div class="grid grid-cols-3 gap-4">
                <div class="h-fit col-span-2">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Network
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Manage your contacts here</p>
                    {{-- <div class="mt-3 flex -space-x-2">
                        <img class="inline-block h-8 w-8 rounded-full ring-2 ring-white"
                            src="https://images.unsplash.com/photo-1491528323818-fdd1faba62cc?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=facearea&facepad=2&w=256&h=256&q=80"
                            alt="" />
                        <img class="inline-block h-8 w-8 rounded-full ring-2 ring-white"
                            src="https://images.unsplash.com/photo-1550525811-e5869dd03032?ixlib=rb-1.2.1&auto=format&fit=facearea&facepad=2&w=256&h=256&q=80"
                            alt="" />
                        <img class="inline-block h-8 w-8 rounded-full ring-2 ring-white"
                            src="https://images.unsplash.com/photo-1500648767791-00dcc994a43e?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=facearea&facepad=2.25&w=256&h=256&q=80"
                            alt="" />
                        <img class="inline-block h-8 w-8 rounded-full ring-2 ring-white"
                            src="https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=facearea&facepad=2&w=256&h=256&q=80"
                            alt="" />
                        <img class="inline-block h-8 w-8 rounded-full ring-2 ring-white"
                            src="https://images.unsplash.com/photo-1517365830460-955ce3ccd263?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=facearea&facepad=2&w=256&h=256&q=80"
                            alt="" />
                    </div> --}}
                </div>

                <div class="col-span-1 flex items-center place-content-end">

                    <div class="flex items-center col-span-1 place-content-end">
                        <a wire:navigate href="{{ route('dashboard.network') }}"
                            class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg toggleActionSheet">
                            <span class="text-zinc-900">
                                <x-gmdi-manage-accounts-r class="size-6" />
                            </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
            <div class="grid grid-cols-3 gap-4 height-auto">

                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p
                            class="flex items-center justify-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Saved
                        </p>

                        <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium text-center">
                            {{ $network_saved }}
                        </h1>

                    </div>
                </div>

                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p
                            class="flex items-center justify-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Added
                        </p>

                        <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium text-center">
                            {{ $network_added }}
                        </h1>

                    </div>
                </div>

                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p
                            class="flex items-center justify-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Form
                        </p>

                        <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium text-center">
                            {{ $network_form }}
                        </h1>

                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
        <div class="grid grid-cols-3 gap-4">

            <div class="h-fit col-span-2">
                <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New
                </h1>
                <p class="text-slate-600 dark:text-slate-500 text-sm">Add links to your card! Portfolio, shop, or
                    social accounts—sky’s the limit!</p>
            </div>

            <div class="flex items-center col-span-1 place-content-end">
                <button @click="actionSheet=!actionSheet"
                    class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg toggleActionSheet">
                    <span class="text-zinc-900">
                        <x-heroicon-o-plus class="size-6" />
                    </span>
                </button>
            </div>
        </div>
    </div>

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">
        <div class="grid grid-cols-2 gap-4 height-auto">
            <div class="flex flex-col">
                <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                    <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                        Manage Links
                    </p>
                    <div class="grid grid-cols-3">
                        <div class="col-span-1">
                            <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">{{ $button_count }}
                            </h1>
                        </div>
                        <div class="col-span-2 grid justify-end">
                            <a wire:navigate href="{{ route('dashboard.button') }}"
                                class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                @if ($button_count)
                                    Manage
                                    &nbsp;
                                    <x-gmdi-manage-accounts-r class="size-3 inline" />
                                @else
                                    Add &nbsp;
                                    <x-heroicon-o-plus class="size-3 inline" />
                                @endif
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex flex-col">
                <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                    <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                        Manage Socials
                    </p>

                    <div class="grid grid-cols-3">
                        <div class="col-span-1">
                            <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">{{ $social_count }}
                            </h1>
                        </div>
                        <div class="col-span-2 grid justify-end">
                            <a wire:navigate href="{{ route('dashboard.social') }}"
                                class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                @if ($social_count)
                                    Manage
                                    &nbsp;
                                    <x-gmdi-manage-accounts-r class="size-3 inline" />
                                @else
                                    Add &nbsp;
                                    <x-heroicon-o-plus class="size-3 inline" />
                                @endif
                            </a>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pt-4 mb-5">
        <div class="grid grid-cols-2 gap-4 height-auto">
            @if (in_array($user['user_type'], ['Gold', 'Platinum']))
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Manage Products
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $product_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.product') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($product_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Manage Videos
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">{{ $video_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.video') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($video_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

            @endif
        </div>
    </div>

    <livewire:switch-active-card />

    @push('scripts')
        <script>
            document.addEventListener('livewire:navigated', () => {
                const component = Livewire.find(document.querySelector('[wire\\:id]')?.getAttribute('wire:id'));
                if (!component) return;

                const chartEl = document.getElementById('myChart');

                const card_view_analytics_by_month = component.card_view_analytics_by_month;

                const months = component.months;
                const days = component.days;

                let myChart;

                if (!chartEl) return;

                const ctx = chartEl.getContext('2d');

                if (window.myChart instanceof Chart) {
                    window.myChart.destroy();
                }

                window.myChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: months,
                        datasets: [{
                                label: 'Card Views',
                                data: card_view_analytics_by_month,
                                borderWidth: 2
                            }

                        ]
                    },
                    options: {
                        scales: {
                            y: {
                                beginAtZero: true,
                            }
                        }
                    }
                });
            });
        </script>
    @endpush
</div>
