<div x-data="{
    activeTab: @if ($subscriptions->isNotEmpty()) 'all_subscriptions'
        @elseif($collections->isNotEmpty())
            'all_collections'
            @elseif($daily_deals->isNotEmpty())
            'daily_deals'
            @elseif($product_categories->isNotEmpty())
            'products_by_category'
        @else
            'all_products' @endif
}">
    @if ($user && ($products->isNotEmpty() || $subscriptions->isNotEmpty()))
        @guest
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative my-5 mb-20">
            @endguest

            @auth
                <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">
                @endauth

                {{-- Top Navigation --}}
                <div
                    class="grid grid-cols-4 gap-4 mb-5 pt-5 z-10 {{ $profile_layout == 'default_cover' || $profile_layout == 'cover_only' || $profile_layout == 'full_width' ? 'absolute top-0 left-0 w-full' : '' }}">
                    <div class="ml-5 flex items-center col-span-2">
                        <a href="{{ route('card.show', $user->username) }}"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-home class="size-5" />
                        </a>
                    </div>

                    <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
                        urlTitle: `{{ $shop_title }} | {{ $page_title ?: $card_title }}`,
                        shareUrl: '{{ route('card.products', $username) }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">
                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>
                        <a href="#" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-up-tray class="size-5" />
                        </a>
                    </div>
                </div>

                {{-- Profile Layouts --}}
                @if ($profile_layout == 'default_cover')
                    <img loading="lazy"
                        src="{{ $user['cover_pic'] ? asset($user['cover_pic']) : asset('/img/cover-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">
                    <img loading="lazy"
                        src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}"
                        class="rounded-full w-6/12 mx-auto -mt-28 border-2"
                        style="border-color: {{ $color_settings_profile_pic_border }} !important;">
                @elseif ($profile_layout == 'cover_only')
                    <img loading="lazy"
                        src="{{ $user['cover_pic'] ? asset($user['cover_pic']) : asset('/img/cover-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">
                @elseif ($profile_layout == 'default')
                    <img loading="lazy"
                        src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}"
                        class="rounded-full w-6/12 mx-auto p-2 border-2"
                        style="border-color: {{ $color_settings_profile_pic_border }} !important;">
                @elseif ($profile_layout == 'rounded')
                    <img loading="lazy"
                        src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}"
                        class="w-6/12 mx-auto p-2 border-2 rounded-[50px]"
                        style="border-color: {{ $color_settings_profile_pic_border }} !important;">
                @elseif ($profile_layout == 'full_width')
                    <img loading="lazy"
                        src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">
                @endif

                <h1 class="text-2xl font-medium text-center mt-5">{{ $shop_title }}</h1>

                {{-- Toggle Buttons --}}
                <div class="flex flex-wrap justify-center items-center gap-2 mt-10 p-2 rounded-full">
                    {{-- <div class="flex justify-center items-center mt-10 p-2 rounded-full"> --}}
                    @if ($products->isNotEmpty() && $subscriptions->isNotEmpty())
                        {{-- <button @click="activeTab = 'all_subscriptions'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'all_subscriptions'
                                ?
                                'background-color: {{ $color_settings_custom_button }}; color: white;' :
                                'background-color: transparent; color: {{ $color_settings_custom_button }};'">
                            Subscriptions
                        </button> --}}

                        <button @click="activeTab = 'all_subscriptions'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'all_subscriptions'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">
                            Subscriptions
                        </button>
                    @endif

                    @if ($daily_deals->isNotEmpty())
                        {{-- <button @click="activeTab = 'daily_deals'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'daily_deals'
                                ?
                                'background-color: {{ $color_settings_custom_button }}; color: white;' :
                                'background-color: transparent; color: {{ $color_settings_custom_button }};'">
                            Daily Deals
                        </button> --}}

                        <button @click="activeTab = 'daily_deals'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'daily_deals'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">
                            Daily Deals
                        </button>
                    @endif

                    @if ($products->isNotEmpty() && $collections->isNotEmpty())
                        {{-- <button @click="activeTab = 'all_collections'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'all_collections'
                                ?
                                'background-color: {{ $color_settings_custom_button }}; color: white;' :
                                'background-color: transparent; color: {{ $color_settings_custom_button }};'">
                            Collections
                        </button> --}}

                        <button @click="activeTab = 'all_collections'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'all_collections'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">
                            Collections
                        </button>
                    @endif

                    @if ($products->isNotEmpty() && $product_categories->isNotEmpty())
                        {{-- <button @click="activeTab = 'products_by_category'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'products_by_category'
                                ?
                                'background-color: {{ $color_settings_custom_button }}; color: white;' :
                                'background-color: transparent; color: {{ $color_settings_custom_button }};'">
                            Categories
                        </button> --}}

                        <button @click="activeTab = 'products_by_category'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'products_by_category'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">
                            Categories
                        </button>
                    @endif

                    {{-- @if ($products->isNotEmpty()) --}}
                    @if ($products->isNotEmpty() && ($collections->isNotEmpty() || $product_categories->isNotEmpty()))
                        {{-- <button @click="activeTab = 'all_products'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'all_products'
                                ?
                                'background-color: {{ $color_settings_custom_button }}; color: white;' :
                                'background-color: transparent; color: {{ $color_settings_custom_button }};'">
                            All Products
                        </button> --}}

                        <button @click="activeTab = 'all_products'"
                            class="mx-1 px-4 py-2 text-xs rounded-full font-medium border border-current transition-all"
                            :style="activeTab === 'all_products'
                                ?
                                'background-color: #facc15; color: black;' :
                                'background-color: white; color: black;'">
                            All Products
                        </button>
                    @endif
                </div>

                {{-- CONTENTS --}}
                {{-- Subscriptions --}}
                @if ($subscriptions->isNotEmpty())
                    {{-- All Products --}}
                    <div id="all_subscriptions" x-cloak x-show="activeTab === 'all_subscriptions'" x-transition>
                        @if ($subscriptions->isNotEmpty())
                            {{-- <div class="grid grid-cols-2 gap-4 mt-5 px-5 mb-10 items-stretch"> --}}
                            <div class="flex flex-wrap justify-center gap-4 mt-5 mx-auto">
                                @foreach ($subscriptions as $subscription)
                                    <div class="bg-slate-100 dark:bg-zinc-800 rounded-md h-full w-[45%]">
                                        <a
                                            href="{{ route('subscription.show', ['username' => $user->username, 'id' => $subscription->id]) }}">
                                            <img loading="lazy"
                                                src="{{ $subscription->featured_image ? asset($subscription->featured_image) : asset('/img/product-placeholder.jpg') }}"
                                                alt="{{ $subscription->product_name }}"
                                                class="rounded-t-md w-full h-auto aspect-[4/3] object-cover object-top">
                                        </a>

                                        <div class="px-3 py-2 justify-between">
                                            <a
                                                href="{{ route('subscription.show', ['username' => $user->username, 'id' => $subscription->id]) }}">

                                                <h1 class="text-sm font-medium text-center truncate">
                                                    {{ $subscription->product_name }}
                                                </h1>

                                                @if ($product_price_enabled)
                                                    @php
                                                        $firstOption = $subscription->subscription_options[0] ?? null;
                                                        // dd($firstOption, $subscription['has_coins']);
                                                    @endphp

                                                    @if (($firstOption && $subscription->has_coins) || ($subscription->has_coins && $subscription->coin))
                                                        {{-- @if (($firstOption && ($firstOption['has_coins'] ?? false)) || ($subscription->has_coins && $subscription->coin)) --}}
                                                        {{-- Show only FIRST coin --}}
                                                        <div class="flex justify-center items-center">
                                                            <p class="flex items-center text-sm"
                                                                style="color: #ca8a04;">
                                                                @if (!$subscription->has_packages)
                                                                    {{ $subscription->coin }}
                                                                @endif

                                                                @if ($firstOption)
                                                                    {{ $firstOption['coin'] }}
                                                                @endif

                                                                &nbsp;<x-fas-coins class="size-3" />
                                                            </p>
                                                        </div>
                                                    @else
                                                        {{-- Fallback to normal price --}}
                                                        {{-- <h1 class="text-sm font-medium text-center"
                                                            style="color: {{ $color_settings_link }}">
                                                            ${{ $subscription->price }}
                                                        </h1> --}}

                                                        <h1 class="text-sm font-medium text-center"
                                                            style="color: #ca8a04;">

                                                            @if (!$subscription->has_packages)
                                                                ${{ $subscription->price }}
                                                            @endif

                                                            @if ($firstOption)
                                                                ${{ $firstOption['price'] }}
                                                            @endif

                                                        </h1>
                                                    @endif
                                                @endif

                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                @endif

                {{-- Collections --}}
                @if ($products->isNotEmpty() && $collections->isNotEmpty())
                    <div id="all_collections" x-cloak x-show="activeTab === 'all_collections'" x-transition>
                        <div class="flex flex-wrap gap-4 mt-5 px-5 mb-10 items-stretch justify-center">
                            @foreach ($collections as $collection)
                                <div class="bg-slate-100 dark:bg-zinc-800 rounded-md flex flex-col h-full">
                                    <a
                                        href="{{ route('card.collection', ['username' => $user->username, 'collection_id' => $collection->id]) }}">
                                        <img loading="lazy" src="{{ asset($collection->image) }}"
                                            alt="{{ $collection->title }}"
                                            class="rounded-t-md w-full h-auto object-cover object-top">
                                    </a>
                                    <div class="px-3 py-2 flex flex-col justify-between flex-1">
                                        <a
                                            href="{{ route('card.collection', ['username' => $user->username, 'collection_id' => $collection->id]) }}">
                                            <h1 class="text-sm font-medium text-center truncate">
                                                {{ $collection->title }}
                                            </h1>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                {{-- Categories --}}
                {{-- @if ($products->isNotEmpty() && $product_categories->isNotEmpty())
                    <div id="products_by_category" x-cloak x-show="activeTab === 'products_by_category'" x-transition>
                        @foreach ($product_categories as $category)
                            @php $categoryProducts = $products->where('category_id', $category->id); @endphp
                            @if ($categoryProducts->isNotEmpty())
                                <div>
                                    <h2 class="text-xl font-medium text-center mt-10">{{ $category->title }}</h2>
                                    <div class="flex flex-wrap justify-center gap-4 mt-5 mx-auto">
                                        @foreach ($categoryProducts as $product)
                                            <div class="bg-slate-100 dark:bg-zinc-800 rounded-md h-full w-[45%]">
                                                <a
                                                    href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                                    <img loading="lazy"
                                                        src="{{ $product->featured_image ? asset($product->featured_image) : asset('/img/product-placeholder.jpg') }}"
                                                        alt="{{ $product->product_name }}"
                                                        class="rounded-t-md w-full h-auto aspect-[4/3] object-cover">
                                                </a>
                                                <div class="px-3 py-2 justify-between flex-1">
                                                    <a
                                                        href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                                        <h1 class="text-sm font-medium text-center truncate">
                                                            {{ $product->product_name }}</h1>

                                                        @if ($product_price_enabled)
                                                            <h1 class="text-base font-medium text-center"
                                                                style="color: #ca8a04;">
                                                                ${{ $product->price }}
                                                            </h1>
                                                        @endif
                                                    </a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                @endif --}}
                @if ($products->isNotEmpty() && $product_categories->isNotEmpty())
                    <div id="products_by_category" x-cloak x-show="activeTab === 'products_by_category'" x-transition>
                        @foreach ($product_categories as $category)
                            @php
                                $categoryProducts = $products->filter(function ($product) use ($category) {
                                    return is_array($product->category_id) &&
                                        in_array($category->id, $product->category_id);
                                });
                            @endphp

                            @if ($categoryProducts->isNotEmpty())
                                <div>
                                    <h2 class="text-xl font-medium text-center mt-10">{{ $category->title }}</h2>

                                    <div class="flex flex-wrap justify-center gap-4 mt-5 mx-auto">
                                        @foreach ($categoryProducts as $product)
                                            <div class="bg-slate-100 dark:bg-zinc-800 rounded-md h-full w-[45%]">
                                                <a
                                                    href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                                    <img loading="lazy"
                                                        src="{{ $product->featured_image ? asset($product->featured_image) : asset('/img/product-placeholder.jpg') }}"
                                                        alt="{{ $product->product_name }}"
                                                        class="rounded-t-md w-full h-auto aspect-[4/3] object-cover object-top">
                                                </a>
                                                <div class="px-3 py-2 justify-between flex-1">
                                                    <a
                                                        href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                                        <h1 class="text-sm font-medium text-center truncate">
                                                            {{ $product->product_name }}
                                                        </h1>

                                                        @if ($product_price_enabled)
                                                            <h1 class="text-base font-medium text-center"
                                                                style="color: #ca8a04;">
                                                                ${{ $product->price }}
                                                            </h1>
                                                        @endif
                                                    </a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                @endif


                {{-- Daily Deals --}}
                @if ($daily_deals->isNotEmpty())
                    <div id="daily_deals" x-cloak x-show="activeTab === 'daily_deals'" x-transition>
                        <div class="flex flex-wrap justify-center gap-4 mt-5 mx-auto">
                            {{-- <div class="grid grid-cols-2 gap-4 mt-5 px-5 mb-10 items-stretch"> --}}
                            @foreach ($daily_deals as $product)
                                <div class="bg-slate-100 dark:bg-zinc-800 rounded-md h-full w-[45%]">
                                    <div class="relative">
                                        <a
                                            href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                            <img loading="lazy"
                                                src="{{ $product->featured_image ? asset($product->featured_image) : asset('/img/product-placeholder.jpg') }}"
                                                alt="{{ $product->product_name }}"
                                                class="rounded-t-md w-full h-auto aspect-[4/3] object-cover object-top">
                                        </a>

                                        @php
                                            $discount = $product->discount_percentage;

                                            if (
                                                is_null($discount) &&
                                                $product->price > 0 &&
                                                $product->price > $product->final_price
                                            ) {
                                                $discount =
                                                    (($product->price - $product->final_price) / $product->price) * 100;
                                            }
                                        @endphp

                                        {{-- Discount Badge --}}
                                        @if ($discount)
                                            <span
                                                class="absolute top-2 left-2 bg-red-500 text-white text-xs font-bold px-2 py-1 rounded">
                                                {{ round($discount) }}% OFF
                                            </span>
                                        @endif

                                        {{-- @if ($product->discount_percentage)
                                            <span
                                                class="absolute top-2 left-2 bg-red-500 text-white text-xs font-bold px-2 py-1 rounded">
                                                {{ round($product->discount_percentage) }}% OFF
                                            </span>
                                        @endif --}}
                                    </div>

                                    <div class="px-3 py-2 flex flex-col justify-between flex-1">
                                        <a
                                            href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                            <h1 class="text-sm font-medium text-center truncate">
                                                {{ $product->product_name }}</h1>

                                            <h1 class="font-medium text-center">
                                                <span class="text-sm text-gray-400 line-through inline-block">
                                                    ${{ $product->price }}
                                                </span>
                                                <span class="text-base font-bold" style="color: #ca8a04;">
                                                    ${{ $product->final_price }}
                                                </span>
                                            </h1>
                                        </a>

                                        {{-- Quantity selector, etc. --}}
                                        <div class="flex justify-center mt-5">
                                            <div class="flex items-center border rounded-md overflow-hidden">
                                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                                    onclick="updateQuantity('{{ $product->id }}', -1)">-</button>
                                                <input type="number" value="0" min="0"
                                                    data-name="{{ $product->product_name }}"
                                                    data-price="{{ $product->final_price }}"
                                                    data-image="{{ $product->featured_image ?? '' }}"
                                                    data-username="{{ $card->username ?? request()->segment(1) }}"
                                                    id="quantity-{{ $product->id }}"
                                                    class="w-12 text-center border-black focus:ring-0 focus:outline-none text-black"
                                                    oninput="saveToCart('{{ $product->id }}', this.value, this.dataset.name, parseFloat(this.dataset.final_price), this.dataset.image, this.dataset.username)">
                                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                                    onclick="updateQuantity('{{ $product->id }}', 1)">+</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                @if ($products->isNotEmpty())
                    {{-- All Products --}}
                    <div id="all_products" x-cloak x-show="activeTab === 'all_products'" x-transition>
                        @if ($products->isNotEmpty())
                            {{-- <div class="grid grid-cols-2 gap-4 mt-5 px-5 mb-10 items-stretch"> --}}
                            <div class="flex flex-wrap justify-center gap-4 mt-10 mx-auto">
                                @foreach ($products as $product)
                                    @if ($product->is_deal_active)
                                        @continue
                                    @endif
                                    <div class="bg-slate-100 dark:bg-zinc-800 rounded-md h-full w-[45%]">

                                        <div class="relative">
                                            <a
                                                href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                                <img loading="lazy"
                                                    src="{{ $product->featured_image ? asset($product->featured_image) : asset('/img/product-placeholder.jpg') }}"
                                                    alt="{{ $product->product_name }}"
                                                    class="rounded-t-md w-full h-auto aspect-[4/3] object-cover object-top">
                                            </a>

                                            {{-- Discount Badge --}}
                                            @if ($product->discount_percentage && $product->is_deal_active)
                                                <span
                                                    class="absolute top-2 left-2 bg-red-500 text-white text-xs font-bold px-2 py-1 rounded">
                                                    {{ round($product->discount_percentage) }}% OFF
                                                </span>
                                            @endif
                                        </div>

                                        <div class="px-3 py-2 flex flex-col justify-between flex-1">
                                            <a
                                                href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                                <h1 class="text-sm font-medium text-center truncate">
                                                    {{ $product->product_name }}</h1>

                                                {{-- <h1 class="text-base font-medium text-center"
                                                    style="color: {{ $color_settings_link }}">
                                                    ${{ $product->price }}
                                                </h1> --}}

                                                <h1 class="font-medium text-center">
                                                    @if ($product->is_on_deal && $product->is_deal_active)
                                                        <span class="text-sm text-gray-400 line-through inline-block">
                                                            ${{ $product->price }}
                                                        </span>
                                                    @endif
                                                    <span class="text-base font-bold" style="color: #ca8a04;">
                                                        ${{ $product->final_price }}
                                                    </span>
                                                </h1>

                                            </a>
                                            <div class="flex justify-center mt-5">
                                                <div class="flex items-center border rounded-md overflow-hidden">
                                                    <button type="button" class="px-2 py-1 text-lg font-bold"
                                                        onclick="updateQuantity('{{ $product->id }}', -1)">-</button>
                                                    <input type="number" value="0" min="0"
                                                        data-name="{{ $product->product_name }}"
                                                        data-price="{{ $product->price }}"
                                                        data-image="{{ $product->featured_image ?? '' }}"
                                                        data-username="{{ $card->username ?? request()->segment(1) }}"
                                                        id="quantity-{{ $product->id }}"
                                                        class="w-12 text-center border-black focus:ring-0 focus:outline-none text-black"
                                                        oninput="saveToCart('{{ $product->id }}', this.value, this.dataset.name, parseFloat(this.dataset.price), this.dataset.image, this.dataset.username)">
                                                    <button type="button" class="px-2 py-1 text-lg font-bold"
                                                        onclick="updateQuantity('{{ $product->id }}', 1)">+</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                @endif

                <div class="flex justify-center mt-5">
                    {{-- <a href="{{ $shop_more }}" target="_blank"
                        class="mx-1 px-5 py-2 rounded-full text-sm font-medium border border-current transition-all text-center w-fit"
                        style="background-color: {{ $color_settings_custom_button }} !important; color: {{ $color_settings_custom_button_text }} !important;">
                        Shop More
                    </a> --}}

                    <a href="{{ $shop_more }}" target="_blank"
                        class="mx-1 px-5 py-2 @if ($button_style === 'squared') rounded-md @else rounded-full @endif text-base font-medium border border-current transition-all text-center w-fit"
                        style="background-color: #facc15 !important; color: black !important;">
                        Shop More
                    </a>
                </div>
                <p class="mx-auto mt-5 font-medium text-center">Explore our website<br> to shop for more products
                </p>
            </div>

            <div id="cart-footer"
                class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 shadow-lg p-4 flex justify-between items-center z-50 hidden">
                <a href="{{ route('sales.cart', $user->username) }}"
                    class="bg-blue-600 text-white font-bold px-4 py-3 rounded-lg hover:bg-blue-700 transition">
                    Checkout
                </a>
                <span class="font-bold text-lg">Total: $<span id="cart-total">0.00</span></span>
            </div>
        @else
            <div id="custom_bg" class="h-screen flex justify-center items-center">
                <div>
                    <p class="mx-auto text-yellow-500 text-center text-l p-10">
                        <x-ionicon-warning-sharp class="size-32 sm:size-40" />
                    </p>
                    <p class="mx-auto font-medium text-center text-2xl">Page not found</p>
                </div>
            </div>
    @endif
</div>
