<div x-data="{ submitting: false }" x-on:set-submitting.window="submitting = $event.detail.value">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Videos Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.video') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="m15.75 10.5 4.72-4.72a.75.75 0 0 1 1.28.53v11.38a.75.75 0 0 1-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 0 0 2.25-2.25v-9a2.25 2.25 0 0 0-2.25-2.25h-9A2.25 2.25 0 0 0 2.25 7.5v9a2.25 2.25 0 0 0 2.25 2.25Z" />
                </svg>

                &nbsp;&nbsp;Update Video
            </p>
        </div>


    </div>


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <form wire:submit.prevent="updateVideo()" class="px-5" @submit="submitting=true">
            <div class="space-y-12">

                <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">

                    <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">
                        <div class="col-span-full">
                            <label for="title"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Video
                                Title</label>
                            <div class="mt-2">
                                <div
                                    class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('title') border border-red-600 @enderror">

                                    <input type="text" wire:model="title"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="My Video Introduction" value="{{ old('title', $video['title']) }}">
                                </div>
                            </div>
                            @error('title')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="video_type"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Video
                                Type</label>
                            <div class="mt-2 grid grid-cols-1">
                                <select id="video_type" name="video_type" wire:model="video_type"
                                    class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('video_type') border border-red-600 @enderror">
                                    <option disabled
                                        {{ old('video_type', $video['video_type']) === '' ? 'selected' : '' }}>
                                        Select
                                        Video
                                        Type
                                    </option>
                                    <option value="youtube"
                                        {{ old('video_type', $video['video_type']) === 'youtube' ? 'selected' : '' }}>
                                        Youtube
                                    </option>
                                    <option value="vimeo"
                                        {{ old('video_type', $video['video_type']) === 'vimeo' ? 'selected' : '' }}>
                                        Vimeo</option>
                                </select>
                            </div>

                            @error('video_type')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="link"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Video Link
                            </label>
                            <div class="mt-2">
                                <input wire:model="link"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('link') border border-red-600 @enderror"
                                    placeholder="https://www.youtube.com/watch?v=oMqULA7m4Ug"
                                    value="{{ old('link', $video['link']) }}">
                            </div>

                            @error('link')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="button_title"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Custom
                                Thumbnail
                                (Optional)
                            </label>

                            <div class="mt-2">
                                <livewire:video-thumbnail-field :video_thumbnail="$old_thumbnail" />
                            </div>
                        </div>

                        {{-- Button Title --}}
                        <div class="col-span-full">
                            <label for="button_title"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Button Title
                            </label>
                            <div class="mt-2">
                                <input wire:model="button_title"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('button_title') border border-red-600 @enderror"
                                    placeholder="Optional" value="{{ old('button_title', $video['button_title']) }}">
                            </div>

                            @error('button_title')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Button Link --}}
                        <div class="col-span-full">
                            <label for="button_link"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Button Link
                            </label>
                            <div class="mt-2">
                                <input wire:model="button_link"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('button_link') border border-red-600 @enderror"
                                    placeholder="Optional" value="{{ old('button_link', $video['button_link']) }}">
                            </div>

                            @error('button_link')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                </div>

            </div>


            <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                <button type="submit" :disabled="submitting"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">

                    <!-- Normal text -->
                    <span x-show="!submitting">Update
                        Video</span>

                    <!-- Saving text -->
                    <span x-show="submitting" class="inline-flex items-center justify-center space-x-2">
                        <span class="text-white">Saving...</span>
                        <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none"
                            viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                            </path>
                        </svg>
                    </span>
                </button>
            </div>
        </form>
    </div>

</div>
