<div wire:ignore x-data="gallery()" x-cloak x-init="init" @touchstart="startTouch($event)"
    @touchmove="moveTouch($event)" @touchend="endTouch($event)" class="w-full mx-auto flex flex-col content-center px-5">

    <div class="relative overflow-hidden w-full mt-5 rounded-xl">

        <!-- Slides -->
        <div class="flex transition-transform duration-500 ease-in-out"
            :style="`transform: translateX(-${activeIndex * 100 - dragOffset}%)`">

            <template x-for="(slide, sIndex) in slides" :key="'slide-' + sIndex">
                <div class="w-full flex-shrink-0"
                    :class="(slide.length === 1 && slide[0].type === 'Landscape') ? 'flex justify-center' : 'flex'">

                    <template x-for="(image, index) in slide" :key="'img-' + sIndex + '-' + index">
                        <div
                            :class="image.type === 'Landscape' || galleryTwoSlide == 0 ? 'w-full aspect-auto p-0' :
                                'w-1/2 aspect-[1/1] p-1'">
                            <a :href="image.link" target="_blank">
                                <img :src="'/storage/' + image.image_path"
                                    class="w-full h-full object-cover rounded-xl select-none" draggable="false"
                                    style="border: 2px solid <?php echo e($color_settings_profile_pic_border); ?>;" />
                            </a>
                        </div>
                    </template>

                </div>
            </template>
        </div>
    </div>

    <!-- Dots -->
    <template x-if="slides.length > 1">
        <div class="flex justify-center mt-5 gap-2">
            <template x-for="(slide, index) in slides" :key="'dot-' + index">
                <button
                    :style="activeIndex === index ?
                        'background-color: <?php echo e($color_settings_profile_pic_border); ?> !important' :
                        'background-color: gray !important; opacity: 0.2;'"
                    class="w-[18px] h-[18px] rounded-full mx-[4px]" @click="goTo(index)">
                </button>
            </template>
        </div>
    </template>

    <?php $__env->startPush('scripts'); ?>
        <script>
            function gallery() {
                return {
                    images: <?php echo \Illuminate\Support\Js::from($images)->toHtml() ?>,
                    galleryTwoSlide: <?php echo \Illuminate\Support\Js::from($gallery_two_slide)->toHtml() ?>, // new flag from backend
                    slides: [],
                    activeIndex: 0,
                    timer: null,
                    startX: 0,
                    currentX: 0,
                    dragOffset: 0,
                    isDragging: false,

                    init() {
                        this.prepareSlides();
                        this.resetTimer();
                    },

                    prepareSlides() {
                        this.slides = [];
                        let i = 0;

                        // If galleryTwoSlide is false, make all slides single image
                        if (this.galleryTwoSlide == 0) {
                            while (i < this.images.length) {
                                this.slides.push([this.images[i]]);
                                i++;
                            }
                            return;
                        }

                        // Otherwise use the original landscape/square pairing logic
                        while (i < this.images.length) {
                            if (this.images[i].type === 'Landscape') {
                                this.slides.push([this.images[i]]);
                                i++;
                            } else {
                                this.slides.push(this.images.slice(i, i + 2));
                                i += 2;
                            }
                        }
                    },

                    resetTimer() {
                        if (this.slides.length <= 1) return;
                        if (this.timer) clearInterval(this.timer);
                        this.timer = setInterval(() => this.next(), 5000);
                    },

                    next() {
                        if (this.slides.length > 1) {
                            this.activeIndex = (this.activeIndex + 1) % this.slides.length;
                        }
                    },

                    prev() {
                        if (this.slides.length > 1) {
                            this.activeIndex = (this.activeIndex - 1 + this.slides.length) % this.slides.length;
                        }
                    },

                    goTo(index) {
                        this.activeIndex = index;
                        this.resetTimer();
                    },

                    startTouch(e) {
                        this.startX = e.touches[0].clientX;
                        this.currentX = this.startX;
                        this.isDragging = true;
                        this.dragOffset = 0;
                        clearInterval(this.timer);
                    },

                    moveTouch(e) {
                        if (!this.isDragging) return;
                        this.currentX = e.touches[0].clientX;
                        const moved = this.currentX - this.startX;
                        this.dragOffset = (moved / window.innerWidth) * 100;
                    },

                    endTouch(e) {
                        if (!this.isDragging) return;
                        this.isDragging = false;

                        if (this.dragOffset > 20) {
                            this.prev();
                        } else if (this.dragOffset < -20) {
                            this.next();
                        }

                        this.dragOffset = 0;
                        this.resetTimer();
                    },
                }
            }
        </script>
    <?php $__env->stopPush(); ?>
</div>
<?php /**PATH /Users/giojitsu_mma/Documents/Sites/10kcards.site/resources/views/livewire/gallery-component.blade.php ENDPATH**/ ?>