<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service;

use Google\Client;

/**
 * Service definition for DataManager (v1).
 *
 * <p>
 * A unified ingestion API for data partners, agencies and advertisers to
 * connect first-party data across Google advertising products.</p>
 *
 * <p>
 * For more information about this service, see the API
 * <a href="https://developers.google.com/data-manager" target="_blank">Documentation</a>
 * </p>
 *
 * @author Google, Inc.
 */
class DataManager extends \Google\Service
{
  /** See, edit, create, import, or delete your customer data in Google Ads, Google Marketing Platform (Campaign Manager 360, Search Ads 360, Display & Video 360), and Google Analytics. */
  const DATAMANAGER =
      "https://www.googleapis.com/auth/datamanager";

  public $audienceMembers;
  public $events;
  public $requestStatus;
  public $rootUrlTemplate;

  /**
   * Constructs the internal representation of the DataManager service.
   *
   * @param Client|array $clientOrConfig The client used to deliver requests, or a
   *                                     config array to pass to a new Client instance.
   * @param string $rootUrl The root URL used for requests to the service.
   */
  public function __construct($clientOrConfig = [], $rootUrl = null)
  {
    parent::__construct($clientOrConfig);
    $this->rootUrl = $rootUrl ?: 'https://datamanager.googleapis.com/';
    $this->rootUrlTemplate = $rootUrl ?: 'https://datamanager.UNIVERSE_DOMAIN/';
    $this->servicePath = '';
    $this->batchPath = 'batch';
    $this->version = 'v1';
    $this->serviceName = 'datamanager';

    $this->audienceMembers = new DataManager\Resource\AudienceMembers(
        $this,
        $this->serviceName,
        'audienceMembers',
        [
          'methods' => [
            'ingest' => [
              'path' => 'v1/audienceMembers:ingest',
              'httpMethod' => 'POST',
              'parameters' => [],
            ],'remove' => [
              'path' => 'v1/audienceMembers:remove',
              'httpMethod' => 'POST',
              'parameters' => [],
            ],
          ]
        ]
    );
    $this->events = new DataManager\Resource\Events(
        $this,
        $this->serviceName,
        'events',
        [
          'methods' => [
            'ingest' => [
              'path' => 'v1/events:ingest',
              'httpMethod' => 'POST',
              'parameters' => [],
            ],
          ]
        ]
    );
    $this->requestStatus = new DataManager\Resource\RequestStatus(
        $this,
        $this->serviceName,
        'requestStatus',
        [
          'methods' => [
            'retrieve' => [
              'path' => 'v1/requestStatus:retrieve',
              'httpMethod' => 'GET',
              'parameters' => [
                'requestId' => [
                  'location' => 'query',
                  'type' => 'string',
                ],
              ],
            ],
          ]
        ]
    );
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DataManager::class, 'Google_Service_DataManager');
